#include "mpi.h"
#include "mpiimpl.h"

int set_and_exec_cmds(hostname, port, argc, argv)
int argc;
char *hostname, *port, *argv[];
{
  char cmd[256];
  char args[256];
  int i, fd;
  pid_t pid;

  args[0] = '\0';
  for (i=1; i < argc; i++) sprintf(args+strlen(args), "%s ", argv[i]);
  for(i=1; i < PG_ARRAY_SIZE && pg_array[i].processor != NULL; i++)
  {
    /* If localhost, avoid overhead and portability issues of local loop */
    if ( 0 == strcmp("localhost",  pg_array[i].processor) )
      sprintf(cmd, "cd; exec %s %s %s -p4amslave",
	      pg_array[i].process, hostname, port);
    /* Assumes user shell on remote processor accepts "exec" */
    else sprintf(cmd, "exec rsh %s exec %s %s %s %s -p4amslave",
	    pg_array[i].processor, pg_array[i].process, args, hostname, port);
#ifdef DEBUG
    printf("cmd:  %s\n",cmd);
#endif
    CALL_CHK( pid = fork, () );
    if (pid == (pid_t)0) {  /* if child process */

      /* Could have used "rsh -n" to redirect stdin, but position of "-n"
         in "rsh" varies according to different dialects. */
#ifndef STDIN_FILENO
#define STDIN_FILENO 0 /* Should be standard in most dialects -- just in case */
#endif
      close(STDIN_FILENO);
      CALL_CHK( fd = open, ("/dev/null", O_RDONLY) );
      if ( fd != STDIN_FILENO ) { /* fd should be stdin, but check to be safe */
        CALL_CHK( dup2, (fd, STDIN_FILENO) );
        close( fd );
      }
      
#if 0
      /* Some problem for this on alpha, when stdin used (as in GCL) ?? */
      /* Also, system is preferred, because one can add
	">debug1.out" to procgroup file for slave output, for example. */
      execlp("rsh", pg_array[i].processor, "exec", pg_array[i].process,
	     hostname, port, "-p4amslave");
#else
      system(cmd);
#endif
      exit(0); /* child exits after slave finishes */
    }
    cmd[0] = '\0';
  }
  return i - 1; /* return number of slaves */
}
