# pkg/gapmpi/lib/slavelist.g already defines a ParList() from primitives.
# This code provides an example using MasterSlave().

MSParList := function(list, fnc)
  local i, result, SetTaskInput, DoTask, GetTaskOutput, UpdateEnvironment;
  result := [];
  i := 0;
  SetTaskInput := function()
    if i < Length(list) then i := i+1; return i;
    else return NOTASK;
    fi;
  end;
  DoTask := i -> fnc(list[i]);   # Apply fnc above.
  GetTaskOutput := function(output, input)
    result[input] := output;
    return NO_ACTION;
  end;
  UpdateEnvironment := function(output, input); end;
  MasterSlave( SetTaskInput, DoTask, GetTaskOutput, UpdateEnvironment );
  return result;
end;


#This makes it easier to call.
# If we had read this in using ParRead(), then we wouldn't have
#   to broadcast the definition of MSMultMat() to all the slaves.
MyParList := function(list, fnc)
  BroadcastMsg( PrintToString("MSParList := ", MSParList) );
  return ParEval( PrintToString("MSParList(", fnc, ",", list, ")") );
end;
