# The following happens reliably for the ParReset() code below, when
# running on Linux 2.0, i586, using two slaves at localhost.
# On Solaris, this did not work, and I needed a timing loop in the current
# code.
# The issue is that InterruptSlave() must only be used on a slave
# that is in the middle of a computation, and not on a Slave waiting
# to receive a new message.  Fully debugging that requires tracing
# the interaction between GAP and the different UNIX dialects:
# something I haven't had the patience to do so far.

# gap> SendRecvMsg(3);
# true
# gap> ParReset();    
# 1
# gap> ParReset();    
# -2
# gap> ParReset();
# 0


ParReset := function()
  local count, slave;
  # Do this first, in case a slave is stuck in MasterSlave mode.
  for slave in [1..MPI_Comm_size()-1] do
        SendMsg( false, slave, MASTER_SLAVE_QUIT_TAG );
  od;
  count := 0;
  for slave in [1..MPI_Comm_size()-1] do
    SendMsg( false, slave, PING_TAG );
    count := count - 1;
  od;
  for slave in [1..MPI_Comm_size()-1] do
    while MPI_Iprobe( slave ) do
      RecvStringMsg( slave );  # don't evaluate, just throw away
      count := count + 1;
    od;
    if MPI_Get_tag() <> PING_TAG then
      InterruptSlave( slave );
    fi;
  od;
  while MPI_Iprobe( ) do
    RecvStringMsg();  # don't evaluate, just throw away
    count := count + 1;
  od;
  PingSlave( -1 );  # -1 means all slaves
  return count;
end;

