#!/bin/sh

DESTDIR=$HOME/mygap4beta

if [ ! -z "$1" ]; then
  if [ ! -d $1  -o ! -f $1/src/gap.c ]; then
    echo $1 is not a GAP root directory
    exit
  fi;
  echo Will use:  GAP_DIR=$1
  GAP_DIR=$1
else
  echo SYNTAX:  ./install-gapmpi-4b3.sh GAP_SOURCE_DIR
  echo "  " This will create a new $HOME/mygap4beta  with symbolic links
  echo    to save on disk space.
  exit
fi
if [ -w $DESTDIR ]; then
  echo $DESTDIR already exists
  echo If you want to start over, try copying your files to a safe place, and:
  echo "    " rm -rf $DESTDIR
  exit
fi
if [ ! -f ../gap4b3-src-gap.c ]; then
  echo Couldn"'"t find gap4b3-src-gap.c
  echo You must be in the original directory where you found this script
  echo when you execute it.
fi
if ( ! grep 'VERSION := "Beta 3";' $DESTDIR/lib/version.g > /dev/null ) ; then
  echo This isn"'"t GAP-4 Beta 3.  It"'"s
  grep ^VERSION $DESTDIR/lib/version.g
  exit
fi
if ( grep 'GAPMPI' $DESTDIR/src/gap.c > /dev/null ) ; then
  echo The destination directory appears to already have a GAPMPI patch.
  exit 
fi

./install-private-gap.sh $GAP_DIR $DESTDIR
if [ ! -d $DESTDIR/pkg ]; then
  if [ -f $DESTDIR/pkg ]; then
    echo WARNING:  $DESTDIR/pkg is not a directory.
    echo Consider deleting it, and calling this script again.
  fi;
  mkdir $DESTDIR/pkg
  rm -fr $DESTDIR/pkg/gapmpi
fi;
cp -r . $DESTDIR/pkg/gapmpi

# This should be safe, if we started with exactly gap4b3
cp gap4b3-src-funcs.c $DESTDIR/src/funcs.c
cp gap4b3-src-gap.c $DESTDIR/src/gap.c
cp gap4b3-src-streams.c $DESTDIR/src/streams.c
cp gap4b3-lib-init.g $DESTDIR/lib/init.g

cd $DESTDIR
cp pkg/gapmpi/src/* src/
cp pkg/gapmpi/lib/* lib/
cp pkg/gapmpi/procgroup .
./configure
for file in bin/i?86-* ; do
  cp pkg/gapmpi/gap4b3-bin-i586-Makefile $file/Makefile
done
if [ ! -f bin/gap.sh ]; then
  echo $DESTDIR/bin/gap.sh missing from distribution.
  echo Can"'"t do make without it.
  exit
fi
if (uname -srm | grep 'Linux 2.*i[3-9]86' > /dev/null ); then
  make
else
  echo Not a Linux 2.x ix86 system
  echo You"'"ll have to modify your 'bin/*/Makefile'
  echo as in ../README.install-gapmpi or as in gap4b3-bin-i586-Makefile
  echo  unless the GAP 4.x autoconf now does that automatically for you.
fi
