#Environment: m1, m2t, result (three matrices, m2t is transpose of m2)
#TaskInput:   i (row index of result matrix)
#TaskOutput:  result[i] (row of result matrix)
#Task:        Compute result[i] from i, m1, and m2
#UpdateEnvironment:  Given result[i] and i, modify result on all processes.
MSMultMat := function(m1, m2)
  local i, n, m2t, result, SetTaskInput, DoTask, GetTaskOutput,
         UpdateEnvironment;
  n := Length(m1);
  result := [];
  m2t := TransposedMat(m2);

  i:=0;
  SetTaskInput := function()
    i := i + 1;
    if i <= n then return i;
    else return NOTASK;
    fi;
  end;
  DoTask := function(i) # i is task input
    local j, k, sum;
    result[i] := [];
    for j in [1..n] do
      sum := 0;
      for k in [1..n] do
        sum := sum + m1[i][k]*m2t[j][k];
      od;
      result[i][j] := sum;
    od;
    return result[i]; # return task output, row_i
  end;
  # GetTaskOutput executes only on the master
  GetTaskOutput := function(row_i, i) # task output is row_i
    return UPDATE_ACTION; # Pass on output and input to UpdateEnvironment
  end;
  # UpdateEnvironment executes on the master and on all slaves
  UpdateEnvironment := function(row_i, i) # task output is row_i
    result[i] := row_i;
  end;
  # We're done defining the task.  Let's do it now.
  MasterSlave( SetTaskInput, DoTask, GetTaskOutput, UpdateEnvironment );
  # result is defined on all processes; ParEval() will return local value
  return result;
end;

#This makes it easier to call.
# If we had read this in using ParRead(), then we wouldn't have
#   to broadcast the definition of MSMultMat() to all the slaves.
ParMultMat := function(m1, m2)
  BroadcastMsg( PrintToString("MSMultMat := ", MSMultMat) );
  return ParEval( PrintToString("MSMultMat(", m1, ",", m2, ")") );
end;
