/**
 * This class provides the back-end work for the project.
 *
 * Christopher Cahill, CSG120, Spring 2005.
 */

import java.util.*;

public class Work {
    private Logic l;
    private KB kb;
    private static boolean DEBUG = false;

    public Work() {
	l = new Logic();
	kb = new KB();
    }

    public boolean debug() {
	return DEBUG;
    }

    public void populateKB() {
	Vector v = new Vector();
	Codes list = new Codes();
	Claim claim = new Claim();

	v = new Vector();
	v.addElement(list.getCodeByNum(1001));
	v.addElement(list.getCodeByNum(2001));
	v.addElement(list.getCodeByNum(2002));
	claim = new Claim(v);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);

	v = new Vector();
	v.addElement(list.getCodeByNum(1001));
	v.addElement(list.getCodeByNum(2002));
	v.addElement(list.getCodeByNum(2003));
	claim = new Claim(v);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);

	v = new Vector();
	v.addElement(list.getCodeByNum(1002));
	v.addElement(list.getCodeByNum(2004));
	v.addElement(list.getCodeByNum(2005));
	v.addElement(list.getCodeByNum(2009));
	claim = new Claim(v);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);

	v = new Vector();
	v.addElement(list.getCodeByNum(1002));
	v.addElement(list.getCodeByNum(2004));
	v.addElement(list.getCodeByNum(2005));
	v.addElement(list.getCodeByNum(2009));
	v.addElement(list.getCodeByNum(2010));
	v.addElement(list.getCodeByNum(3002));
	claim = new Claim(v);
	kb.addClaim(claim);
	kb.addClaim(claim);

	v = new Vector();
	v.addElement(list.getCodeByNum(1003));
	v.addElement(list.getCodeByNum(2007));
	claim = new Claim(v);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);

	v = new Vector();
	v.addElement(list.getCodeByNum(1003));
	v.addElement(list.getCodeByNum(2008));
	claim = new Claim(v);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);

	v = new Vector();
	v.addElement(list.getCodeByNum(1003));
	v.addElement(list.getCodeByNum(2008));
	v.addElement(list.getCodeByNum(2010));
	v.addElement(list.getCodeByNum(3002));
	claim = new Claim(v);
	kb.addClaim(claim);

	v = new Vector();
	v.addElement(list.getCodeByNum(1004));
	v.addElement(list.getCodeByNum(2001));
	v.addElement(list.getCodeByNum(2002));
	v.addElement(list.getCodeByNum(2006));
	claim = new Claim(v);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);

	v = new Vector();
	v.addElement(list.getCodeByNum(1004));
	v.addElement(list.getCodeByNum(2002));
	v.addElement(list.getCodeByNum(2003));
	v.addElement(list.getCodeByNum(2006));
	claim = new Claim(v);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);

	v = new Vector();
	v.addElement(list.getCodeByNum(1005));
	v.addElement(list.getCodeByNum(2011));
	claim = new Claim(v);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);

	v = new Vector();
	v.addElement(list.getCodeByNum(1005));
	v.addElement(list.getCodeByNum(2011));
	v.addElement(list.getCodeByNum(2012));
	v.addElement(list.getCodeByNum(3001));
	claim = new Claim(v);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);

	v = new Vector();
	v.addElement(list.getCodeByNum(1005));
	v.addElement(list.getCodeByNum(2010));
	v.addElement(list.getCodeByNum(2011));
	v.addElement(list.getCodeByNum(3002));
	claim = new Claim(v);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);

	v = new Vector();
	v.addElement(list.getCodeByNum(1005));
	v.addElement(list.getCodeByNum(2010));
	v.addElement(list.getCodeByNum(2011));
	v.addElement(list.getCodeByNum(2012));
	v.addElement(list.getCodeByNum(3001));
	v.addElement(list.getCodeByNum(3002));
	claim = new Claim(v);
	kb.addClaim(claim);
	kb.addClaim(claim);
	kb.addClaim(claim);
    }

    public void printKB() {
	System.out.println("Printing Knowledge Base:");
	for (int i = 0; i < kb.size(); i++) {
	    System.out.println("Printing claim " + (i + 1) + ":");
	    kb.printClaim(i);
	    System.out.print("\n");
	}
    }

    /**
     * Returns a Vector containing all recommended codes for a given Claim.
     */
    public Vector codeRecs(Claim c) {
	Vector codes = new Vector();
	Vector a = c.getAllCodes();
	for(int i = 0; i < a.size(); i++) {
	    Vector temp = treeRecs(((Code)a.get(i)));
	    for(int x = 0; x < temp.size(); x++)
		codes.addElement(temp.get(x));
	}

	for(int i = 0; i < codes.size(); i++) {
	    Code t = (Code)codes.get(i);
	    if(c.inClaim(t)) {
		codes.removeElementAt(i);
		i--;
	    }
	}

	codes = trimRecs(codes);

	return codes;
    }

    private Vector trimRecs(Vector recs) {
	for(int i = 0; i < (recs.size() - 1); i++) {
	    for(int x = (i + 1); x < recs.size(); x++) {
		if(((Code)recs.get(i)).getCode() == ((Code)recs.get(x)).getCode()) {
		    recs.removeElementAt(x);
		    x--;
		}
	    }
	}

	return recs;
    }

    /**
     * Return a Vector of recommended Codes from a given Code.
     */
    private Vector treeRecs(Code c) {
	//Contains the recommendations.
	Vector v = new Vector();
       
	for(int i = 0; i < kb.size(); i++) {
	    Claim claim = kb.getClaim(i);
	    if(claim.inClaim(c)) {
		Vector a = claim.getAllCodes();
		for(int x = 0; x < a.size(); x++)
		    if((((Code)a.get(x)).getCode() != c.getCode()) &&
		       ((((Code)a.get(x)).getCode() - 1000) > 1000))
			v.addElement(a.get(x));
	    }
	}

	return v;
    }

    /**
     * This class may run standalone. It will require recompilation after
     *  each claim, or set of claims, however.
     */
    public static void main(String[] args) {
	Work w = new Work();
	w.populateKB();
	if(w.debug())
	    w.printKB();

	Codes l = new Codes();
	Vector v = new Vector();
	v.addElement(l.getCodeByNum(1005));
	v.addElement(l.getCodeByNum(2011));
	Claim claim = new Claim(v);

	Vector recs = w.codeRecs(claim);

	System.out.println("Given claim:");
	claim.printClaim();
	System.out.println("\nThe possible missed codes are:");
	for(int i = 0; i < recs.size(); i++)
	    ((Code)recs.get(i)).printCode();
	System.out.println("------------------------------\n");

	v = new Vector();
	v.addElement(l.getCodeByNum(1001));
	v.addElement(l.getCodeByNum(2001));
	claim = new Claim(v);

	recs = w.codeRecs(claim);

	System.out.println("Given claim:");
	claim.printClaim();
	System.out.println("\nThe possible missed codes are:");
	for(int i = 0; i < recs.size(); i++)
	    ((Code)recs.get(i)).printCode();
	System.out.println("------------------------------\n");

	v = new Vector();
	v.addElement(l.getCodeByNum(1003));
	v.addElement(l.getCodeByNum(2007));
	claim = new Claim(v);

	recs = w.codeRecs(claim);

	System.out.println("Given claim:");
	claim.printClaim();
	System.out.println("\nThe possible missed codes are:");
	for(int i = 0; i < recs.size(); i++)
	    ((Code)recs.get(i)).printCode();
	System.out.println("------------------------------\n");

	v = new Vector();
	v.addElement(l.getCodeByNum(1002));
	v.addElement(l.getCodeByNum(2005));
	v.addElement(l.getCodeByNum(2004));
	claim = new Claim(v);

	recs = w.codeRecs(claim);

	System.out.println("Given claim:");
	claim.printClaim();
	System.out.println("\nThe possible missed codes are:");
	for(int i = 0; i < recs.size(); i++)
	    ((Code)recs.get(i)).printCode();
	System.out.println("------------------------------\n");

	v = new Vector();
	v.addElement(l.getCodeByNum(1002));
	v.addElement(l.getCodeByNum(1004));
	v.addElement(l.getCodeByNum(2003));
	v.addElement(l.getCodeByNum(2004));
	v.addElement(l.getCodeByNum(2005));
	claim = new Claim(v);

	recs = w.codeRecs(claim);

	System.out.println("Given claim:");
	claim.printClaim();
	System.out.println("\nThe possible missed codes are:");
	for(int i = 0; i < recs.size(); i++)
	    ((Code)recs.get(i)).printCode();
	System.out.println("------------------------------\n");

	v = new Vector();
	v.addElement(l.getCodeByNum(1004));
	v.addElement(l.getCodeByNum(2002));
	v.addElement(l.getCodeByNum(2003));
	v.addElement(l.getCodeByNum(2006));
	claim = new Claim(v);

	recs = w.codeRecs(claim);

	System.out.println("Given claim:");
	claim.printClaim();
	System.out.println("\nThe possible missed codes are:");
	for(int i = 0; i < recs.size(); i++)
	    ((Code)recs.get(i)).printCode();
	System.out.println("------------------------------\n");
    }
}
