/**
 * This class provides the bulk of the work for Medical Coding Expert.
 *
 * Christopher Cahill, CSG120, Spring 2005.
 */

import java.util.*;
import java.lang.Number.*;

public class Logic {

    //Contains the number of claims the last code was found in
    private int numClaims;
    //Contains the percentage of claims the last code was found in
    private int percentClaims;

    public Logic() {
	numClaims = 0;
	percentClaims = 0;
    }

    public int getNumClaims() {
	return numClaims;
    }

    public int getPercentClaims() {
	return percentClaims;
    }

    public Vector populateSearchVector(Claim c) {
	Vector y = new Vector();
	Vector x = c.getDiags();
	for(int i = 0; i < x.size(); i++)
	    y.addElement(x.get(i));
	x = c.getProcs();
	for(int i = 0; i < x.size(); i++)
	    y.addElement(x.get(i));
	x = c.getComps();
	for(int i = 0; i < x.size(); i++)
	    y.addElement(x.get(i));

	return y;
    }

    public void claimNumbers(Vector codes, Code codeToCheck, KB kb) {
	//Hold all prior claims in a vector for ease of use
	Vector priorClaims = new Vector();
	//Hold which claims have the codes to check
	Vector claimsWithCodes = new Vector(); 

	numClaims = 0; //Number of Claims codeToCheck appears in

	// Populate priorClaims
	for(int i = 0; i < kb.size(); i++) {
	    priorClaims.addElement(kb.getClaim(i));
	}

	//int values of codes to be checked
	int[] codeValues = new int[codes.size()]; 
	for(int i = 0; i < codes.size(); i++) {
	    Code x = (Code)codes.get(i);
	    codeValues[i] = x.getCode();
	}

	//Check codes against priorClaims
	for(int i = 0; i < priorClaims.size(); i++) {
	    Claim a = (Claim)priorClaims.get(i);
	    int[] foundValues = new int[codes.size()];
	    for (int x = 0; x < codes.size(); x++) {
		foundValues[x] = codeValues[x];
	    }
	    //Populate search vector with codes in claim
	    Vector search = populateSearchVector(a);
	    
	    for(int x = 0; x < search.size(); x++) {
		int z = ((Code)search.get(x)).getCode();
		//foundValues same size as codes
		for(int d = 0; d < codes.size(); d++) 
		    if (z == foundValues[d])
			foundValues[d] = 0;
	    }
	    boolean allFound = true;
	    //foundValues same size as codes
	    for(int x = 0; x < codes.size(); x++) { 
		if (foundValues[x] != 0) {
		    allFound = false;
		    break;
		}
	    }
	    if (allFound) {
		Integer x = new Integer(i);
		claimsWithCodes.addElement(x);
	    }
	}

	for(int i = 0; i < claimsWithCodes.size(); i++) {
	    Integer x = (Integer)claimsWithCodes.get(i);
	    int claimNumber = x.intValue();
	    Claim currentClaim = (Claim)priorClaims.get(claimNumber);

	    // populate the search vector
	    Vector search = populateSearchVector(currentClaim);
	    for(int n = 0; n < search.size(); n++) {
		Code m = (Code)search.get(n);
		int codeValue = m.getCode();
		if (codeValue == codeToCheck.getCode()) {
		    numClaims++;
		    break;
		}
	    }
	}

	percentClaims = (int)((((double)numClaims) / ((double)claimsWithCodes.size())) * 100);
    }

    public static void main(String[] args) {
	Logic l = new Logic();
	KB kb = new KB();
	Codes list = new Codes();

	Vector v = new Vector();
	Code b = list.getCodeByNum(1001);
	v.addElement(b);
	b = list.getCodeByNum(2005);
	v.addElement(b);
	Claim c1 = new Claim(v);

	kb.addClaim(c1);

	v = new Vector();
	b = list.getCodeByNum(1001);
	v.addElement(b);
	b = list.getCodeByNum(1005);
	v.addElement(b);
	b = list.getCodeByNum(2005);
	v.addElement(b);
	b = list.getCodeByNum(2010);
	v.addElement(b);
	b = list.getCodeByNum(2012);
	v.addElement(b);
	c1 = new Claim(v);

	kb.addClaim(c1);

	v = new Vector();
	b = list.getCodeByNum(1003);
	v.addElement(b);
	b = list.getCodeByNum(1005);
	v.addElement(b);
	b = list.getCodeByNum(2002);
	v.addElement(b);
	b = list.getCodeByNum(2010);
	v.addElement(b);
	b = list.getCodeByNum(2012);
	v.addElement(b);
	b = list.getCodeByNum(3002);
	v.addElement(b);
	c1 = new Claim(v);

	kb.addClaim(c1);

	v = new Vector();
	b = list.getCodeByNum(1001);
	v.addElement(b);
	b = list.getCodeByNum(2005);
	v.addElement(b);
	b = list.getCodeByNum(2010);

	l.claimNumbers(v, b, kb);

	System.out.println("Code:");
	b.printCode();
	System.out.println("found in " + l.getNumClaims() + " claims ("
			   + l.getPercentClaims()
			   + "% of total claims) with these codes:");
	for(int i = 0; i < v.size(); i++) {
	    ((Code)v.get(i)).printCode();
	}
	System.out.print("\n");
    }	
}
