/**
 * This Class contains a Vector of all valid codes.
 *
 * Christopher Cahill, CSG120, Spring 2005.
 */

import java.util.*;

public class Codes {
    private Vector allCodes;

    public Codes() {
	allCodes = new Vector();
	allCodes.addElement(new Code(1001, "Forearm Lesion"));
	allCodes.addElement(new Code(1002, "Broken Leg"));
	allCodes.addElement(new Code(1003, "Rash"));
	allCodes.addElement(new Code(1004, "Animal Bite"));
	allCodes.addElement(new Code(1005, "Drug Overdose"));
	allCodes.addElement(new Code(2001, "Stitches"));
	allCodes.addElement(new Code(2002, "Topical Anisthetic"));
	allCodes.addElement(new Code(2003, "Staples"));
	allCodes.addElement(new Code(2004, "Cast"));
	allCodes.addElement(new Code(2005, "X-Ray"));
	allCodes.addElement(new Code(2006, "Rabies Test"));
	allCodes.addElement(new Code(2007, "Topical Ointment A"));
	allCodes.addElement(new Code(2008, "Topical Ointment B"));
	allCodes.addElement(new Code(2009, "Oral Drug A"));
	allCodes.addElement(new Code(2010, "Oral Drug B"));
	allCodes.addElement(new Code(2011, "Intravenous Drug A"));
	allCodes.addElement(new Code(2012, "Intravenous Drug B"));
	allCodes.addElement(new Code(3001, "Drug Interaction"));
	allCodes.addElement(new Code(3002, "Allergic Reaction"));
    }

    public Code getCodeByNum(int a) {
	int x;
	for(int i = 0; i < allCodes.size(); i++) {
	    Code y = (Code)allCodes.get(i);
	    x = y.getCode();
	    if(x == a)
		return (Code)allCodes.get(i);
	}
	return new Code(0, "Code not found.");
    }

    public Code getCodeByDesc(String a) {
	String x;
	for(int i = 0; i < allCodes.size(); i++) {
	    Code y = (Code)allCodes.get(i);
	    x = y.getDesc();
	    if(x.equals(a))
		return (Code)allCodes.get(i);
	}
	return new Code(0, "Code not found.");
    }

    public void printCodes() {
	for(int i = 0; i < allCodes.size(); i++) {
	    Code x = (Code)allCodes.get(i);
	    x.printCode();
	}
    }

    public static void main(String[] args) {
	Codes c = new Codes();
	c.printCodes();
    }
}
