/**
 * This class defines a claim.
 *
 * Christopher Cahill, CSG120, Spring 2005.
 */

import java.util.*;

public class Claim {
    private Vector d; //Holds the Diagnosis code(s)
    private Vector p; //Holds the Procedure code(s)
    private Vector c; //Holds the Complication code(s)

    /**
     * Initialize the vectors.
     */
    public Claim() {
	d = new Vector();
	p = new Vector();
	c = new Vector();
    }

    /**
     * Initialize the vectors with supplied vectors.
     */
    public Claim(Vector diags, Vector procs, Vector comps) {
	d = diags;
	p = procs;
	c = comps;
    }

    /**
     * Initialized the vectors by parsing an unsorted vector.
     */
    public Claim(Vector a) {
	this();
	parse(a);
    }

    /**
     * Provide GET functions for the groups of codes.
     */

    public Vector getDiags() {
	return d;
    }

    public Vector getProcs() {
	return p;
    }

    public Vector getComps() {
	return c;
    }

    /**
     * Provide a method of printing the claims to System.out
     */
    public void printClaim() {
	printDiags();
	printProcs();
	printComps();
    }
	
    private void printDiags() {
	System.out.println("Diagnosis code(s):");
	for(int i = 0; i < d.size(); i++) {
	    Code x = (Code)d.get(i);
	    x.printCode();
	}
    }

    private void printProcs() {
	System.out.println("Procedure code(s):");
	for(int i = 0; i < p.size(); i++) {
	    Code x = (Code)p.get(i);
	    x.printCode();
	}
    }

    private void printComps() {
	System.out.println("Complication code(s):");
	for(int i = 0; i < c.size(); i++) {
	    Code x = (Code)c.get(i);
	    x.printCode();
	}
    }

    public Vector getAllCodes() {
	Vector v = new Vector();
	for(int i = 0; i < d.size(); i++)
	    v.addElement(d.get(i));
	for(int i = 0; i < p.size(); i++)
	    v.addElement(p.get(i));
	for(int i = 0; i < c.size(); i++)
	    v.addElement(c.get(i));

	return v;
    }

    /**
     * Parse a vector of all codes into the proper places.
     */
    public boolean parse(Vector a) {
	int numCodes = a.size();

	for(int i = 0; i < numCodes; i++) {
	    Code x = (Code)a.get(i);
	    int claimNum = x.getCode();
	    if ((claimNum - 1000) < 1000) //Diagnosis codes start with 10--
		d.addElement(a.get(i));
	    else if ((claimNum - 2000) < 1000) //Proc. codes start with 20--
		p.addElement(a.get(i));
	    else if ((claimNum - 3000) < 1000) //Comp. codes start with 30--
		c.addElement(a.get(i));
	    else
		return false; //Something is wrong with the supplied vector
	}
	return true; //All codes read successfully
    }

    public boolean inClaim(Code code) {
	Vector v = new Vector();
	if((code.getCode() - 1000) < 1000)
	    v = d;
	else if((code.getCode() - 2000) < 1000)
	    v = p;
	else
	    v = c;
	boolean found = false;
	for(int i = 0; i < v.size(); i++)
	    if(code.getCode() == ((Code)v.get(i)).getCode()) {
		found = true;
		break;
	    }

	return found;
    }

    /**
     * Main function used to test that the Claim functions work.
     */
    public static void main(String[] args) {
	Codes list = new Codes();
	Vector test = new Vector();

	Code b = list.getCodeByNum(1001);
	test.addElement(b);
	b = list.getCodeByNum(2003);
	test.addElement(b);
	b = list.getCodeByNum(2011);
	test.addElement(b);
	b = list.getCodeByNum(3001);
	test.addElement(b);

	System.out.println("Test Vector:");
	for (int i = 0; i < test.size(); i++) {
	    ((Code)test.get(i)).printCode();
	}

	Claim a = new Claim();
	a.parse(test);
	a.printClaim();
    }
}
