package edu.neu.ccs.demeterf.views;

import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.views.classes.*;
import edu.neu.ccs.demeterf.views.classes.ParseException;
import edu.neu.ccs.demeterf.demfgen.IncludeCDs;
import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.lib.List;

import java.io.*;

/**  */
public class IncludeViews{
    public static List<View> resolveViews(String file) throws IOException,ParseException{
        View v = View.parse(new FileInputStream(file));
        return new Traversal(new ReadViews(file)).<List<View>>traverse(v.getIncl()).push(v);
    }
    public static List<View> resolveViews(IncludeList l, String par){
        return new Traversal(new ReadViews(par)).traverse(l);
    }
    public static List<ViewDef> allViews(List<View> l){
        return l.fold(new List.Fold<View, List<ViewDef>>(){
            public List<ViewDef> fold(View f, List<ViewDef> r){
                return r.append(f.getViews());
            }},List.<ViewDef>create());
    }

    static class ReadViews extends IncludeCDs.Read<View>{
        ReadViews(String p){ super(p, new NoGen()); }
        protected String type(){ return "VIEW";}
        protected List<View> read(InputStream in, DoGen g, String file) throws Exception{
            View v = View.parse(in);
            List<View> incl = resolveViews(v.getIncl(),file);
            return incl.push(v);
        }    
    }
}