/* Option.java
 * Bryan Chadwick :: 2007
 * Option Type Wrapper for traversal arguments */

package edu.neu.ccs.demeterf.util;

/** Mimics ML Option type ((Some o) | None). Used to make traversal arguments
 *    optional without losing performance. */
public class Option {
    static Option noneI = new Option();
    protected Option(){}
    public static Option some(Object o){ return new Some(o); } 
    public static Option none(){ return noneI; }
    public boolean some(){ return false; }
    public Object get(){ throw new RuntimeException("None.get"); }
}

class Some extends Option{
    Object o;
    Some(Object oo){ o = oo; }
    public boolean some(){ return true; }
    public Object get(){ return o; }
}

