/* ParTraversal.java
 * Bryan Chadwick :: 2007
 * Parallel traversal function */

package edu.neu.ccs.demeterf.perform;

import java.lang.reflect.*;
import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.util.*;
import edu.neu.ccs.demeterf.lib.List;

/** <p>Traverses an Object structure in <b>Parallel</b>, using a Builder and
 *   Augmentor.  Java threads are used to fork each subtraversal,
 *   synchronizing on their return.  Because of the way the DemeterF traversal
 *   is written, this is rather simple.</p>
 */
public class ParTraversal extends Traversal{
    private boolean parallel = true;
    
    /** Create a Traversal with a BuilderAugmentor with Selective edge/field Bypassing */
    public ParTraversal(FC f, Control c){ super(f, c); }
    /** Create a Traversal with an ID (BuilderAugmentor) */
    public ParTraversal(FC f){ super(f); }
    
    List<Object> mt = List.<Object>create();
    protected List<Object> traverseFields(Class<?> c, Object o, List<Field> fl, int len, Option arg, boolean par)
    throws IllegalAccessException{
        boolean hasArg = arg.some();
        if(len == 0)return mt;
        if(parallel)parallel = false;
        
        Field f = fl.top();
        if(!f.isAccessible())f.setAccessible(true);
        Object tret = f.get(o);
        if(len == 1){
            if(!control.skip(c, f.getName()))
                return mt.push(traverse(tret,(hasArg)?applyAugment(new Object[]{o, arg.get()},f):arg));
            return mt.push(tret);
        }
        if(par){
            SubTrav t = new SubTrav(tret,arg,this);
            t.start();
            List<Object> rest = traverseFields(c,o,fl.pop(),len-1,arg,par);
            return rest.push(t.waitDone());
        }else{
            Option farg = (hasArg)?applyAugment(new Object[]{o, arg.get()},f):arg;
            return traverseFields(c,o,fl.pop(),len-1,arg,par).push(
                    (!control.skip(c, f.getName()))?this.<Object>traverse(tret,farg):tret);
        }
    }
    protected <Ret> Ret traverse(Object o, Option arg){
        Class<?> c = o.getClass();
        if(control.isBuiltIn(c)){
            return (Ret)applyBuilder(Util.addArg(new Object[]{o},arg),true);
        }else{
            List<Field> fl = Util.getFuncFields(c);
            try{
                List<Object> r = traverseFields(c,o,fl,fl.length(),arg,parallel);
                Object[] ret = r.push((Ret)o).toArray(new Object[fl.length()+1]);
                return (Ret)applyBuilder(Util.addArg(ret, arg),false);
            }catch(IllegalAccessException e){
                throw new RuntimeException(e);
            }
        }
    }
    
    /** Represents a traversal <i>continuation</i> (kind of), so that the return
     *   value can be stored and the parent signaled. This one applies the <code>
     *   traversal()</code> function.*/
    static class SubTrav extends Thread{
        final Object tobj;
        final ParTraversal trav;
        final Option arg;
        Object res;
        boolean done = false; 
        
        SubTrav(Object o, Option a, ParTraversal t){ tobj = o; trav = t; arg = a; }
        public void run(){ setDone(trav.<Object>traverse(tobj,arg)); }
        synchronized void setDone(Object r){ res = r; done = true; this.notify(); }
        synchronized Object waitDone(){
            if(!done)
                try{ this.wait(); }catch(InterruptedException e){
                    System.err.println(" ** Error Waiting on Thread!!");
                }
            return res;
        }
    }
}