package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.Fields;

/** DemFGen identifier class.  Used to represent <tt>ids = (letter+ (number|letter)*)</tt>
 *    in programs/applications.  Similar to the DemeterJ <tt>Ident</tt> class, but
 *    implemented here to minimize dependencies and allow customization. */
public class ident implements Comparable<ident>{
    private final String name;
    /** Create an ident */
    public ident(String name){ this.name = name; }
    
    /** Return this identifier as a String */
    public String toString(){ return name; }
    /** Return the name of this identifier */
    public String getName(){ return name; }
    /** Is this identifier the same as the given Object? */
    public boolean equals(Object o){
        if(!(o instanceof ident))return false;
        ident oo = (ident)o;
        return (((Object)name).equals(oo.name));
    }
    /** Simple HashCode */
    public int hashCode(){ return name.hashCode()*3; }
    /** Idents are comparable */
    public int compareTo(ident id){ return name.compareTo(id.name); }
    /** Field class for ident.name */
    public static class name extends Fields.any{}
}
