// ** This file was generated with DemFGen (vers:04/05/2010)

package edu.neu.ccs.demeterf.lib;

/** Representation of SepList<Syn, X>, a separated list */
public abstract class SepList<Syn, X>{
    
    /** Construct a(n) SepList<Syn, X> Instance */
    protected SepList(){}

    /** Is this list Empty? */
    public abstract boolean isEmpty();
    /** Get the first element, if it exists */
    public abstract X top();
    /** Return a list without the first element */
    public abstract SepList<Syn,X> pop();
    
    /** Does this list currently contain Syntax? */
    public abstract boolean hasSyntax();
    /** Get the first instance of syntax, if it exists */
    public abstract Syn topSyntax();
    
    /** Convert this SepList into a regular List */
    public abstract List<X> toList();
    
    /** Push a new element on this SepList */
    public abstract SepList<Syn,X> push(X x, Syn s);
    /** Reverse this SepList */
    public abstract SepList<Syn,X> reverse();
    /** Reverse this SepList */
    protected abstract SepList<Syn,X> reverse(SepList<Syn,X> acc, Syn s);
    
    /** The Length of This List */
    public abstract int length();
    /** Lookup the i^th item in this List */
    public abstract X lookup(int i);
    /** To String, with a separator and prefix */
    public abstract String toString();
    
    /** Create an Empty List */
    public static <Syn,X> SepList<Syn,X> create(){ return new EmptyS<Syn,X>(); }
    /** Create a List from an array/variable arguments */
    public static <Syn,X> SepList<Syn,X> create(Syn s, X ... xa){ return create(s,xa,0); }
    /** Create a List from a fixed array, starting at index 'i' */
    public static <Syn,X> SepList<Syn,X> create(Syn s, X[] xa, int i){
        SepList<Syn,X> res = SepList.create();
        for(;i < xa.length;i++)res = res.push(xa[i],s);
        return res.reverse();
    }
    /** Create a List from an Iterable... */
    public static <Syn,X> SepList<Syn,X> create(Syn s, java.lang.Iterable<X> xs){
        SepList<Syn,X> res = SepList.create();
        for(X x:xs)res = res.push(x,s);
        return res.reverse();
    }
    
    /** Build a list from the numbers 0..(len-1) */
    public static <Syn,X> SepList<Syn,X> buildlist(Syn s, List.Build<X> b, int len){
        SepList<Syn,X> lst = SepList.create();
        while(len-- > 0)lst = lst.push(b.build(len),s);
        return lst;
    }
}


