// ** This class was generated with DemFGen (vers:12/06/2009)

package edu.neu.ccs.demeterf.lexer.classes;

import edu.neu.ccs.demeterf.lib.*;
import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.demfgen.classes.Package;




/** Representation of NFA */
public class NFA{
    protected final State start;
    protected final State fin;
    protected final List<Trans> trans;

    /** Construct a(n) NFA Instance */
    public NFA(State start, State fin, List<Trans> trans){
        this.start = start;
        this.fin = fin;
        this.trans = trans;
    }
    /** Is the given object Equal to this NFA? */
    public boolean equals(Object o){
        if(!(o instanceof NFA))return false;
        if(o == this)return true;
        NFA oo = (NFA)o;
        return (((Object)start).equals(oo.start))&&(((Object)fin).equals(oo.fin))&&(((Object)trans).equals(oo.trans));
    }
    /** Parse an instance of NFA from the given String */
    public static NFA parse(String inpt) throws ParseException{
        return new TheParser(new java.io.StringReader(inpt)).parse_NFA();
    }
    /** Parse an instance of NFA from the given Stream */
    public static NFA parse(java.io.InputStream inpt) throws ParseException{
        return new TheParser(inpt).parse_NFA();
    }
    /** Parse an instance of NFA from the given Reader */
    public static NFA parse(java.io.Reader inpt) throws ParseException{
        return new TheParser(inpt).parse_NFA();
    }

    /** Field Class for NFA.start */
    public static class start extends edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for NFA.fin */
    public static class fin extends edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for NFA.trans */
    public static class trans extends edu.neu.ccs.demeterf.Fields.any{}

        public static NFA empty(){
            State s = State.fresh(),
                  f = State.fresh();
            return new NFA(s,f,List.<Trans>create());
        }
        public static NFA concat(List<NFA> nfas){
            return nfas.foldr(new List.Fold<NFA,NFA>(){
                    public NFA fold(NFA f, NFA r){ return f.concat(r); }
                }, empty());
        }
        public NFA concat(NFA nfa){
            if(nfa.trans.isEmpty())return this;
            List<Trans> ts = replace(trans, fin, nfa.start);
            return new NFA(fin.equals(start)?nfa.start:start,
                           nfa.fin, ts.append(nfa.trans));
        }

        static List<Trans> replace(List<Trans> ts, final State old, final State nw){
            return ts.map(new List.Map<Trans,Trans>(){
                    public Trans map(Trans t){
                        State frm = t.getFrm().equals(old)?nw:t.getFrm();
                        State to = t.getTo().equals(old)?nw:t.getTo();
                        return new Trans(t.getL(), frm, to);
                    }
                });
        }
        public static NFA or(List<NFA> nfas){
            return nfas.fold(new List.Fold<NFA,NFA>(){
                    public NFA fold(NFA f, NFA r){ return r.or(f); }
                }, empty());
        }
        public NFA or(final NFA nfa){
            return new NFA(start, fin,
                           trans.append(replace(replace(nfa.trans, nfa.start, start),
                                                nfa.fin, fin)));
        }
        public NFA rawOr(final NFA nfa){
            return new NFA(start, fin,
                           trans.append(replace(nfa.trans,nfa.start,start)));
        }

        public NFA addTrans(Label l, State s, State f)
        { return new NFA(start,fin,trans.push(new Trans(l,s,f))); }
        public NFA addTrans(Label l)
        { return new NFA(start,fin,trans.push(new Trans(l,start,fin))); }
        public NFA star(){
            return new NFA(start,start, replace(trans,fin,start));
            //return huh().addTrans(Trans.EPSILON,fin,start);
        }
        public NFA huh(){ return addTrans(Trans.EPSILON,start,fin); }
        public NFA rmdups(){ return new NFA(start,fin,trans.removeDuplicates()); }

        
        public Set<State> DFAEdge(Set<State> s, char c, List<Trans> eps){
            return closure(nextStates(trans,s,c),eps);
        }
        public List<Trans> epsilons(){
            return trans.filter(new List.Pred<Trans>(){
                    public boolean huh(Trans t){ return t.getL().isEpsilon(); }
                });
        }
        
        public static Set<State> closure(Set<State> start, List<Trans> eps){
            Set<State> next = start.union(nextStates(eps,start,-1));
            if(next.size() == start.size())return start;
            return closure(next,eps);
        }
        static Set<State> nextStates(List<Trans> ts, final Set<State> s, final int c){
            return ts.fold(new List.Fold<Trans,Set<State>>(){
                    public Set<State> fold(Trans t, Set<State> r){
                        if(s.contains(t.getFrm()) && (c < 0 || t.getL().contains((char)c)))
                            return r.add(t.getTo());
                        return r;
                    }
                }, Set.<State>create());
        }

    /** DGP method from Class PrintToString */
    public String toString(){ return edu.neu.ccs.demeterf.lexer.classes.PrintToString.PrintToStringM(this); }
    /** Getter for field NFA.trans */
    public List<Trans> getTrans(){ return trans; }
    /** Getter for field NFA.fin */
    public State getFin(){ return fin; }
    /** Getter for field NFA.start */
    public State getStart(){ return start; }

}


