// ** This class was generated with DemFGen (vers:12/06/2009)

package edu.neu.ccs.demeterf.lexer.classes;

import edu.neu.ccs.demeterf.lib.*;
import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.demfgen.classes.Package;




/** Representation of Mach */
public class Mach{
    protected final Map<Integer, Set<State>> sts;
    protected final Map<Set<State>, Integer> rsts;
    protected final Map<MTrans, Integer> trans;

    /** Construct a(n) Mach Instance */
    public Mach(Map<Integer, Set<State>> sts, Map<Set<State>, Integer> rsts, Map<MTrans, Integer> trans){
        this.sts = sts;
        this.rsts = rsts;
        this.trans = trans;
    }
    /** Is the given object Equal to this Mach? */
    public boolean equals(Object o){
        if(!(o instanceof Mach))return false;
        if(o == this)return true;
        Mach oo = (Mach)o;
        return (((Object)sts).equals(oo.sts))&&(((Object)rsts).equals(oo.rsts))&&(((Object)trans).equals(oo.trans));
    }
    /** Parse an instance of Mach from the given String */
    public static Mach parse(String inpt) throws ParseException{
        return new TheParser(new java.io.StringReader(inpt)).parse_Mach();
    }
    /** Parse an instance of Mach from the given Stream */
    public static Mach parse(java.io.InputStream inpt) throws ParseException{
        return new TheParser(inpt).parse_Mach();
    }
    /** Parse an instance of Mach from the given Reader */
    public static Mach parse(java.io.Reader inpt) throws ParseException{
        return new TheParser(inpt).parse_Mach();
    }

    /** Field Class for Mach.sts */
    public static class sts extends edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for Mach.rsts */
    public static class rsts extends edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for Mach.trans */
    public static class trans extends edu.neu.ccs.demeterf.Fields.any{}

        public Mach(Set<State> st){
            this(Map.<Integer,Set<State>>create()
                 .put(0,Set.<State>create()).put(1,st),
                 Map.<Set<State>,Integer>hashMap()
                 .put(Set.<State>create(),0).put(st,1),
                 Map.<MTrans,Integer>create());
        }
        public Set<State> state(int i){ return sts.get(i); }
        public int states(){ return sts.size(); }
        public int trans(int i, int c){
            MTrans t = new MTrans(i,c);
            if(!trans.containsKey(t))
                return 0;
            return trans.get(t);
        }
        
        public Mach addState(int i, Set<State> s)
        { return new Mach(sts.put(i,s),rsts.put(s,i),trans); }
        public Mach addTrans(int f, char c, int t)
        { return new Mach(sts, rsts, trans.put(new MTrans(f,c), t)); }
        
        public int lookup(Set<State> s){
            if(rsts.containsKey(s))
                return rsts.get(s);
            return -1;
        }

        public String transArray(){
            String ret = "        static final int[][] EDGES = {\n";
            for(int i = 0; i < states(); i++){
                ret += "            /* St: "+i+" */ {";
                for(char c = 0; c < 256; c++)
                    ret += trans(i,c)+",";
                ret += "},\n";
            }
            return ret+"        };\n";
        }

        public String smallTransArray(){
            String ret = "        static final int[][] EDGES = {\n";
            for(int i = 0; i < states(); i++){
                ret += "            /* St: "+i+" */ {";
                int ostate = trans(i,(char)0), count = 0, c = 0;
                while(c < 256){
                    int nstate = trans(i,c);
                    if(ostate != nstate){
                        ret += count+","+ostate+",";
                        count = 1;
                        ostate = nstate;
                    }else
                        count++;
                    c++;
                }
                ret += count+","+ostate+"},\n";
            }
            return ret+"        };\n";
        }

        public String finalArray(List<FinalState> fins, boolean nowarn){
            String front = "        public static final int T_";
            String toks = front+"EOF = 1;\n";
            int i = 2;
            for(FinalState f:fins){
                toks += front+f.getTok().toUpperCase()+" = "+i+++";\n";
            }
            
            String names = "        public static String[] NAMES = {\"LEXERROR\",\"EOF\",";
            for(FinalState f:fins){
                names += "\""+f.getTok().toUpperCase()+"\",";
            }
            names += "    };";

            String arr = "        static final int[][] FINAL = {\n";
            for(i = 0; i < states(); i++){
                Set<State> set = state(i);
                arr += "            /* St: "+i+" */";
                boolean found = false;
                String fndName = "";
                for(FinalState f:fins){
                    if(set.contains(f.getS())){
                        if(found){
                            if(!nowarn)
                                System.err.println("     Warning: Overlapping Final States for Tokens:\n"+
                                                   "        "+fndName+"\n"+
                                                   "        "+f.getTok());
                        }else{
                            arr += " {1, T_"+f.getTok().toUpperCase()+"},";
                            fndName = f.getTok();
                            found = true;
                        }
                    }
                }
                if(!found)
                    arr += " {0,0},";
                arr += "\n";
            }
            arr += "        };";
            return toks+"\n"+arr+"\n"+names;
        }

    /** DGP method from Class PrintToString */
    public String toString(){ return edu.neu.ccs.demeterf.lexer.classes.PrintToString.PrintToStringM(this); }
    /** Getter for field Mach.trans */
    public Map<MTrans,Integer> getTrans(){ return trans; }
    /** Getter for field Mach.rsts */
    public Map<Set<State>,Integer> getRsts(){ return rsts; }
    /** Getter for field Mach.sts */
    public Map<Integer,Set<State>> getSts(){ return sts; }

}


