package edu.neu.ccs.demeterf.lazy;

/** Represents a function which does the traversal of an Object
 * and returns the result... but only when asked. */
public class Thunk<T> {
    public static <S> Thunk<S> create(Object o, Traversal t){ return new Thunk<S>(o,t); }
    
    private Object todo;
    private Traversal trav;
    private Thunk(Object o, Traversal t){ todo = o; trav = t; }
    public T go(){ return trav.<T>traverse(todo); }
    public T go(Object o){ return trav.<T>traverse(todo, o); }
}
