package edu.neu.ccs.demeterf.inline;

import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.ClassGen;
import edu.neu.ccs.demeterf.inline.classes.*;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Set;


/** Implements the method decision code by generating if expressions */
public class NewDecision{
    static void p(String s){ } //System.err.println(s); }
    /** Host object type (incase we bypass) */
    String host;
    /** Field types so primitives can be special */
    List<String> ftypes;
    /** Argument names (i.e., field names) */
    List<String> args;
    /** Subtyping decisions */
    SubTyping subs;
    /** extra stuff before and after a method call... (for heap traversals) */  
    String pre, post;
    /** Access wrapper, for accessing parallel results */
    Access acc;
    
    NewDecision(String h, List<String> fts, List<String> as, SubTyping sbs, String pr, String pst, Access ac){
        host = h; ftypes = fts; args = as; subs = sbs; pre = pr; post = pst; acc = ac;
    }
    
    List<MPart> partition(final List<Meth> ms, final int st, final int i){
        // Separate the methods by the i^th parameter
        
        List<MPart> ret = ms.fold(new List.Fold<Meth, Set<MPart>>(){
            public Set<MPart> fold(Meth m, Set<MPart> s){
                return s.merge(new MPart(st,i,m,subs),new Set.Merge<MPart>(){
                    public MPart merge(MPart a, MPart b){ return a.merge(b); }
                });
            }
        }, Set.<MPart>create()).toList();
        // Add the other `possible' methods
        return ret.map(new List.Map<MPart, MPart>(){
            public MPart map(MPart m){
                return m.addPossibles(ms);
            }
        }).sort(new PSort(subs)).reverse();
    }
    static String indent(int i){ return (i == 0)?"":"    "+indent(i-1); }
    static String except = "throw new RuntimeException(\"Not Possible!!\");\n";
    
    //  Make a decision beween the overlapping methods "ms" starting at argument number "s"
    //   through argument "i" with the subtyping "subs", full arguments "args", indentation
    //   level "idt", and "pre" and "post" strings to be appended to the calls.
    public static String decide(final String host, final List<String> fts, List<Meth> ms, final int s,
            final int i, final SubTyping subs, final List<String> args, final int idt, final String pre,
            final String post, final Access acc)
    { return new NewDecision(host,fts,args,subs,pre,post,acc).decide(ms, s, i, idt); }

    // Make a decision beween the overlapping methods "ms" starting at argument number "s"
    //   through argument "i" with the subtyping "subs", full arguments "args", indentation
    //   level "idt", and "pre" and "post" strings to be appended to the calls.
    public String decide(List<Meth> ms, final int s, final int i, final int idt){
        if(ms.isEmpty())return indent(idt+1)+except;
        if(ms.length() == 1)return "\n"+indent(idt)+methodCall(ms.top())+"\n";
        
        final List<MPart> part = partition(ms,s,i);
        p("\n******************* ["+s+".."+i+"]\n "+part);
        if(part.length() == 1){
            if(i < args.length()){
                p("\n Single ");
                final List<Meth> pms = part.top().meths;
                if(i < pms.top().getArgs().length() && pms.andmap(new List.Pred<Meth>(){
                    final TypeUse atu = pms.top().getArgs().lookup(i);
                    public boolean huh(Meth m){
                        return (i < m.getArgs().length() && atu.equals(m.getArgs().lookup(i)));
                    }
                })){
                    p("\n - Skipping: "+part.top().meths.top().getArgs().lookup(i));
                    return decide(ms,i+1,i+1,idt);
                }
                return decide(ms,s,i+1,idt);
            }
            // ELSE...
            // We're done with all the arguments
            return indent(idt)+methodCall(ms.sort(new MSort(subs)).top())+"\n";
        }
        return part.pop().foldl(new List.Fold<MPart, String>(){
            public String fold(MPart m, String r){
                return ("\n"+indent(idt)+
                        "if("+instanceChecks(m.types, args.pop(s), ftypes.pop(s))+"){\n"+
                           decide(m.meths,i+1,i+1,idt+1)+
                           indent(idt)+
                        "}else"+r);
            }
        }, "{"+decide(part.top().meths,i+1,i+1,idt+1)+indent(idt)+"}\n");
    }
    
    static class MPart implements java.lang.Comparable<MPart>{
        int start; // The start of the comparison
        int num;   // The current arg number under comparison 
        List<TypeUse> types; // The argument types under comparison ("start" through "num") 
        List<Meth> meths;    // Methods in this partition
        SubTyping subs;      // Subtyping knowledge (global)
        
        MPart(int s, int n, List<TypeUse> ts, List<Meth> m, SubTyping sub){ num = n; types = ts; meths = m; subs = sub; }
        MPart(int s, int i, Meth m, SubTyping sub){ this(s,i, args(s,i,m), List.create(m), sub); }
        
        public MPart merge(MPart m){
            return new MPart(start, num, subs.subtype(m.types, types)?types:m.types,
                    meths.push(m.meths), subs);    
        }
        public int compareTo(MPart a){
            //if(subs.subtype(a.types, types) || subs.subtype(types, a.types))return 0;
            if(types.equals(a.types))return 0;
            if(MSort.comp(types, a.types, subs))return -1;
            return +1;
        }
        public String toString(){
            return "   "+types+" ["+start+".."+num+"]:: \n       "+meths.toString("       ","");
        }
        public MPart addPossibles(List<Meth> ms){
            return new MPart(start,num,types, meths.append(ms.filter(new List.Pred<Meth>(){
                public boolean huh(Meth m){
                    if(meths.contains(m))return false;
                    List<TypeUse> args = m.getArgs().sublist(num, 1);
                    boolean ret = subs.applicable(args,types);
                    //System.err.println(args+" ??? "+types+" == "+ret);
                    return ret;
                }
            })), subs);
        }
    }
    
    static List<TypeUse> args(final int s, int i, final Meth m){
        return List.buildlist(new List.Build<TypeUse>(){
            public TypeUse build(int i){
                return m.getArgs().length()>(s+i)?m.getArgs().lookup(s+i):SubTyping.obj;
            }
        },i-s+1);
    }
    
    public static class MSort extends List.Comp<Meth>{
        SubTyping subs;
        public MSort(SubTyping s){ subs = s; }
        public boolean comp(Meth m1, Meth m2){
            boolean r = MSort.comp(m1.getArgs(), m2.getArgs(), subs);
            //p("\n - Comp: "+m1+" : "+m2+" == "+r);
            return r;
        }
        public static boolean comp(List<TypeUse> a, List<TypeUse> b, SubTyping subs){
            if(b.isEmpty())return true;
            if(a.isEmpty())return false;
            return ((subs.subtype(a.top(), b.top()) && !a.top().equals(b.top())) ||
                    (a.top().equals(b.top()) && comp(a.pop(),b.pop(),subs)));
        }
    }
    public static class PSort extends List.Comp<MPart>{
        SubTyping subs;
        public PSort(SubTyping s){ subs = s; }
        public boolean comp(MPart p1, MPart p2){
            boolean r = MSort.comp(p1.types, p2.types, subs);
            //p(" - Comp: "+p1+" : "+p2+" == "+r);
            return r;    
        }
    }
    
    public static class Access{
        public String use(String f, String host, String type){ return f; }
    }
    
    String methodCall(Meth m){
        // Method formal argument types
        List<TypeUse> ats = m.getArgs();
        String ret = "return "+pre+"func.combine(";
        if(ats.isEmpty())return ret+")"+post+";";
        
        return ret+("("+ClassGen.unlocal(ats.top())+")"+args.top()+(ats.length()>1?",":"")+
                ats.pop().zip(new List.Zip<TypeUse, String, String>(){
                    public String zip(TypeUse t, String res){
                        return "("+ClassGen.unlocal(t)+")"+res;
                    }
                }, ftypes.pop().zip(new List.Zip<String, String, String>(){
                    public String zip(String t, String f){
                        return acc.use(f,host,t);
                    }
                }, args.pop())).toString(", ","")+")"+post+";");
    }
    String instanceChecks(List<TypeUse> ts, List<String> args, List<String> fts){
        if(ts.isEmpty())return "true";
        return (ClassGen.unlocal("("+acc.use(args.top(),host,fts.top())+
                Diff.d.instanceCheck(""+ts.top().getName(), ""+ts.top().getTparams())+")").replace(SubTyping.WildName, "?")+
                (ts.pop().isEmpty()?"":(" && "+instanceChecks(ts.pop(), args.pop(), fts.pop()))));
    }
}
