package edu.neu.ccs.demeterf.inline;

import edu.neu.ccs.demeterf.inline.classes.*;
import edu.neu.ccs.demeterf.lib.Cons;
import edu.neu.ccs.demeterf.lib.Empty;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Map;
import edu.neu.ccs.demeterf.lib.Option;
import edu.neu.ccs.demeterf.lib.Set;
import edu.neu.ccs.demeterf.lib.ident;
import edu.neu.ccs.demeterf.demfgen.dgp.*;
import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.util.Util;
import edu.neu.ccs.demeterf.demfgen.*;
import edu.neu.ccs.demeterf.demfgen.classes.*;

public class GenTrav {
    
    static String generateBody(final GenInline gen, String func, TypeUse start, final List<TypeDef> types){
        final Traversal trav = new Traversal(gen, 
                Control.builtins(DoGen.class,TypeDefParams.class,TypeUse.class,Impl.class));
        String result = gen.choices.fold(new List.Fold<EnvEntry, String>(){
            public String fold(EnvEntry e, String r){
                //String ent = e.getType().print();
                if(Diff.d.builtIns.contains(e.getType().print()))return r;
                return trav.<String>traverse(DemFGenMain.instantiate(e.getType(),types))+r;    
            }
        }, "");
        
        String travMeths = (!Inline.FOR_ALL)?gen.travMethod(start):
            gen.choices.fold(new List.Fold<EnvEntry, String>(){
                public String fold(EnvEntry e, String r){
                    if(Diff.d.builtIns.contains(e.getType().print()) ||
                            (SubTyping.JAVA_HACK && !e.getType().getTparams().isEmpty()))
                        return r;
                    return gen.travMethod(e.getType())+r;
                }
            },"");
        
        return //((SubTyping.JAVA_HACK && !start.getParams().isEmpty())?gen.travMethod(start):"")+
               travMeths+"\n"+result;
    }
    
    public static String targName = "_targ_";
    
    static String generate(String name, Impl impl, final List<TypeDef> types, String func, TypeUse start, GenControl ctrl,
                           Option<TypeUse> targ, List<EnvEntry> choices, SubTyping subs,
                           Map<String,List<Meth>> updts, List<String> opts){
        
        GenInline gen = new GenInline(func, targ, choices, subs, ctrl, updts);
        
        String result = generateBody(gen,func,start,types);
        TypeUse ret = gen.findEntry(start).getRet();
        return 
        "public class "+name+" "+ClassGen.unlocal(impl.print())+"{\n"+
        "   private "+ClassGen.unlocal(func)+" func;\n"+
        "   public "+name+"("+ClassGen.unlocal(func)+" f){ func = f; }\n"+
        "\n"+result+"\n}";
    }
    
    protected static class P{
        Set<String> done;
        String body;
        public P(){ this(Set.<String>create(), ""); }
        public P(Set<String> d, String b){ done = d; body = b; }
        P add(String t, String bdy){ return new P(done.add(t),bdy+body); }
    }

    public static class GenInline extends ID{
        public final String HOST = "_h";
        
        String func;
        Option<TypeUse> targ;
        SubTyping subs;
        List<EnvEntry> choices;
        GenControl ctrl;
        Decision.Access acc = new Decision.Access();
        Map<String,List<Meth>> updates;
        
        public GenInline(String f, Option<TypeUse> ta, List<EnvEntry> ch, SubTyping s, GenControl c, Map<String,List<Meth>> updts)
        { func = f; choices = ch; targ = ta; subs = s; ctrl = c; updates = updts; }

        public String travMethod(TypeUse start){
            TypeUse ret = findEntry(start).getRet();
            return ("   public "+ClassGen.unlocal(ret)+" traverse(final "+ClassGen.unlocal(start)+" "+HOST+targDef()+
                    "){ return traverse"+
                    Flds.addSpacers(start)+"("+HOST+extraAbstrArgs()+targUse()+"); }\n");
        }
        
        
        Syntax combine(Syntax s){ return s; }
        String combine(SumToken s){ return ""; }
        String combine(Empty<?> e){ return ""; }
        String combine(Cons<?> c, String f, String r){ return f+r; }
        String combine(Bound b){ return ""; }

        static class GetEntry extends List.Pred<EnvEntry>{
            TypeUse tu;
            GetEntry(TypeUse t){ tu = t; }
            public boolean huh(EnvEntry e){ return e.getType().getName().equals(tu.getName()); }
        }
        List<Meth> findMeths(final TypeUse tu){ return findEntry(tu).getChoices(); }
        boolean reachable(final TypeUse tu){ return choices.contains(new GetEntry(tu)); }
        EnvEntry findEntry(final TypeUse tu){ return choices.find(new GetEntry(tu)); }

        public String extraDefs(){ return ""; }
        public String extraConcrArgs(){ return ""; }
        public String extraAbstrArgs(){ return ""; }
        
        public String targDef(){ return targDef(", final ", ""); }
        public String targDef(String pre, String suf){ return (targ.isSome()?pre+ClassGen.unlocal(targ.inner())+" "+targName+suf:""); }
        public String targUse(){ return targUse(", ", ""); }
        public String targUse(String pre, String suf){ return (targ.isSome()?pre+targName+suf:""); }
        
        public static String getter(String f){
            if(Diff.optionSet(Inline.PUBFIELDS))return f;
            return Diff.capName("get"+Util.capCase(f))+"()";    
        }
        
        public String fieldMeth(String type, TypeUse tu, String f){
            EnvEntry choice = findEntry(tu);
            String boxRet = ClassGen.unlocal(Diff.d.box(""+choice.getRet()));
            List<Meth> choices = choice.getChoices();
            String ret = boxRet+" _"+f+" = ";
            
            if(ctrl.skip(type, f))return  (ret+HOST+"."+getter(f)+";");
            
            boolean prim = ctrl.isBuiltIn(tu);
            if(prim){
                if(choices.isEmpty())
                    return ret+HOST+"."+getter(f)+";";
                return builtinCall(ret,type,tu,f,choices,boxRet);
            }
            
            return recurseCall(ret,type,tu,f,choices,boxRet);
        }
        public String recurseCall(String prefix, String host, TypeUse ftype, String fname, List<Meth> choices, String boxedRet){
            return prefix+("traverse"+Flds.addSpacers(ftype)+"("+HOST+"."+getter(fname)+extraConcrArgs()+updateMethod(host, fname)+");");
        }
        public String builtinCall(String prefix, String host, TypeUse ftype, String fname, List<Meth> choices, String boxedRet){
            // TODO: Method Selection for builtins
            return prefix+("func.combine("+HOST+"."+getter(fname)+
                    ((choices.top().getArgs().length()>1)?", "+updateMethod(host, fname):"")+");");
        }
        
        public String updateMethod(String type, String field){
            if(!targ.isSome())return "";
            String fldS = type+"$"+field,
                   targS = targUse("","");
            if(!updates.containsKey(fldS))return ", "+targS;
            
            List<Meth> ap = updates.get(fldS);
            
            List<String> args = List.create(HOST, "new "+ClassGen.unlocal(fldS)+"()", targS).sublist(0, ap.top().getArgs().length());
            if(ap.length() == 1)
                return ", func.update("+args.toString(", ", "")+")";
            throw new RuntimeException("Multiple Updates not yet implemented");
        }
        
        
        /** The method signature for a traversal method */
        public String travHeader(ident n, TypeDefParams dp, TypeUse ret){
            String ddp = ClassGen.unlocal(dp);
            return ("   public "+ClassGen.unlocal(ret)+" traverse"+Flds.addSpacers(n,ddp)+"(final "+
                    ClassGen.unlocal(n)+ddp+" "+HOST+extraDefs()+targDef()+"){");
        }
        String combine(ClassDef td, DoGen g, ident n, TypeDefParams dp, List<TypeUse> sts, List<Field> fs) throws Exception{
            TypeUse tu = TypeUse.parse(n+dp.print());
            if(ctrl.isBuiltIn(tu) || !reachable(tu))return "";
            EnvEntry entry = findEntry(tu);
            String methDef = travHeader(n,dp,entry.getRet());
            String fin = "   }\n"; 
            
            // ABSTRACT
            if(!sts.isEmpty()){
                // Im-PURE abstract class that has an applicable Method
                if(Diff.optionSet(Inline.CONCRETES) && !fs.isEmpty() && !entry.getChoices().isEmpty())
                    return methDef+"\n"+abstrTrav(tu,n,dp,sts, concrete(n, methDef, fs, entry))+fin;
                return methDef+"\n"+abstrTrav(tu,n,dp,sts)+fin;
            }
            return methDef+concrete(n, methDef, fs, entry)+fin;
        }
       
        public String methodChoice(String host, List<String> fts, List<Meth> ms, List<String> fns, Decision.Access acc)
        { return methodChoice(host, fts, ms, fns, 2, "", "", acc); }
        public String methodChoice(String host, List<String> fts, List<Meth> ms, List<String> fns, int idt, String pre, String post, Decision.Access acc){
            return Decision.decide(host, fts, ms, 0, 0, subs, fns, idt, pre, post, acc);
        }
        public String concrete(ident n, String defn, List<Field> fs, EnvEntry entry){ 
            // CONCRETE
            List<String> fns = fs.map(new List.Map<Field,String>(){
                public String map(Field f){ return "_"+f.getName(); }
            }).push(HOST);
            List<String> fts = fs.map(new List.Map<Field,String>(){
                public String map(Field f){ return f.getType().toString(); }
            }).push(""+n);
            if(targ.isSome()){
                fns = fns.append(targUse("",""));
                fts = fts.append(targ.inner().toString());
            }
            final String name = ClassGen.unlocal(n);
            return (fs.toString(new List.Stringer<Field>(){
                        public String toString(Field f, List<Field> r)
                        { return "\n        "+fieldMeth(name, f.getType(),f.getName().toString()); }
                    })+
                    methodChoice(name, fts, entry.getChoices(), fns, acc));
        }
        List<Field> combine(FieldList l, Field f, List<Field> fs){ return fs.push(f); }
        List<Field> combine(FieldList l, Syntax s, List<Field> fs){ return fs; }
        List<Field> combine(FieldEmpty e){ return List.create(); }
        Field combine(Field f){ return f; }

        String combine(IntfcDef ifd, DoGen g, ident n, TypeDefParams dp, List<TypeUse> un) throws Exception{
            TypeUse tu = TypeUse.parse(n+dp.print());
            if(ctrl.isBuiltIn(tu) || !reachable(tu))return "";
            return (travHeader(n, dp, findEntry(tu).getRet())+
                    abstrTrav(tu, n, dp, un)+"   }\n");
        }
        public String abstrTrav(TypeUse tu, ident n, TypeDefParams dp, List<TypeUse> un) throws Exception{
            return abstrTrav(tu,n,dp,un,"        else throw new "+
                    Diff.d.runtimeException+"(\"Unknown "+n+" Variant\");\n");
        }
        public String abstrTrav(TypeUse tu, ident n, TypeDefParams dp, List<TypeUse> un, String elser) throws Exception{
            return (un.foldr(new List.Fold<TypeUse, String>(){
                        public String fold(TypeUse t, String r){
                            return "        if("+HOST+Diff.d.instanceCheck(ClassGen.unlocal(Diff.d.isJava()?""+t.getName():""+t), "")+
                            ") return "+subtypeMeth(t)+";\n"+r;
                        }
                    },elser));
        }
        
        public String subtypeMeth(TypeUse tu){
            EnvEntry choice = findEntry(tu);
            boolean prim = ctrl.isBuiltIn(tu);
            String cast = "("+ClassGen.unlocal(tu)+")"+HOST; 
            if(prim && choice.getChoices().isEmpty())return cast;
            if(prim){
                // TODO: Method Selection for builtins...
                return "func.combine("+cast+((choice.getChoices().top().getArgs().length()>1)?targUse():"")+")";
            }
            return "traverse"+Flds.addSpacers(tu)+"("+cast+extraAbstrArgs()+targUse()+")";
        }
        
        
        List<TypeUse> combine(SubtypeEmpty e){ return List.create(); }
        List<TypeUse> combine(SubtypeCons c, TypeUse tu, List<TypeUse> r){ return r.push(tu); }
        List<TypeUse> combine(NESubtypeList c, TypeUse tu, List<TypeUse> r){ return r.push(tu); }
    }
}