package edu.neu.ccs.demeterf.inline;

import edu.neu.ccs.demeterf.inline.classes.*;
import edu.neu.ccs.demeterf.lib.*;
import edu.neu.ccs.demeterf.demfgen.dgp.*;
import edu.neu.ccs.demeterf.demfgen.*;
import edu.neu.ccs.demeterf.demfgen.classes.*;

public class GenHeapTrav{

    static String generate(String name, Impl impl, final List<TypeDef> types, String func, TypeUse start, GenControl ctrl,
                           Option<TypeUse> targ, List<EnvEntry> choices, SubTyping subs,
                           Map<String,List<Meth>> updts, List<String> opts){
        
        final GenHeapInline gen = new GenHeapInline(func, targ, choices, subs, ctrl, updts);
        String result = GenTrav.generateBody(gen,func,start,types);
        TypeUse ret = gen.findEntry(start).getRet();
        
        return
        "import edu.neu.ccs.demeterf.stackless.Continuation;\n\n" +
        "public class "+name+" "+ClassGen.unlocal(impl.print())+"{\n"+
        "   private "+func+" func;\n"+
        "   public "+name+"("+func+" f){ func = f; }\n\n"+
        
        result+
        
        // Hole (empty context) and Value (finished context)
        "   class _Hole extends Continuation{\n"+
        "       _Hole(){ super(null); link = this; }\n"+
        "       public Continuation step(){ return this; }\n"+
        "       public Continuation apply(Object v){ return new _Value("+GenHeapInline.makeCast(ret)+"v); }\n"+
        "   }\n"+
        "   class _Value extends Continuation{\n"+
        "       final Object val;\n"+
        "       _Value(Object v){ super(null); val = v; }\n"+
        "       public Continuation step(){ return this; }\n"+
        "       public boolean isValue(){ return true; }\n"+
        
        "   }\n"+
        "}";
    }

    public static class GenHeapInline extends GenTrav.GenInline{
        public GenHeapInline(String f, Option<TypeUse> ta, List<EnvEntry> ch, SubTyping s, GenControl c, Map<String,List<Meth>> updts){
            super(f, ta, ch, s, c, updts);
        }

        static String makeCast(TypeUse t){
            int i = Diff.d.primitives.index(t.print());
            if(i < 0 || i >= Diff.d.boxed.length())
                return "("+t+")";
            return "("+Diff.d.boxed.lookup(i)+")"; 
        }

        public String travMethod(TypeUse start){
            TypeUse ret = findEntry(start).getRet();
            return
            "   public "+ret+" traverse("+start+" "+HOST+targDef()+"){\n"+
            "       Continuation base = new "+Flds.addSpacers(start)+"_start("+HOST+", new _Hole()"+targUse()+");\n"+
            "       while(!base.isValue())\n"+
            "           base = base.step();\n"+
            "       return ("+ret+")(((_Value)base).val);\n"+
            "   }\n";
        }
        
        
        String combine(ClassDef td, DoGen g, ident n, TypeDefParams dp, List<TypeUse> sts, List<Field> ofs) throws Exception{
            TypeUse tu = TypeUse.parse(n+dp.print());
            if(!reachable(tu))return "";
            
            // ABSTRACT
            if(!sts.isEmpty())return abstrTrav(tu,n,dp,sts);
            
            // CONCRETE
            final String name = Flds.addSpacers(tu);
            List<Field> fs = ofs;
            List<Field> rs = List.create();
            List<String> fts = fs.map(new List.Map<Field, String>(){
                public String map(Field f){ return f.getType().toString(); }
            });
            String fieldCs =
                "   class "+name+"_start extends Continuation{\n"+
                "      final "+ClassGen.unlocal(n)+dp+" "+HOST+";\n"+targDef("      final ",";\n")+
                "      "+name+"_start("+ClassGen.unlocal(n)+dp+" that, Continuation l"+targDef()+
                "){ super(l); "+HOST+" = that; "+targUse("this.","= _targ_; ")+"}\n"+
                "      "+name+"_start("+name+"_start that){ this(that."+HOST+", that.link"+targUse(", that.","")+"); }\n";

            Field prev = null;
            while(!fs.isEmpty()){
                boolean first = rs.isEmpty();
                Field f = fs.top();
                String fname = ""+f.getName();
                TypeUse r = findEntry(f.getType()).getRet();
                rs = rs.append(new Field(f.getName(),r));

                String parent = name+"_"+(first?"start":prev.getName());
                String cast = makeCast(r);
                // Previous Step and Apply Methods
                fieldCs += "      public Continuation step(){ return new ";
                if(ctrl.isBuiltIn(f.getType())){
                    EnvEntry entry = findEntry(f.getType());
                    List<Meth> ms = entry.getChoices();
                    fieldCs += name+"_"+fname+"(this, "+
                    ((ctrl.skip(name,f.getName().toString()) || ms.isEmpty())?HOST+"."+getter(fname):("func.combine("+HOST+"."+getter(fname)+
                    ((!ms.isEmpty() && ms.top().getArgs().length()>1)?targUse():"")+")"))+")";
                }else{
                    fieldCs += Flds.addSpacers(f.getType())+"_start("+HOST+"."+getter(fname)+", this"+
                               // ** Here we need to choose the correct update method if it exists...
                               targUse()+
                               ")";
                }
                fieldCs += "; }\n";
                if(!ctrl.isBuiltIn(f.getType()))
                    fieldCs += "      public Continuation apply(Object v){ return new "+name+"_"+fname+"(this, "+cast+"v); }\n";
                fieldCs += "   }\n";


                // Fields and constructor...
                fieldCs +=
                    "   class "+name+"_"+fname+" extends "+parent+"{\n"+
                    "      final "+r+" "+fname+";\n"+
                    "      "+name+"_"+fname+"("+name+"_"+fname+" _p){ this(_p, _p."+fname+"); }\n"+
                    "      "+name+"_"+fname+"("+parent+" _p, "+r+" v){ super(_p); this."+fname+" = v; }\n";

                //fieldCs += "   }\n\n";
                prev = f;
                fs = fs.pop();
            }

            // Final Step and Apply Methods
            EnvEntry entry = findEntry(tu);
            fieldCs +=
                "      public Continuation step(){"+
                // Create a new continuation with "this" as the link
                methodChoice(name, fts.push(""+n), entry.getChoices(), rs.map(new List.Map<Field, String>(){
                    public String map(Field f){ return ""+f.getName(); }
                }).append("_targ_").push(HOST), 3, "link.apply(", ")", acc)+
                "      }\n    }\n";
                //" return link.apply(func.combine("+HOST+rs.toString(new List.Stringer<Field>(){
                //    public String toString(Field f, List<Field> r){ return ", "+f.name; }
                //})+")); }\n   }\n";
            
            return fieldCs;
        }

        public String abstrTrav(TypeUse tu, ident n, TypeDefParams dp, List<TypeUse> un) throws Exception{
            if(!reachable(tu))return "";
            final String name = Flds.addSpacers(tu);

            return
            "   class "+name+"_start extends Continuation{\n"+
            "      final "+n+dp+" "+HOST+";\n"+targDef("      final ",";\n")+
            "      "+name+"_start("+ClassGen.unlocal(n)+dp+" that, Continuation l"+targDef()+"){ super(l); "+HOST+" = that; "+
            targUse("this.","= _targ_; ")+"}\n"+
            "      public Continuation step(){\n"+
            un.foldr(new List.Fold<TypeUse, String>(){
                public String fold(TypeUse t, String r){
                    return "         if("+HOST+Diff.d.instanceCheck((Diff.d.isJava()?""+ClassGen.unlocal(t.getName()):""+t), "")+
                    ") return new "+Flds.addSpacers(t)+"_start(("+(Diff.d.isJava()?""+ClassGen.unlocal(t.getName()):""+t)+")"+HOST+",link"+targUse()+");\n"+r;
                }
            }, "         else throw new "+Diff.d.runtimeException+"(\"Unknown "+n+" Variant\");\n")+
            "      }\n   }\n";
        }
    }
}