package edu.neu.ccs.demeterf.inline;

import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.demfgen.classes.*;

public class GenControl{
    static List<String> FirstBuiltIns = List.create("short", "Short",
            "Integer", "int", "Float", "float", "Long", "long", "Double", "double",
            "String", "Boolean", "boolean", "char", "Character","ident", "verbatim");
            
    /** Returns a mutable MutableControl with the given Classes as BuiltIns */
    public static GenControl make(final SubTyping subs, List<String> cls, List<String> byps, List<String> ign){
        return new GenControl(subs, FirstBuiltIns.append(cls).map(new List.Map<String, TypeUse>(){
            public TypeUse map(String s){ return TypeUse.makeType(s); }
        }), toEdges(subs, byps), toEdges(subs, ign));
    }
    
    static List<Edge> toEdges(final SubTyping subs, List<String> es){
        return es.map(new List.Map<String, Edge>(){
            public Edge map(String s){
                int idx = s.indexOf('.');
                if(idx < 1)
                    return new AllEdges(TypeUse.makeType(s));
                return new Edge(TypeUse.makeType(s.substring(0,idx)),
                        s.substring(idx+1));
            }
        });
    }
    
    /** Returns whether or not to bypass/skip the given Class/Field */
    public boolean skip(String c, String f){ return skip(TypeUse.makeType(c),f); }
    /** Returns whether or not to bypass/skip the given Class/Field */
    public boolean skip(TypeUse c, String f){ return skip(new Edge(c,f)); }
    /** Returns whether or not to bypass/skip the given Class/Field */
    public boolean skip(Edge e){ return bypass.contains(e); }
    /** Returns whether or not to bypass/skip the given Class/Field */
    public boolean ignore(String c, String f){ return ignore(TypeUse.makeType(c),f); }
    /** Returns whether or not to bypass/skip the given Class/Field */
    public boolean ignore(TypeUse c, String f){ return ignore(new Edge(c,f)); }
    /** Returns whether or not to bypass/skip the given Class/Field */
    public boolean ignore(Edge e){ return ignore.contains(e); }
    
    /**  */
    private SubTyping subs;
    /** List of Primitive Classes */
    private List<TypeUse> builtIns;
    /**  */
    private List<Edge> bypass;
    /**  */
    private List<Edge> ignore;
    
    private GenControl(SubTyping st, List<TypeUse> bins, List<Edge> byps, List<Edge> ignr){
        subs = st;
        builtIns = bins;
        bypass = byps;
        ignore = ignr;
        
        /*System.err.println("  BuiltIns: "+builtIns);
        System.err.println("    Bypass: "+bypass);
        System.err.println("    Ignore: "+ignore);*/
    }
    
    /** Returns whether or not tthe given Class is a Builtin */
    public boolean isBuiltIn(String tu){
        return isBuiltIn(TypeUse.makeType(tu));
    }
    /** Returns whether or not tthe given Class is a Builtin */
    public boolean isBuiltIn(final TypeUse tu){
        return builtIns.contains(new List.Pred<TypeUse>(){
            public boolean huh(TypeUse bi){
                return subs.subtype(tu, bi);
            }
        });
    }
    
    public static Edge makeEdge(TypeUse t, String f){ return new Edge(t,f);  }
    
    public static class Edge{
        TypeUse clas;
        String field;
        Edge(TypeUse c, String f){ clas = c; field = f; }
        public TypeUse getType(){ return clas; }
        public String getField(){ return field; }
        public boolean equals(Object eo){
            if(!(eo instanceof Edge))return false;
            Edge e = (Edge)eo;
            return clas.equals(e.clas) && field.equals(e.field);
        }
        public String toString(){
            return "edge("+clas+"."+field+")";
        }
    }
    static class AllEdges extends Edge{
        AllEdges(TypeUse c){ super(c,""); }
        public boolean equals(Object eo){
            if(!(eo instanceof Edge))return false;
            Edge e = (Edge)eo;
            return clas.equals(e.clas);    
        }
        public String toString(){
            return "alledges("+clas+")";
        }
    }
}
