package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.stackless.*;

public class RemoveTest{
    static void p(String s){ System.out.println(s); }
    public static void main(String[] args){
        Traversal trav = new Traversal(new Str());
        Traversal htrav = new HeapTrav(new Str());
        BST leaf = new BST();
        BST t = BST.from(4, 2, 5, 3, 1, 6);
        p("   Tree : "+trav.traverse(t));
        p(" RSpine : "+new Traversal(new Spine(),
                Control.remove("edu.neu.ccs.demeterf.examples.RemoveTest$Nd.left")).traverse(t));
        p(" LSpine : "+new Traversal(new Spine(),
                Control.remove("edu.neu.ccs.demeterf.examples.RemoveTest$Nd.right")).traverse(t));
        //p("  Tree : "+trav.traverse(t,0));
    }
    
    static class Str extends ID{
        String combine(BST t){ return ""; }
        String combine(Nd t, int d, String l, String r){ return "("+d+l+r+")"; }
    }
    static class Spine extends ID{
        List<Integer> combine(BST t){ return List.create(); }
        List<Integer> combine(Nd t, int d, List<Integer> l){
            return l.push(d);    
        }
    }
       
    public static class BST{
        static BST from(int ... is){
            BST t = new BST();
            for(int i = 0; i < is.length; i++)
                t = t.insert(is[i]);
            return t;
        }
        public BST insert(int nd){ return new Nd(nd,this,this); }
    }
    public static class Nd extends BST{
        int data;
        BST left, right;
        
        public Nd(int d, BST l, BST r){ data = d; left = l; right = r; }
        public BST insert(int nd){
            if(nd < data)return new Nd(data,left.insert(nd),right);
            return new Nd(data,left,right.insert(nd));
        }
    }
}