package edu.neu.ccs.demeterf.examples;
import edu.neu.ccs.demeterf.*;

/** Shows the oneStep Traversal (essentially just Control.nowhere()). We
 *    demonstrate that BST functions can be written entirely extenal to the
 *    structure/classes using one step traversal control. */
public class OneStep {
    public static void main(String as[]){
        int is[] = {4,2,6,1,3,5,7};
        bst a = bst.create(is),
            b = bst.create(is),
            c = bst.create(is,1);
        System.out.println("    isL(a) ? "+isL.isLeaf(a));
        System.out.println(" isL(leaf) ? "+isL.isLeaf(new leaf()));
        System.out.println("    a == b ? "+Eq.equal(a, b));
        System.out.println("    b == a ? "+Eq.equal(b, a));
        System.out.println("    b == c ? "+Eq.equal(b, c));
        System.out.println("    c == a ? "+Eq.equal(c, a));
        System.out.println("    a =2= b ? "+Eq2.equal(a, b));
        System.out.println("    b =2= a ? "+Eq2.equal(b, a));
        System.out.println("    b =2= c ? "+Eq2.equal(b, c));
        System.out.println("    c =2= a ? "+Eq2.equal(c, a));
    }
    
    static abstract class bst{
        static bst create(int ... is){ return create(is,0); }
        static bst create(int is[], int dx){
            if(dx >= is.length)return new leaf();
            int lch = dx*2+1;
            return new node(is[dx],create(is,lch),create(is,lch+1));    
        }
        public String toString(){
            return new Traversal(new ID(){
                String combine(Integer i){ return ""+i; }
                String combine(leaf t){ return "L"; }
                String combine(node t, String d, String l, String r){ return "N("+d+", "+l+", "+r+")"; }
            }).traverse(this); }
    }
    public static class leaf extends bst{}
    public static class node extends bst{
        int d; bst l,r;
        node(int dd, bst ll, bst rr){ d = dd; l = ll; r = rr; }
        public static class d extends Fields.any{}
        public static class l extends Fields.any{}
        public static class r extends Fields.any{}
    }
    
    static class isL extends ID{
        boolean combine(leaf t){ return true; }
        boolean combine(node t){ return false; }
        static boolean isLeaf(bst t){ return Traversal.onestep(new isL()).<Boolean>traverse(t); }
    }
    
    static class Eq extends ID{
        final bst t;
        Eq(bst tt){ t = tt; }        
        boolean combine(leaf l){ return isL.isLeaf(t); }
        boolean combine(node n, final int d, final bst l, final bst r){
            return Traversal.onestep(new ID(){
                boolean combine(leaf l){ return false; }
                boolean combine(node n, int td, bst tl, bst tr){
                    return td == d && equal(l,tl) && equal(r,tr); 
                }
            }).<Boolean>traverse(t);
        }
        static boolean equal(bst a, bst b){ 
            return Traversal.onestep(new Eq(a)).<Boolean>traverse(b);    
        }
    }
    
    static class Eq2 extends ID{
        static class nothing{}
        bst update(node n, node.l f, node t){ return t.l; }
        bst update(node n, node.r f, node t){ return t.r; }
        int update(node n, node.d f, node t){ return t.d; }
        nothing update(){ return new nothing(); }
        
        boolean combine(){ return false; }
        boolean combine(leaf a, leaf b){ return true; }
        boolean combine(int a, int b){ return a == b; }
        boolean combine(node a, boolean d, boolean l, boolean r, node b){
            return d && l && r;
        }
        static boolean equal(bst a, bst b){ 
            return new Traversal(new Eq2()).<Boolean>traverse(a,b);    
        }
    }
    
}
