package edu.neu.ccs.demeterf.examples;
import edu.neu.ccs.demeterf.util.Util;
import edu.neu.ccs.demeterf.*;

/** Test for Null Fields During Traversal.  DemeterF supports null fields and
 *    return values, but only under a switch.  We discourage using null because
 *    it doesn't maintain any type information (null can be any object type).*/
public class NullTest{
    public static void main(String[] args){
        Util.setAllowNull(true);
        Traversal t = new Traversal(new Test());

        System.out.println("  First: "+t.traverse(new U(new V(), new W())));
        System.out.println(" Second: "+t.traverse(new U(new V(), null)));
    }
    static class U{
        U(V vv, W ww){ w = ww; v = vv; }
        V v; W w;
    }
    static class V{ Integer i = null; }
    static class W{}

    static class Test extends ID{
        String combine(U u, String v, String w){ return "U("+v+", "+w+")"; }
        String combine(V v, int i){ return "V["+i+"]"; }
        String combine(W w){ return "W"; }
    }
}