package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.stackless.HeapTrav;
import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.lib.Cons;
import edu.neu.ccs.demeterf.lib.Empty;
import edu.neu.ccs.demeterf.lib.List;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class Editor extends JComponent implements KeyListener{
    List<Char> buff = List.<Char>create(),
               clip = buff;
    int len = 0, index = 0, select = -1;
    static Font font = new Font("courier",Font.PLAIN,12);
    String file = ""; 
        
    Editor(){}
    void checkSelect(KeyEvent ke){
        if(ke.isShiftDown()){
            if(select < 0)select = index;
        }else
            select = -1;
    }
    static class FRes{
        int dist;
        List<Char> lst;
        FRes(int d, List<Char> l){ dist = d; lst = l; }
    }
    FRes findLine(List<Char> end){
        int dist = 0;
        while(!end.isEmpty() && !end.top().isNewLine()){
            end = end.pop();
            dist++;
        }
        return new FRes(dist,end);
    }
    void delete(boolean back){
        if(!buff.isEmpty()){
            if(select < 0){
                if(back && index > 0 || !back && index != len){
                    if(back)index--;
                    buff = buff.remove(index);
                    len--;
                }
            }else{
                int mn = Math.min(select,index),
                    mx = Math.max(select,index);
                for(int i = 0; i < mx-mn; i++)
                    buff = buff.remove(mn);
                select = -1;
                index = mn;
                len -= mx-mn;
            }
        }
    }
    boolean testChar(Char c, boolean letter){
        return letter == Character.isLetter(c.toChar());
    }
    int LRarrow(KeyEvent ke, List<Char> end){
        int dist = 0;
        if(ke.isControlDown()){
            if(!end.isEmpty()){
                boolean test = Character.isLetter(end.top().toChar());
                int times = test?1:2;
                do{
                    while(!end.isEmpty() && testChar(end.top(),test)){
                        end = end.pop();
                        dist++;
                    }
                    test = true;
                }while(--times > 0);
            }
        }else dist = 1;
        return dist;
    }
    int UParrow(KeyEvent ke, List<Char> end){
        if(ke.isControlDown())return len;
        FRes res = findLine(end);
        if(res.lst.isEmpty())
            return res.dist; 
        return Math.max(findLine(res.lst.pop()).dist+1,res.dist+1);
    }
    int DNarrow(KeyEvent ke, List<Char> b){
        if(ke.isControlDown())return len;
        FRes front = findLine(b.reverse(index));
        FRes back = findLine(b.pop(index));
        if(back.lst.isEmpty())
            return back.dist;
        return Math.min(back.dist+front.dist+1,
                        back.dist+findLine(back.lst.pop()).dist+1);
    }
    public void keyPressed(KeyEvent ke){
        switch(ke.getKeyCode()){
        case KeyEvent.VK_END:
            checkSelect(ke);index += findLine(buff.pop(index)).dist;break;
        case KeyEvent.VK_HOME:
            checkSelect(ke);index -= findLine(buff.reverse(index)).dist;break;
        case KeyEvent.VK_LEFT:
            checkSelect(ke);index -= LRarrow(ke,buff.reverse(index));break;
        case KeyEvent.VK_RIGHT:
            checkSelect(ke);index += LRarrow(ke,buff.pop(index));break;
        case KeyEvent.VK_UP:
            checkSelect(ke);index -= UParrow(ke,buff.reverse(index));break;
        case KeyEvent.VK_DOWN:
            checkSelect(ke);index += DNarrow(ke,buff);break;
        }
        if(index < 0)index = 0;
        if(index > len)index = len;
        repaint();
    }
    public void keyReleased(KeyEvent ke){}
    public void keyTyped(KeyEvent ke){
        //System.out.println("KEY["+index+"]: "+(int)ke.getKeyChar());
        if(ke.isControlDown()){
            control(ke);
            return; 
        }
        
        switch(ke.getKeyChar()){
        case '\010': delete(true); break;
        case '\177': delete(false); break;
        default:
            buff = buff.add(Char.create(ke.getKeyChar()), index++);
            len++;
        }
        repaint();
    }
    void control(KeyEvent ke){
        System.out.println("CONTROL:"+(int)ke.getKeyChar()+" == "+(int)KeyEvent.VK_C);
        System.out.println("CODE:"+ke.getKeyCode());
        switch(ke.getKeyChar()){
        case '\023': save();break;
        case '\027': write(file,true);break;
        case '\006': open();break;
        case '\003': copy();break;
        case '\026': paste();break;
        case '\030': cut();break;
        }
    }
    public static class Pos{
        int x,y;
        Pos(int xx, int yy){ x = xx; y = yy; }
    }
    public void paint(final Graphics g){
        g.setFont(Editor.font);
        g.drawRect(5, 5, getWidth()-10, getHeight()-10);
        new HeapTrav(new ID(){
            int update(Cons c, Cons.rest f, int i){ return i-1; }
            Pos combine(Empty l, int i){ return cursor(g,new Pos(12,24),i,0); }
            Pos combine(Cons<Char> l, NewLine n, Pos p, int i){
                return cursor(g,new Pos(12,p.y+15),i,-1);
            }
            Pos combine(Cons<Char> l, Char c, Pos p, int i){
                int w = g.getFontMetrics().charWidth(c.toChar())+1;
                cursor(g,p,i,w);
                selection(g,p,i,w);
                g.drawChars(new char[]{c.toChar()},0,1,p.x,p.y);
                if(p.x+w > getWidth()-24)
                    return  new Pos(12, p.y+15);
                return new Pos(p.x+w, p.y);
            }
            Pos cursor(Graphics g, Pos p, int i, int w){
                if(i == index)g.fillRect(p.x+w, p.y-12, 2, 15);
                return p;
            }
            void selection(Graphics g, Pos p, int i, int w){
                if(select < 0)return;
                if((index > select && select < i && i <= index) ||
                   (index < select && index < i && i <= select)){
                    Color prev = g.getColor();
                    g.setColor(Color.lightGray);
                    g.fillRect(p.x,p.y-12,w,15);
                    g.setColor(prev);
                }
            }
            
        }, Control.builtins(Char.class))
        .traverse(buff.reverse(),len);
    }
    void save(){
        if(file.length() == 0)write("untitled.txt",true);
        else write(file,false);
    }
    void write(String fname, boolean ask){
        if(ask){
            if(fname.charAt(0) != '/')
                fname = "./"+fname;
            JFileChooser chs = new JFileChooser(fname.substring(0,fname.lastIndexOf('/')));
            int res = chs.showSaveDialog(this);
            if(res == JFileChooser.APPROVE_OPTION){
                fname = chs.getSelectedFile().getAbsolutePath();
                file = fname;
            }else return;
        }
        List<Char> temp = buff;
        try{
            FileOutputStream out = new FileOutputStream(fname);
            while(!temp.isEmpty()){
                out.write(temp.top().toChar());
                temp = temp.pop();
            }
        }catch(IOException e){ System.err.println("ERROR: "+e); }
    }
    void open(){
        String f = file;
        if(file.length() == 0 || f.charAt(0) != '/')
            f = "./"+f;
        JFileChooser chs = new JFileChooser(f.substring(0,f.lastIndexOf('/')));
        int res = chs.showOpenDialog(this);
        if(res == JFileChooser.APPROVE_OPTION){
            f = chs.getSelectedFile().getAbsolutePath();
            System.err.println("FILE: "+f);
            file = f;
        }else return;
        buff = read(f);
        index = 0;
        len = buff.length();
        repaint();
    }
    void copy(){
        int st = Math.min(select,index),
            ed = Math.max(select,index);
        clip = buff.reverse(ed).reverse(ed-st);
        select = -1;
    }
    void cut(){
        int sel = select;
        if(sel >= 0){
            copy();
            select = sel;
            delete(true);
        }
    }
    void paste(){
        System.out.println("Paste: "+clip);
        if(!clip.isEmpty()){
            if(select >= 0)
                delete(true);
            List<Char> tclip = clip.reverse();
            while(!tclip.isEmpty()){
                buff = buff.add(tclip.top(), Math.max(0, index));
                len++;
                tclip = tclip.pop();
            }
            index += clip.length();
        }
    }
    public static void main(String s[]){
        JFrame f = new JFrame();
        Editor e = new Editor();
        f.getContentPane().add(e);
        f.addKeyListener(e);
        f.setSize(300,300);
        f.setLocation(200,100);
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setVisible(true);
    }
    public static List<Char> read(String s){
        List<Char> lst = List.<Char>create();
        try{
            FileInputStream in = new FileInputStream(s);
            while(in.available() > 0)
                lst = lst.push(Char.create((char)in.read()));
        }catch(IOException e){
        }
        return lst.reverse();
    }
}

abstract class Char{
    abstract char toChar();
    static Char create(char c){
        switch(c){
        case '\n': return new NewLine();
        default: return new Wrap(c);
        }
    }
    boolean isNewLine(){ return false; }
    public String toString(){ return ""+toChar(); }
}
class NewLine extends Char{
    char toChar(){ return '\n'; }
    boolean isNewLine(){ return true; }
}
class Wrap extends Char{
    char ch;
    Wrap(char c){ ch = c; }
    char toChar(){ return ch; }
} 