package edu.neu.ccs.demeterf.dispatch;

import edu.neu.ccs.demeterf.lib.List;

/** Implementation of Lessthan for sorting DBEntries.  The most specific method
 *    is the one with the most specific parameter types. If the types of one method
 *    are a prefix of the other (same types, but the second is longer) then we choose
 *    the method with more arguments. */
public class TypeSort<M> extends List.Comp<DBEntry<M>>{
    public boolean comp(DBEntry<M> e1, DBEntry<M> e2){
        return compare(e1,e2);
    }
    public static <M> boolean compare(DBEntry<M> e1, DBEntry<M> e2){
        int min = Math.min(e1.numArgs(), e2.numArgs());
        for(int i = 0; i < min; i++){
            if(!e1.arg(i).equals(e2.arg(i)))
                return !(e1.arg(i).isAssignableFrom(e2.arg(i)));
        }
        return (e1.numArgs() > e2.numArgs());
    }
    
}