package edu.neu.ccs.demeterf.dispatch;
import java.util.*;

import edu.neu.ccs.demeterf.util.Util;

/** Represents a Type... an abstraction of a Java Class. The idea
 *    is to implement all the dispatch based on Types, not Classes, so
 *    we can do special things for special types like <i>Star</i> (*) */
public abstract class Type{
    static class ClsP{
        String s; Class<?> c;
        ClsP(String ss, Class<?> cc){ s = ss; c = cc; }
    }
    static ClsP baseTypes[] = {
        new ClsP("short",short.class),
        new ClsP("int",int.class),
        new ClsP("long",long.class),
        new ClsP("float",float.class),
        new ClsP("double",double.class),
        new ClsP("char",char.class),
        new ClsP("byte",byte.class),
        new ClsP("boolean",boolean.class)}; 
    
    public static Class<?> classForName(String s){ return searchForClass(s); }
    
    static Stack<String> searchPath = new Stack<String>();
    public static String extend(String s){
        return (s.length() > 0 && s.charAt(s.length()-1) != '.')?s + ".":s;
    }
    public static void addPath(String s)
    { searchPath.insertElementAt(extend(s),0); }
    public static void removePath(String s)
    { searchPath.remove(extend(s)); }
    static{
        addPath("java.lang.");
        addPath("");
    }
    
    public static Class<?> searchForClass(String s){
        //s = s.replace('$', '.');
        if(Character.isLowerCase(s.charAt(0))){
            for(int i = 0; i < baseTypes.length; i++)
                if(baseTypes[i].s.equals(s))
                    return baseTypes[i].c;
        }
        for(String p:searchPath){
            //System.out.println(" SEARCH: "+p+s);
            try{ return Class.forName(p+s); }
            catch(ClassNotFoundException e){
                //System.out.println(" BAD SEARCH: "+p+s);
            }
        }
        String path = "";
        for(String p:searchPath)
            if(p.length() > 0)path += "     "+p+"*\n";
        throw new TypeSearchException(" ** Class Not Found: "+s+"\n  Search Paths:\n"+path);
    }
    
    public static Class<?>[] fromClassArray(Class<?> c[]){
        for(int i = 0; i < c.length; i++)
            c[i] = Util.box(c[i]);
        return c;
    }
    
    public static void main(String[] args){
        try{
            Type.classForName(args[0]);
            System.err.println("  :) Found");
        }catch(TypeSearchException e){
            System.err.println(" >:( Not Found");
            System.err.println(e.getMessage());
        }
    }
}