package edu.neu.ccs.demeterf.demfgen.traversals;

import edu.neu.ccs.demeterf.demfgen.*;

/** Represents a little traversal factory, so there's a central place to
 *    switch from reflective to inlined/generated traversals. The traversal factories
 *    are placed in the following classes:
 *    <ul>
 *       <li><code>edu.neu.ccs.demeterf.demfgen.Factory</code></li>
 *       <li><code>edu.neu.ccs.demeterf.demfgen.traversals.Travs</code></li>
 *       <li><code>edu.neu.ccs.demeterf.demfgen.dgp.traversals.Travs</code></li>
 *    </ul>
 */
public class Travs{
    //public static Travs TheFactory = new Travs();
    public static ReflectiveTraversals TheFactory = new ReflectiveTraversals();
    
    public static DGPGenTrav makeDGPGenTrav(DemFGenMain.DGPGen f){ return new DGPGenTrav(f); }
    public TypeCheckTrav makeTypeCheckTrav(TypeCheck f){ return new TypeCheckTrav(f); }
    public ClassGenTrav makeClassGenTrav(ClassGen f){ return new ClassGenTrav(f); }
    public ParseGenTrav makeParseGenTrav(ParseGen.CombStr f){ return new ParseGenTrav(f); }
    public JJGenTrav makeJJGenTrav(ParseGen.JJProd f){ return new JJGenTrav(f); }
    public ParamArityTrav makeParamArityTrav(ClassGen.ToList f){ return new ParamArityTrav(f); }
    public TypeArityTrav makeTypeArityTrav(ClassGen.ToTDList f){ return new TypeArityTrav(f); }
}
