package edu.neu.ccs.demeterf.demfgen.dgp;

import edu.neu.ccs.demeterf.demfgen.*;
import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.demfgen.dgp.traversals.Travs;
import edu.neu.ccs.demeterf.lib.*;

/** Generate CD specific traversal code that statically distinguishes traversable
 *    types and calls to DemeterF dispatch functions when all child results have
 *    returned.
 *  <p>Users will create new instances of StaticTrav as an alternative to the
 *    usual DemeterF Traversal.  It currently provides quite a boost in
 *    performance compared to Java Reflection.</p> */
public class StaticTrav extends TravMethods{
    public StaticTrav(){ this(""); }
    public StaticTrav(String beh){ super(beh, !Diff.optionSet(Diff.noctrl)); }
    public StaticTrav functionObj(String beh){ return new StaticTrav(beh); }
    public String docComment(){ return "Creates a Static version of Traversal for a specific CD without a Context"; }
    
    public String stubMethod(){ return ""; }
    public String method(String pkg){ return ""; }
    
    public String superClass(){ return "edu.neu.ccs.demeterf.Traversal"; }
    public String combine(Some<List<TypeDef>> some, String s){
        return finish(some.inner(),"","\n"+header()+"\n"+s);
    }
    /** Use an inlined traversal */
    public Trav realTraversalObj(){
        return Travs.TheFactory.makeStaticTravTrav(this);
    }
    public String[] builtins(){
        List<String> notprims = Diff.d.boxed.filterout(new List.Pred<String>(){
            public boolean huh(String s){ return Diff.d.primitives.contains(s); }
        });
        return notprims.toArray(new String[notprims.length()]);    
    }
    public String builtin(String b){ return primitive(b); }
    public String primitive(String p){
        return "   public "+Diff.d.paramMethodDef("traverse"+p, "_R", "_R")+
        "("+p+" o"+(context?", Object "+ctxName:"")+
        "){ return (_R)applyBuilder(new Object[]{o"+(context?", "+ctxName:"")+"}, true); }\n";
    }

    public String combine(UseParams up){ return ""; }
    public EmptyUseParams combine(EmptyUseParams e){ return e; }
    
    public Syntax combine(Syntax s){ return s; }
    public String combine(SumToken s){ return ""; }
    public String combine(Empty<?> e){ return ""; }
    public String combine(Cons<?> c, String f, String r){ return f+r; }
    
    String header(){
        String cls = this.getClass().getSimpleName();
        if(Diff.isJava())
            return
        "   public "+cls+"(edu.neu.ccs.demeterf.FC f){ super(f); }\n"+
        "   public "+cls+"(edu.neu.ccs.demeterf.FC f, edu.neu.ccs.demeterf.Control c){ super(f,c); }\n\n";
        return
        "   public "+cls+"(edu.neu.ccs.demeterf.FC f):base(f){}\n"+
        "   public "+cls+"(edu.neu.ccs.demeterf.FC f, edu.neu.ccs.demeterf.Control c):base(f,c){}\n\n";
    }
}

abstract class TravMethods extends TravGeneric{
    boolean control;
    boolean context = false;
    String ctxName = "_ctx";
    TravMethods(String beh, boolean ctrl){ super(beh); control = ctrl; }
    public String combine(Bound b){ return ""; }
    public String combine(ClassDef td, DoGen g, ident n, TypeDefParams dp, Empty<TypeUse> sts, Flds fs){
        String ddp = ClassGen.unlocal(dp);
        return ("   public "+Diff.d.paramMethodDef("traverse"+Flds.addSpacers(n,ddp), "_R", "_R")+
                "("+n+ddp+" _h"+(context?", Object "+ctxName:"")+
                "){\n"+
                (control?"      if(control.isBuiltIn("+Diff.d.classType(""+n, ddp)+"))\n"+
                "          return (_R)applyBuilder(new Object[]{_h"+(context?", "+ctxName:"")+"}, true);\n":"")+
                fs.meths(""+n, dp, control, context)+
                "      return (_R)applyBuilder("+fs.objArray((context?", "+ctxName:""))+", false);\n   }\n");
    }
    //Flds combine(ProdType p, Flds fs){ return fs; }
    public Flds combine(FieldList l, Flds.P p, Flds fs){ return fs.push(p); }
    public Flds combine(FieldList l, Syntax s, Flds fs){ return fs; }
    public Flds combine(FieldEmpty e){ return new Flds(); }
    public Flds.P combine(Field f, ident n, TypeUse t){ return new Flds.P(t,""+n); }
    
    public String combine(IntfcDef ifd, DoGen g, ident n, TypeDefParams dp, List<TypeUse> un){ return combine(g, n, dp, un); }
    public String combine(ClassDef cd, DoGen g, ident n, TypeDefParams dp, List<TypeUse> un){ return combine(g, n, dp, un); }
    public String combine(DoGen g, ident n, TypeDefParams dp, List<TypeUse> un){
        String ddp = ClassGen.unlocal(dp);
        return ("   public "+Diff.d.paramMethodDef("traverse"+Flds.addSpacers(n,ddp),"_R","_R")+
                "("+n+ddp+" _h"+(context?", Object "+ctxName:"")+"){\n"+
                (control?"      if(control.isBuiltIn("+Diff.d.classType(""+n,ddp)+"))\n"+
                "          return (_R)applyBuilder(new Object[]{_h"+(context?", "+ctxName:"")+"}, true);\n":"")+
                un.foldr(new List.Fold<TypeUse, String>(){
                    public String fold(TypeUse t, String r){
                        return "      if(_h"+Diff.d.instanceCheck((Diff.d.isJava()?""+t.getName():""+t), "")+
                        ") return this."+Diff.d.paramMethod("traverse"+Flds.addSpacers(t),"_R")+"(("+t+")_h"+
                        (context?", "+ctxName:"")+");\n"+r;
                    }
                }, "      else throw new "+Diff.d.runtimeException+"(\"Unknown "+n+" Variant\");\n")+
                "   }\n");
    }
    public List<TypeUse> combine(SubtypeEmpty e){ return List.create(); }
    public List<TypeUse> combine(SubtypeCons c, TypeUse tu, List<TypeUse> r){ return r.push(tu); }
    public List<TypeUse> combine(NESubtypeList c, TypeUse tu, List<TypeUse> r){ return r.push(tu); }
    //List<TypeUse> combine(SumType s, String pre, List<TypeUse> union, String post){
    //    return union;
    //}   
}