package edu.neu.ccs.demeterf.demfgen.dgp;

import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.ClassGen;
import edu.neu.ccs.demeterf.lib.*;

/** Generate a CD specific TU for the given CD */
public class StaticTU extends StaticTP{
    static String RET = "_X_";
    public StaticTU(){ this(""); }
    public StaticTU(String beh){ super(beh); }
    public StaticTU functionObj(String beh){ return new StaticTU(beh); }
    public String docComment(){ return "Creates a Static version of the TU class for a specific CD"; }
    public String typeargs(){ return "<"+RET+">"; }
    public boolean isAbstract(){ return true; }
    
    /** */
    public List.GComp<TypeUse,TypeDef> genericComp(){
        return TravGeneric.genericByNameOnly();
    }
    public String combine(Some<List<TypeDef>> some, String s){
        return finish(some.inner(),"",
                "   public abstract "+RET+" fold("+RET+" a, "+RET+" b);\n"+
                "   public abstract "+RET+" combine();\n"+s);
    }
    public String primitive(String p){
        //return "";
        return "   public "+RET+" combine("+p+" _h_){ return combine(); }\n";    
    }
    public String combine(ClassDef td, DoGen g, ident n, TypeDefParams dp, Empty<TypeUse> sts, Flds fs){
        List<String> rs = fs.getArgs();
        return ("   public "+RET+" combine("+n+(Diff.isCS()?""+ClassGen.unlocal(dp):"")+" _h_"+(rs.isEmpty()?"":", ")+
                rs.toString(", ", RET+" ")+"){\n"+
                "      return "+special(rs)+";\n"+
                "   }\n");
    }
    String special(List<String> rs){
        if(rs.isEmpty())return "combine()";
        if(rs.pop().isEmpty())return rs.top();
        return "fold("+rs.top()+","+special(rs.pop())+")";
    }
    public String combine(ClassDef td, DoGen g, ident n, TypeDefParams dp, List<TypeUse> un){ return ""; }   
    public String combine(IntfcDef td, DoGen g, ident n, TypeDefParams dp, List<TypeUse> un){ return ""; }
}