package edu.neu.ccs.demeterf.demfgen.dgp;

import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDefParams;
import edu.neu.ccs.demeterf.demfgen.classes.TypeUse;
import edu.neu.ccs.demeterf.demfgen.ClassGen;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.ident;
import edu.neu.ccs.demeterf.util.Util;

/**  */
public class Flds {
    /** Represnets a pair of Type/FieldName */
    public static class P{
        TypeUse t;
        String n;
        P(TypeUse tt, String nn){ t = tt; n = nn; }
        String meth(String type, TypeDefParams dp, boolean ctrl){ return meth(type,dp,ctrl,false); }
        String meth(String type, TypeDefParams dp, boolean ctrl, boolean ctx){
            return ("Object "+n+" = "+
                    (ctrl?"(control.skip("+Diff.d.classType(type,ClassGen.unlocal(dp))+", \""+n+"\""+"))?"+
                            "(_h."+Diff.capName("get"+Util.capCase(n))+"()):":"")+
                    "this."+Diff.d.paramMethod("traverse"+addSpacers(t.getName(),""+t.getTparams()),"Object")+
                    "(_h."+Diff.capName("get"+Util.capCase(n))+"()"+
                    (ctx?", "+update(type, dp, n, "_ctx"):"")+");\n");
        }
        String update(String type, TypeDefParams dp, String fn, String ctx){
            return "applyAugment(new Object[]{_h, "+ctx+"}, "+Diff.d.classType(type, ClassGen.unlocal(dp))+", \""+fn+"\")";
        }
    }
    /** Add spacers to a generic TypeUse for traversal method Names */
    public static String addSpacers(TypeUse t){ return addSpacers(t.getName(), ""+t.getTparams()); }
    public static String addSpacers(ident n, String dp){
        String name = ""+n;
        return (name+dp).replace('<', '_').replace('>', '_').replace(',','_');    
    }
    
    List<P> fs;
    public Flds(){ this(List.<P>create()); }
    private Flds(List<P> fl){ fs = fl; }
    public Flds push(P p){ return new Flds(fs.push(p)); }
    public String meths(final String type, final TypeDefParams dp, final boolean ctrl, final boolean ctx){
        return fs.fold(new List.Fold<P, String>(){
            public String fold(P p, String s){ return s+"      "+p.meth(type,dp,ctrl, ctx); }
        }, "");
    }
    public String objArray(String ctx){ return "new Object[]{_h"+callArgs()+ctx+"}"; }
    public String formArgs(){
        return fs.fold(new List.Fold<P, String>(){
            public String fold(P p, String s){ return s+", "+p.t+" "+p.n; }
        }, "");
    }
    public String callArgs(){ return callArgs(true); }
    
    public List<String> getArgs(){
        return fs.map(new List.Map<P, String>(){
            public String map(P p){ return p.n; }
        });
    }
    public String callArgs(boolean leadCom){
        List.Fold<P, String> fold = new List.Fold<P, String>(){
            public String fold(P p, String s){ return s+", "+p.n; }
        };
        if(!leadCom && !fs.isEmpty())
            return fs.top().n+fs.pop().fold(fold, "");
        return fs.fold(fold, "");
    }
}
