package edu.neu.ccs.demeterf.demfgen.dgp;

import edu.neu.ccs.demeterf.demfgen.DFGTrav;
import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.control.*;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.Factory;
import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.lib.*;

/** The base class of Data-Generic Function generation objects. DGP Functions are
 *    traversals that return Strings representing some computated value based on a
 *    given CD.  Usually this translates into a class definition of some function
 *    like <tt>Print</tt> or <tt>ToString</tt>,  but could also be some meta
 *    information like a graph of the CD, or static traversal code. */
public abstract class DGPFunc extends FC{
    /** Need this one for the whole thing to work right... */
    public DGPFunc(String beh){ behavior = beh; }
    
    /* Generational Setup Methods ("Meta") */
    /** Extra behavior that the user might add */
    protected String behavior = ""; 
    /** The function object responsible for function generation */
    protected abstract FC functionObj(String beh);
    
    public interface Trav{
        String traverseOption_List_TypeDef__(Option<List<TypeDef>> ts);
        String traverseTypeDef(TypeDef td);
    }
    
    /** Traversal responsible for class/function generation.  The traversal
     *   is assumed to be Option(List(TypeDef)) --> String*/
    public abstract Trav traversalObj(final String beh);
    //{ return wrapTrav(Factory.newTraversal(functionObj(beh), control())); }
    
    /** Wrap a DFGTrav into a DGPFunc.Trav for testing */
    public static Trav wrapTrav(final DFGTrav t){
        return new Trav(){
            public String traverseOption_List_TypeDef__(Option<List<TypeDef>> ts)
            { return t.traverseOption_List_TypeDef__(ts); }
            public String traverseTypeDef(TypeDef td){ return t.traverseTypeDef(td); }
        };
    }
    /** Final entry point, Traversal will end here... eventually */
    public abstract String combine(Some<List<TypeDef>> defs, String s);
    
    /** Documentation comment to be placed above the Class definition */
    public abstract String docComment();
    /** Import declarations */
    public String header(String com, PackageDef pkg, String cdImports)
    { return com+pkg+Diff.d.parserImport+cdImports; }
    
    
    /** Traversal control for this function generation */
    public Control control(){ return baseControl(); }
    /** Return the normal Control needed... subclasses can mutate it if needed. */
    public MutableControl baseControl(){ return Control.builtins(); }
    /** First part of the file name (no extension) */
    public String fileName(){ return this.getClass().getSimpleName(); }
    /** The Extension of the output File */
    public String fileSuffix(){ return Diff.d.fileSuffix; }
    /** Initial traversal argument (Some|None) */
    public Option<?> startArgument(){ return Option.none(); }
    
    
    /* Output Method Setup */
    /** Returns the name of the Method to be added to each generated class */
    public String methodName(){ return Diff.capName(getClass().getSimpleName()); }
    /** Needed for C#: Does this generated Method override something in Object? E.g., toString()
     *    does, but print() does not. */
    public boolean override(){ return false; }
    /** An Array of built ins for the traversal. Language specific primitives are
     *    added to this array. */
    public String[] builtins(){ return new String[0]; }
    /** The return type of the generated method. E.g., ToString would be "String" */
    public String methodReturn(){ return "String"; }
    /** The name of the static stub method */
    public String stubMethodName(){
        return (fileName()+"M");
    }
    /** The full static stub method within the generated class. This is called by the
     *    method implementations to make the generated code cleaner.  It is placed in
     *    the DGP generated class by default. */
    public String stubMethod(){
        return ("   /** Static stub method for calling "+methodName()+" */\n"+
                "   public static "+methodReturn()+" "+stubMethodName()+"(Object o){\n"+
                "      "+stubMethodBody()+"\n   }\n\n");
    }
    /** The body of the method stub. Usually just create a new traversal with a new
     *    instace of the generated class (this), returning the traversal result. */
    public String stubMethodBody(){
        return ("return new edu.neu.ccs.demeterf.Traversal(new "+
                fileName()+"(),edu.neu.ccs.demeterf.Control.builtins("+wrap(builtins())+"))."+
                Diff.d.paramMethod("traverse",methodReturn())+"(o"+(hasArgument()?","+argument():"")+");");
    }
    /** The stub method implementation; just needs to call the static method. */
    public String method(String pkg){
        return ("    /** DGP method from Class "+getClass().getSimpleName()+" */\n"+
                "    public"+(override()?Diff.d.override+" ":" ")+
                methodReturn()+" "+methodName()+"(){ "+
                methodBody(pkg)+" }\n");
    }
    /** The body of the stub method. */
    public String methodBody(String pkg){
        if(pkg.length()>0)pkg += ".";
        return ("return "+(Diff.isCS()?"global::":"")+pkg+fileName()+
                "."+fileName()+"M(this);");
    }
    /** Does the generated traversal method take an argument? */
    public boolean hasArgument(){ return false; }
    /** What is the starting argument expression? */
    public String argument(){ return "null"; }
    
    /** Wrap the builtins for use with traversal control.  */
    static String wrap(String[] bins){
        String ret = "";
        for(int i = 0; i < bins.length; i++)
            ret += ((i>0)?",":"")+(Diff.isCS()?"typeof("+bins[i]+")":bins[i]+".class");
        return ret;
    }
}
