package edu.neu.ccs.demeterf.demfgen;

/**  */
public class Preamble{
    public static String header =
        "// ** This file was generated with DemFGen (vers:"+Diff.buildDate+")\n\n";
    
    public static String lexer = 
        "SKIP : { \" \" | \"\\t\" | \"\\n\" | \"\\r\" | \"\\r\\n\" }\n"+
        "SKIP : { < \"//\" (~[\"\\n\",\"\\r\"])* (\"\\n\"|\"\\r\\n\") >\n"+
        "       | < \"/*\" (~[\"*\"])* \"*\" (~[\"/\"] (~[\"*\"])* \"*\")* \"/\" > }\n"+
        "TOKEN: { < TRUE : \"true\" >\n"+
        "       | < FALSE : \"false\" > }\n"+
        "TOKEN: { < INT : (\"+\" | \"-\")? ( ([\"0\"-\"9\"])+ \n"+
        "                                  | (\"0\" [\"x\",\"X\"]) ([\"0\"-\"9\",\"a\"-\"f\",\"A\"-\"F\"])+ ) >\n"+
        "       | < DOUBLE : (\"-\")?([\"0\"-\"9\"])+ \".\" ([\"0\"-\"9\"])+ (<EXPON>)?\n"+
        "                            | \".\" ([\"0\"-\"9\"])+  (<EXPON>)? >\n"+
        "       | < #EXPON: [\"e\",\"E\"] ([\"+\",\"-\"])? ([\"0\"-\"9\"])+ > }\n"+ 
        "TOKEN: { < CHAR: \"\\'\" \n"+
        "              ( (~[\"\\'\",\"\\\\\",\"\\n\",\"\\r\"]) | \n"+
        "                (\"\\\\\" ( [\"n\",\"t\",\"b\",\"r\",\"f\",\"\\\\\",\"\\'\",\"\\\"\"] |\n"+
        "                            [\"0\"-\"7\"] ( [\"0\"-\"7\"] )? |\n"+
        "                            [\"0\"-\"3\"] [\"0\"-\"7\"] [\"0\"-\"7\"] ) ) )\n"+
        "              \"\\'\" >\n"+
        "       | < STRING :\n"+
        "              \"\\\"\"\n"+
        "              (   (~[\"\\\"\",\"\\\\\",\"\\n\",\"\\r\"])\n"+
        "                | (\"\\\\\"\n"+
        "                    ( [\"n\",\"t\",\"b\",\"r\",\"f\",\"\\\\\",\"'\",\"\\\"\"]\n"+
        "                    | [\"0\"-\"7\"] ( [\"0\"-\"7\"] )?\n"+
        "                    | [\"0\"-\"3\"] [\"0\"-\"7\"] [\"0\"-\"7\"]\n"+
        "                    )\n"+
        "                  )\n"+
        "              )*\n"+
        "              \"\\\"\" >\n"+
        "       | < TEXT : ( \"{{\" (~[\"}\"])* ( \"}\" ~[\"}\"] (~[\"}\"])* )* \"}}\" ) >\n"+
        "       | < IDENT : [\"a\"-\"z\",\"A\"-\"Z\",\"$\",\"_\"]\n"+
        "                   ([\"a\"-\"z\",\"A\"-\"Z\",\"0\"-\"9\",\"_\",\"$\"])* > }\n";

    public static String parserJava = 
        "byte parse_byte():{ int i; }{\n"+
        "    i = parse_int() { return (byte)i; }\n}\n"+
        "Byte parse_Byte():{ byte b; }{\n"+
        "    b = parse_byte() { return b; }\n}\n"+
        "short parse_short():{ int i; }{\n"+
        "    i = parse_int() { return (short)i; }\n}\n"+
        "Short parse_Short():{ short s; }{\n"+
        "    s = parse_short() { return s; }\n}\n"+
        "int parse_int():{ Token t; }{\n"+
        "    t = <INT>\n"+
        "    { if(t.image.length() > 1 && Character.toLowerCase(t.image.charAt(1)) == 'x')\n" +
        "          return Integer.parseInt(t.image.substring(2), 16);\n"+
        "      return Integer.parseInt(t.image); }\n}\n"+
        "Integer parse_Integer():{ int i; }{\n"+
        "    i = parse_int() { return i; }\n}\n"+
        "long parse_long():{ Token t; }{\n"+
        "    t = <INT>\n"+
        "    { if(t.image.length() > 1 && Character.toLowerCase(t.image.charAt(1)) == 'x')\n" +
        "          return Long.parseLong(t.image.substring(2), 16);\n"+
        "    return Long.parseLong(t.image); }\n}\n"+
        "Long parse_Long():{ long l; }{\n"+
        "    l = parse_long() { return l; }\n}\n"+
        "double parse_double():{ Token t; }{\n"+
        "    t = <DOUBLE>\n"+
        "    { return Double.parseDouble(t.image); }\n}\n"+
        "Double parse_Double():{ double d; }{\n"+
        "    d = parse_double() { return d; }\n}\n"+
        "float parse_float():{ Token t; }{\n"+
        "    t = <DOUBLE>\n"+
        "    { return Float.parseFloat(t.image); }\n}\n"+
        "Float parse_Float():{ float f; }{\n"+
        "    f = parse_float() { return f; }\n}\n"+
        "String parse_String():{ Token t; }{\n"+
        "    t = <STRING>\n"+
        "    { return unescape(t.image.substring(1,t.image.length()-1)); }\n}\n"+
        "boolean parse_boolean():{ Token t; }{\n"+
        "    t = <TRUE> { return true; } |\n"+
        "    t = <FALSE> { return false; }\n}\n"+
        "Boolean parse_Boolean():{ boolean b; }{\n"+
        "    b = parse_boolean() { return b; }\n}\n"+
        "char parse_char():{ Token t; }{\n"+
        "    t = <CHAR>\n"+
        "    { return unescape(t.image.substring(1,t.image.length()-1)).charAt(0); }\n}\n"+
        "Character parse_Character():{ char c; }{\n"+
        "    c = parse_char() { return c; }\n}\n"+
        
        // DemeterF (demfgen.lib) Specific Classes...
        "ident parse_ident():{ Token t; }{\n"+
        "    t = <IDENT>\n"+
        "    { return new ident(t.image); }\n}\n"+
        "verbatim parse_verbatim():{ Token t; }{\n"+
        "    t = <TEXT>\n"+
        "    { return new verbatim(t.image.substring(2,t.image.length()-2)); }\n}\n";
        
    public static String parserCS =
        "byte parse_byte():{ int i; }{\n"+
        "    i = parse_int() { return (byte)i; }\n}\n"+
        "Byte parse_Byte():{ byte b; }{\n"+
        "    b = parse_byte() { return b; }\n}\n"+
        "short parse_short():{ Token t; }{\n"+
        "    t = <INT>\n"+
        "    { return Int16.Parse(t.image); }\n}\n"+
        "Int16 parse_Int16():{ short i; }{\n"+
        "    i = parse_short() { return i; }\n}\n"+
        "int parse_int():{ Token t; }{\n"+
        "    t = <INT>\n"+
        "    { return Int32.Parse(t.image); }\n}\n"+
        "Int32 parse_Int32():{ int i; }{\n"+
        "    i = parse_int() { return i; }\n}\n"+
        "long parse_long():{ Token t; }{\n"+
        "    t = <INT>\n"+
        "    { return Int64.Parse(t.image); }\n}\n"+
        "Int64 parse_Int64():{ long l; }{\n"+
        "    l = parse_long() { return l; }\n}\n"+
        "double parse_double():{ Token t; }{\n"+
        "    t = <DOUBLE>\n"+
        "    { return Double.Parse(t.image); }\n}\n"+
        "Double parse_Double():{ double d; }{\n"+
        "    d = parse_double() { return d; }\n}\n"+
        "float parse_float():{ Token t; }{\n"+
        "    t = <DOUBLE>\n"+
        "    { return Single.Parse(t.image); }\n}\n"+
        "Single parse_Single():{ Single s; }{\n"+
        "    s = parse_float() { return s; }\n}\n"+
        "String parse_string():{ Token t; }{\n"+
        "    t = <STRING>\n"+
        "    { return t.image.Substring(1,t.image.Length-2); }\n}\n"+
        "String parse_String():{ string s; }{\n"+
        "    s = parse_string() { return s; }\n}\n"+
        "bool parse_bool():{ Token t; }{\n"+
        "    t = <TRUE> { return true; } |\n"+
        "    t = <FALSE> { return false; }\n}\n"+
        "Boolean parse_Boolean():{ bool b; }{\n"+
        "    b = parse_bool() { return b; }\n}\n"+
        "char parse_char():{ Token t; }{\n"+
        "    t = <CHAR>\n"+
        "    { return unescapeChar(t.image); }\n}\n"+
        "Char parse_Char():{ char c; }{\n"+
        "    c = parse_char() { return c; }\n}\n"+
        
        // DemeterF (demfgen.lib) Specific Classes...
        "ident parse_ident():{ Token t; }{\n"+
        "    t = <IDENT>\n"+
        "    { return new ident(t.image); }\n}\n"+
        "verbatim parse_verbatim():{ Token t; }{\n"+
        "    t = <TEXT>\n"+
        "    { return new verbatim(t.image.Substring(2,t.image.Length-2)); }\n}\n";
    
    public static String escapeChar =
        "   public static String escape(char c){\n"+
        "      switch(c){\n"+
        "      case '\\n':return \"\\\\n\";  case '\\t':return \"\\\\t\";\n"+
        "      case '\\b':return \"\\\\b\";  case '\\r':return \"\\\\r\";\n"+
        "      case '\\f':return \"\\\\f\";  case '\\\\':return \"\\\\\\\\\";\n"+
        "      case '\\'':return \"\\\\'\"; case '\\\"':return \"\\\\\\\"\";\n"+
        "      default: return \"\"+c;\n"+
        "      }\n"+
        "   }\n";
    
    public static String escapeMethodsJava =
        "   public static String escape(String s){\n"+
        "      char str[] = s.toCharArray();\n"+
        "      StringBuffer ret = new StringBuffer(\"\");\n"+
        "      for(char c:str)ret.append(escape(c));\n"+
        "      return ret.toString();\n"+
        "   }\n"+escapeChar;
    
    public static String escapeMethodsCS =
        "   public static string escape(string s){\n"+
        "       string ret = \"\";\n"+
        "       foreach(char c in s)ret += escape(c);\n"+
        "       return ret;\n"+
        "   }\n"+escapeChar;
    
    // Unescaping strings is gross...
    public static String unescapeMethodJava = 
        "   public static String unescape(String str){\n"+
        "      String retval = \"\";\n"+
        "      int index = 0;\n"+
        "      char ch, ch1;\n"+
        "      int ordinal = 0;\n"+
        "      while (index < str.length()) {\n"+
        "         if(str.charAt(index) != '\\\\') { retval += str.charAt(index++); continue; }\n"+
        "         ch = str.charAt(++index);\n"+
        "         if(ch == 'b') { retval += '\\b'; index++; continue; }\n"+
        "         if(ch == 't') { retval += '\\t'; index++; continue; }\n"+
        "         if(ch == 'n') { retval += '\\n'; index++; continue; }\n"+
        "         if(ch == 'f') { retval += '\\f'; index++; continue; }\n"+
        "         if(ch == 'r') { retval += '\\r'; index++; continue; }\n"+
        "         if(ch == '\"') { retval += '\\\"'; index++; continue; }\n"+
        "         if(ch == '\\'') { retval += '\\''; index++; continue; }\n"+
        "         if(ch == '\\\\') { retval += '\\\\'; index++; continue; }\n"+
        "         if(ch >= '0' && ch <= '7'){\n"+
        "            ordinal = ((int)ch) - ((int)'0'); index++;\n"+
        "            ch1 = str.charAt(index);\n"+
        "            if(ch1 >= '0' && ch1 <= '7'){\n"+
        "               ordinal = ordinal*8 + ((int)ch1) - ((int)'0'); index++;\n"+
        "               ch1 = str.charAt(index);\n"+
        "               if(ch <= '3' && ch1 >= '0' && ch1 <= '7'){\n"+
        "                  ordinal = ordinal*8 + ((int)ch1) - ((int)'0'); index++;\n"+
        "               }\n"+
        "            }\n"+
        "            retval += (char)ordinal;\n"+
        "            continue;\n"+
        "         }\n"+
        "         if(ch == 'u'){\n"+
        "            ordinal = 0;\n"+
        "            for(int i = 0; i < 4; i++){\n"+
        "               index++; ch = str.charAt(index);\n"+
        "               ordinal = ordinal*16+hexval(ch);\n"+
        "            }\n"+
        "            index++;\n"+
        "            retval += (char)ordinal;\n"+
        "            continue;\n"+
        "         }\n"+
        "      }\n"+
        "      return retval;\n"+
        "   }\n"+
        "   static int hexval(char c){\n"+
        "      int r = \"0123456789ABCDEF\".indexOf(Character.toUpperCase(c));\n"+
        "      if(r >= 0)return r;\n"+
        "      throw new RuntimeException(\" ** Bad Escaped Character\");\n"+
        "   }\n";
    
    public static String parserBodyCS =
        "\n    static char unescapeChar(String s){\n"+
        "        s = s.Substring(1,s.Length-1);"+
        "        char c = s[0];\n"+
        "        if (c == '\\\\'){\n"+
        "            switch (s[1]) {\n"+
        "            case 'n': return '\\n';  case 't': return '\\t';\n"+
        "            case 'b': return '\\b';  case 'r': return '\\r';\n"+
        "            case 'f': return '\\f';  case '\\\\': return '\\\\';\n"+
        "            case '\\'': return '\\''; case '\\\"': return '\\\"';\n"+
        "            default: return (char)(Convert.ToInt32(s.Substring(1, s.Length), 8));\n"+
        "            }\n"+
        "        }\n"+
        "        return c;\n"+
        "    }\n";
    
    public static String parserBodyJava =
        "\n"+unescapeMethodJava;
}
