/* EdgeControl.java
 * Bryan Chadwick :: 2007
 * Adds the ability to skip/bypass edges and modify BuiltIns
 *   while Traversing */

package edu.neu.ccs.demeterf.control;

/** Supports the ability to skip/bypass edges while Traversing.  It is essentially
 *    the opposite of the EdgeBypass control.  Using this class you can dictate
 *    the <b>only</b> edges to be traversed, rather than stating which edges will
 *    <b>not</b> be traversed.    
 */
public class EdgeOnly extends EdgeBypass{
    public EdgeOnly(Edge ... edges){ super(edges); }
    /** Only traverse the edges of the given classes */
    public EdgeOnly(Class<?> ... cs){ super(cs); }
    
    /** Takes a String in the format of "package.Class.edge "+ (meaning more than one). 
     *    We then attempt to create an EdgeOnly with which the given edges will be
     *    traversed. Static methods within {@link edu.neu.ccs.demeterf.dispatch.Type}
     *    can be used to extend the paths that that are used to search for classes. */
    public EdgeOnly(String bypass){ super(bypass); }
    public EdgeOnly(String pkg, String bypass){ super(pkg, bypass); }
    public boolean skip(Edge e){ return !skiplist.contains(e); }
}