/* SingleFunctor.java
 * Bryan Chadwick :: 2007
 * Combined function, that knows what to do... */

package edu.neu.ccs.demeterf.compose;

import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.dispatch.MethodDB;
import edu.neu.ccs.demeterf.util.*;
import java.lang.reflect.Method;

/** Combined Builder/Augmentor that knows what to do/call */
public class Functor{
    /* Builder and Augmentors */
    FC func;
    MethodDB<Method> buildDB;
    MethodDB<Method> augDB;
    
    /** Create a Functor of two seperate function objects */
    public Functor(FC f){
        func = f;
        buildDB = MethodDB.createMethodDB(f.getClass(), FC.augMethodName);
        augDB = MethodDB.createMethodDB(f.getClass(), FC.augMethodName);
    }
    /** Apply the Builder to this list of 'Fields' */    
    public Object applyBuilder(Object o[], boolean prim)
    { return Util.applyFObj(func, o, buildDB, FC.buildMethodName, prim?0:-1); }
    /** Apply the Augmentor the the Argument at this Object */
    public Object applyAugment(Object o[])
    { return Util.applyFObj(func, o, augDB, FC.augMethodName, 1); }
 }
