package edu.neu.ccs.demeterf.batch;

import edu.neu.ccs.demeterf.FC;
import edu.neu.ccs.demeterf.batch.classes.*;
import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.demfgen.ClassGen;
import edu.neu.ccs.demeterf.demfgen.DemFGenMain;
import edu.neu.ccs.demeterf.inline.Inline;
import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.util.Util;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.lib.*;
import edu.neu.ccs.demeterf.inline.SubTyping;
import edu.neu.ccs.demeterf.inline.classes.TypeError;
import edu.neu.ccs.demeterf.demfgen.ClassHier.InhrtPair;
import edu.neu.ccs.demeterf.demfgen.IncludeCDs;

/** Batch Generation of Traversals... a function class */
public class GenBatch extends FC{
    String header = "// ** Batch Generated with DemeterF\n";
    String pack;
    String imports;
    String dir;
    List<CDFile> CDs;
    SubTyping subs;
    List<TypeDef> types;
    List<String> opts;
    
    GenBatch(String p, String imp, String d, List<CDFile> cds,
            SubTyping ss, List<TypeDef> ts, List<String> os){
        pack = p; imports = imp; dir = d;
        CDs = cds; subs = ss; types = ts; opts = os;
    }
    
    static void createTraversals(TRVFile trv, List<String> opts) throws java.io.FileNotFoundException{
        List<CDFile> CDs = DemFGenMain.resolveCDFile(trv.getCdfile());
        SubTyping subs = new SubTyping(CDs);
        List<InhrtPair> inhrt = DemFGenMain.subtypes(CDs);
        List<TypeDef> types = DemFGenMain.removeSyntax(DemFGenMain.flatten(CDs, inhrt));
        
        // Add our imports for generated traversals
        CDs = CDs.pop().push(CDs.top().updateImports(CDs.top().getImports().append(trv.getImports())));
        
        GenBatch func = new GenBatch(""+trv.getPack(), ""+IncludeCDs.allImports(CDs),
                ""+trv.getOutdir(), CDs, subs, types, opts);
        String body = new Traversal(func, Control.bypass(TRVDef.class))
            .traverse(trv.getTravs());
        
        func.writeFactory(body, trv.getFact().toString());
    }
    
    void writeFactory(String body, String name){
        String cls = ("public class "+name+"{\n"+body+"}\n");
        Util.writeFile(name, "."+Diff.d.fileSuffix, cls, dir, header+pack+imports);
    }
    String combine(TRVDef trv, ident name, Impl impl, NEPkgList func, Option<ContextType> ctx, TravControl ctrl, Option<ExtraArgs> extra){
        try{
            // TODO: Better Control... with forward/backward marking
            List<String> args = List.create(
                    makeArgs(Inline.BUILTINS, ctrl.getBuiltins()),
                    makeArgs(Inline.BYPASS, ctrl.getBypass()),
                    makeArgs(Inline.TARG, ctx.isSome()?List.create(ctx.inner().getTarg()):List.create()))
                    .append(extra.isSome()?extra.inner().getArgs():List.<String>create());
            String body = Inline.doGen(""+name, impl, CDs, pack, func.print(), ctrl.getStart().print(),
                    types, subs, opts.append(args));
            Util.writeFile(""+name, "."+Diff.d.fileSuffix, body, dir, header);
            return "    public static "+name+" make"+name+"("+ClassGen.unlocal(func.toString())+" f){ return new "+name+"(f); }\n";
        }catch(TypeError te){
            throw new TypeError("   "+te.getMessage()+
                    "\n   In Generation for Traversal: "+trv.getName()+
                    "\n                 With function: "+trv.getFunc().print());
        }
    }
    static String makeArgs(String opt, List<?> args){
        if(args.isEmpty())return "";
        String ret = opt+":"+args.toString(":", "");
        //System.err.println(" ARGS: "+ret);
        return ret;
    }
    
    String combine(Cons<?> e, String f, String r){ return f+r; }
    String combine(Empty<?> e){ return ""; }
}
