/* Generated By:JavaCC: Do not edit this line. CSJavaCCParser.java */
/**
 * This file contains the code for CSJavaCCParser generated
 * by CSJavaCCParser itself.
 */

package csjavacc.parser;

import java.util.Vector;
import csjavacc.struct.*;

public class CSJavaCCParser extends CSJavaCCParserInternals implements CSJavaCCParserConstants {

  /**
   * The name of the parser class.
   */
  String parser_class_name;

  /**
   * This flag is set to true when the part between PARSER_BEGIN and
   * PARSER_END is being parsed.
   */
  boolean processing_cu = false;

  /**
   * The level of class nesting.
   */
  int class_nesting = 0;

  /**
   * This int variable is incremented while parsing local lookaheads.
   * Hence it keeps track of *syntactic* lookahead nesting.
   * This is used to provide warnings when actions and nested lookaheads
   * are used in syntactic lookahead productions.  This is to prevent
   * typos such as leaving out the comma in LOOKAHEAD( foo(), {check()} ).
   */
  int inLocalLA = 0;

  /**
   * Set to true when the parser is within an action.
   */
  boolean inAction = false;

  /**
   * This flag keeps track of whether or not return and throw
   * statements have been patched during the parsing of a production.
   * The value of this flag is assigned the field with the same
   * name in BNFProduction.java.
   */
  boolean jumpPatched = false;

  /*
   * Returns true if the next token is not in the FOLLOW list of "expansion".
   * It is used to decide when the end of an "expansion" has been reached.
   */
  private boolean notTailOfExpansionUnit() {
    Token t;
    t = getToken(1);
    if (t.kind == BIT_OR || t.kind == COMMA || t.kind == RPAREN || t.kind == RBRACE || t.kind == RBRACKET) return false;
    return true;
  }

   /**
    * Class to hold modifiers.
    */
   static public final class ModifierSet
   {
     /* Definitions of the bits in the modifiers field.  */
     public static final int PUBLIC = 0x0001;
     public static final int PROTECTED = 0x0002;
     public static final int PRIVATE = 0x0004;
     public static final int ABSTRACT = 0x0008;
     public static final int STATIC = 0x0010;
     public static final int OVERRIDE = 0x0020;
     public static final int PARTIAL = 0x0040;
     public static final int NEW = 0x0100;
     public static final int INTERNAL = 0x0080;
     public static final int READONLY = 0x0200;
     public static final int FIXED = 0x0400;
     public static final int UNSAFE = 0x0800;

     public boolean isPublic(int modifiers){ return (modifiers & PUBLIC) != 0; }
     public boolean isProtected(int modifiers){ return (modifiers & PROTECTED) != 0; }
     public boolean isPrivate(int modifiers){ return (modifiers & PRIVATE) != 0; }
     public boolean isStatic(int modifiers){ return (modifiers & STATIC) != 0; }
     public boolean isAbstract(int modifiers){ return (modifiers & ABSTRACT) != 0; }
     public boolean isOverride(int modifiers){ return (modifiers & OVERRIDE) != 0; }

     /** Removes the given modifier. */
     static int removeModifier(int modifiers, int mod){  return modifiers & ~mod; }
   }

/************************************************
 * THE CSJAVACC GRAMMAR SPECIFICATION STARTS HERE *
 ************************************************/
  final public void csjavacc_input() throws ParseException {
          String id1, id2;
          initialize();
    csjavacc_options();
    jj_consume_token(_PARSER_BEGIN);
    jj_consume_token(LPAREN);
    id1 = identifier();
          addcuname(id1);
    jj_consume_token(RPAREN);
          processing_cu = true;
          parser_class_name = id1;
    CompilationUnit();
          processing_cu = false;
    jj_consume_token(_PARSER_END);
    jj_consume_token(LPAREN);
    id2 = identifier();
          compare(getToken(0), id1, id2);
    jj_consume_token(RPAREN);
    label_1:
    while (true) {
      production();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case _CSCODE:
      case _TOKEN:
      case _SPECIAL_TOKEN:
      case _MORE:
      case _SKIP:
      case _TOKEN_MGR_DECLS:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case VOID:
      case LANGLE:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
    }
    jj_consume_token(0);
  }

  final public void csjavacc_options() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case _OPTIONS:
      jj_consume_token(_OPTIONS);
      jj_consume_token(LBRACE);
      label_2:
      while (true) {
        option_binding();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case _LOOKAHEAD:
        case _IGNORE_CASE:
        case STATIC:
        case IDENTIFIER:
          ;
          break;
        default:
          jj_la1[1] = jj_gen;
          break label_2;
        }
      }
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
          Options.normalize();
  }

  final public void option_binding() throws ParseException {
          String option_name;
          int int_val;
          boolean bool_val;
          String string_val;
          Token t = getToken(1);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      break;
    case _LOOKAHEAD:
      jj_consume_token(_LOOKAHEAD);
      break;
    case _IGNORE_CASE:
      jj_consume_token(_IGNORE_CASE);
      break;
    case STATIC:
      jj_consume_token(STATIC);
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          option_name = t.image;
    jj_consume_token(ASSIGN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      int_val = IntegerLiteral();
          Options.setInputFileOption(t, getToken(0), option_name, int_val);
      break;
    case FALSE:
    case TRUE:
      bool_val = BooleanLiteral();
          Options.setInputFileOption(t, getToken(0), option_name, bool_val);
      break;
    case STRING_LITERAL:
      string_val = StringLiteral();
          Options.setInputFileOption(t, getToken(0), option_name, string_val);
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
  }

  final public void production() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case _CSCODE:
      cscode_production();
      break;
    case _TOKEN:
    case _SPECIAL_TOKEN:
    case _MORE:
    case _SKIP:
    case LANGLE:
      regular_expr_production();
      break;
    case _TOKEN_MGR_DECLS:
      token_manager_decls();
      break;
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case SHORT:
    case VOID:
    case IDENTIFIER:
      bnf_production();
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void cscode_production() throws ParseException {
          String lhs;
          CSCodeProduction p = new CSCodeProduction();
          Token t = p.firstToken = getToken(1);
          java.util.Vector excName;
          p.throws_list = new java.util.Vector();
          p.line = t.beginLine;
          p.column = t.beginColumn;
    jj_consume_token(_CSCODE);
    AccessModifier(p);
    ResultType(p.return_type_tokens);
    p.lhs = identifier();
    FormalParameters(p.parameter_list_tokens);
    Block(p.code_tokens);
          p.lastToken = getToken(0);
          addproduction(p);
  }

  final public void bnf_production() throws ParseException {
          String lhs;
          BNFProduction p = new BNFProduction();
          Container c = new Container();
          Token t = p.firstToken = getToken(1);
          java.util.Vector excName;
          p.throws_list = new java.util.Vector();
          p.line = t.beginLine;
          p.column = t.beginColumn;
          jumpPatched = false;
    AccessModifier(p);
    ResultType(p.return_type_tokens);
    p.lhs = identifier();
    FormalParameters(p.parameter_list_tokens);
    jj_consume_token(COLON);
    Block(p.declaration_tokens);
    jj_consume_token(LBRACE);
    expansion_choices(c);
    t = jj_consume_token(RBRACE);
          p.lastToken = t;
          p.jumpPatched = jumpPatched;
          production_addexpansion(p, (Expansion)(c.member));
          addproduction(p);
  }

  final public void AccessModifier(NormalProduction p) throws ParseException {
          Token t = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
        t = jj_consume_token(PUBLIC);
        break;
      case PROTECTED:
        t = jj_consume_token(PROTECTED);
        break;
      case PRIVATE:
        t = jj_consume_token(PRIVATE);
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
          if(t != null){
            p.accessMod = t.image;
          }
  }

  final public void regular_expr_production() throws ParseException {
          TokenProduction p = new TokenProduction();
          java.util.Vector states;
          Token t = p.firstToken = getToken(1);
          p.line = t.beginLine;
          p.column = t.beginColumn;
          // set p.lexStates assuming there is no state spec.
          // and then override if necessary.
          p.lexStates = new String[1];
          p.lexStates[0] = "DEFAULT";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LANGLE:
      if (jj_2_1(2)) {
        jj_consume_token(LANGLE);
        jj_consume_token(STAR);
        jj_consume_token(RANGLE);
          p.lexStates = null;
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LANGLE:
          jj_consume_token(LANGLE);
          states = new java.util.Vector();
          t = jj_consume_token(IDENTIFIER);
          states.addElement(t.image);
          label_3:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[8] = jj_gen;
              break label_3;
            }
            jj_consume_token(COMMA);
            t = jj_consume_token(IDENTIFIER);
          states.addElement(t.image);
          }
          jj_consume_token(RANGLE);
          p.lexStates = new String[states.size()];
          for (int i = 0; i < states.size(); i++) {
            p.lexStates[i] = (String)states.elementAt(i);
          }
          break;
        default:
          jj_la1[9] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[10] = jj_gen;
      ;
    }
    regexpr_kind(p);
          if (p.kind != TokenProduction.TOKEN && Options.getUserTokenManager()) {
            CSJavaCCErrors.warning(getToken(0), "Regular expression is being treated as if it were a TOKEN since option USER_TOKEN_MANAGER has been set to true.");
          }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      jj_consume_token(LBRACKET);
      t = jj_consume_token(_IGNORE_CASE);
      jj_consume_token(RBRACKET);
          p.ignoreCase = true;
          if (Options.getUserTokenManager()) {
            CSJavaCCErrors.warning(t, "Ignoring \u005c"IGNORE_CASE\u005c" specification since option USER_TOKEN_MANAGER has been set to true.");
          }
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    jj_consume_token(COLON);
    jj_consume_token(LBRACE);
    regexpr_spec(p);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_OR:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_4;
      }
      jj_consume_token(BIT_OR);
      regexpr_spec(p);
    }
    t = jj_consume_token(RBRACE);
          p.lastToken = t;
          addregexpr(p);
  }

  final public void token_manager_decls() throws ParseException {
          java.util.Vector decls = new java.util.Vector();
          Token t;
    t = jj_consume_token(_TOKEN_MGR_DECLS);
    jj_consume_token(COLON);
    ClassOrInterfaceBody(false, decls);
          add_token_manager_decls(t, decls);
  }

  final public void regexpr_kind(TokenProduction p) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case _TOKEN:
      jj_consume_token(_TOKEN);
          p.kind = TokenProduction.TOKEN;
      break;
    case _SPECIAL_TOKEN:
      jj_consume_token(_SPECIAL_TOKEN);
          p.kind = TokenProduction.SPECIAL;
      break;
    case _SKIP:
      jj_consume_token(_SKIP);
          p.kind = TokenProduction.SKIP;
      break;
    case _MORE:
      jj_consume_token(_MORE);
          p.kind = TokenProduction.MORE;
      break;
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void regexpr_spec(TokenProduction p) throws ParseException {
          Container c = new Container();
          Action act = new Action();
          Token t = null;
          RegExprSpec res = new RegExprSpec();
    regular_expression(c);
          res.rexp = (RegularExpression)c.member;
          res.rexp.tpContext = p;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
          t = getToken(1);
      Block(act.action_tokens);
          if (Options.getUserTokenManager()) {
            CSJavaCCErrors.warning(t, "Ignoring action in regular expression specification since option USER_TOKEN_MANAGER has been set to true.");
          }
          if (res.rexp.private_rexp) {
            CSJavaCCErrors.parse_error(t, "Actions are not permitted on private (#) regular expressions.");
          }
      break;
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      jj_consume_token(COLON);
      t = jj_consume_token(IDENTIFIER);
          res.nextState = t.image;
          if (res.rexp.private_rexp) {
            CSJavaCCErrors.parse_error(t, "Lexical state changes are not permitted after private (#) regular expressions.");
          }
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
          res.act = act;
          res.nsTok = t;
          p.respecs.addElement(res);
  }

  final public void expansion_choices(Container c1) throws ParseException {
          boolean morethanone = false;
          Choice ch = null;
          Container c2 = new Container();
    expansion(c1);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_OR:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_5;
      }
      jj_consume_token(BIT_OR);
      expansion(c2);
          if (morethanone) {
            ch.choices.addElement(c2.member);
            ((Expansion)c2.member).parent = ch;
          } else {
            morethanone = true;
            ch = new Choice();
            ch.line = ((Expansion)c1.member).line;
            ch.column = ((Expansion)c1.member).column;
            ch.choices.addElement(c1.member);
            ((Expansion)c1.member).parent = ch;
            ch.choices.addElement(c2.member);
            ((Expansion)c2.member).parent = ch;
          }
    }
          if (morethanone) {
            c1.member = ch;
          }
  }

  final public void expansion(Container c1) throws ParseException {
          Sequence seq = new Sequence();
          Container c2 = new Container();
          Lookahead la = new Lookahead();
          Token t = getToken(1);
          seq.line = t.beginLine;
          seq.column = t.beginColumn;
          la.line = t.beginLine;
          la.column = t.beginColumn;
          la.amount = Options.getLookahead();
          la.la_expansion = null;
          la.isExplicit = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case _LOOKAHEAD:
      t = jj_consume_token(_LOOKAHEAD);
      jj_consume_token(LPAREN);
      la = local_lookahead();
      jj_consume_token(RPAREN);
          if (inLocalLA != 0 && la.amount != 0) {
            CSJavaCCErrors.warning(t, "Only semantic lookahead specifications within other lookahead specifications is considered.  Syntactic lookahead is ignored.");
          }
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
          seq.units.addElement(la);
    label_6:
    while (true) {
      expansion_unit(c2);
          seq.units.addElement(c2.member);
          ((Expansion)c2.member).parent = seq;
          ((Expansion)c2.member).ordinal = seq.units.size()-1;
      if (notTailOfExpansionUnit()) {
        ;
      } else {
        break label_6;
      }
    }
          if (la.la_expansion == null) {
            la.la_expansion = seq;
          }
          c1.member = seq;
  }

  final public Lookahead local_lookahead() throws ParseException {
          Lookahead la = new Lookahead();
          la.isExplicit = true;
          Token t = getToken(1);
          la.line = t.beginLine;
          la.column = t.beginColumn;
          la.la_expansion = null;
          Container c = new Container();
          boolean commaAtEnd = false, emptyLA = true;
          inLocalLA++;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      la.amount = IntegerLiteral();
          emptyLA = false;
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    if (!emptyLA && (getToken(1).kind != RPAREN)) {
      jj_consume_token(COMMA);
          commaAtEnd = true;
    } else {
      ;
    }
    if (getToken(1).kind != RPAREN && getToken(1).kind != LBRACE) {
      expansion_choices(c);
          emptyLA = false; commaAtEnd = false;
          la.la_expansion = (Expansion)c.member;
    } else {
      ;
    }
    if (!emptyLA && !commaAtEnd && (getToken(1).kind != RPAREN)) {
      jj_consume_token(COMMA);
          commaAtEnd = true;
    } else {
      ;
    }
    if (emptyLA || commaAtEnd) {
      jj_consume_token(LBRACE);
      Expression(la.action_tokens);
      jj_consume_token(RBRACE);
          if (emptyLA) {
            la.amount = 0;
          }
    } else {
      ;
    }
          inLocalLA--;
          {if (true) return la;}
    throw new Error("Missing return statement in function");
  }

  final public void expansion_unit(Container c) throws ParseException {
          String name;
          java.util.Vector lhsTokens = new java.util.Vector();
          NonTerminal nt;
          Action act;
          Token t;
          Lookahead la;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case _LOOKAHEAD:
      /*
         * We give this priority over primary expressions which use LOOKAHEAD as the
         * name of its identifier.
         */
        t = jj_consume_token(_LOOKAHEAD);
      jj_consume_token(LPAREN);
      la = local_lookahead();
      jj_consume_token(RPAREN);
          // Now set the la_expansion field of la with a dummy
          // expansion (we use EOF).
          la.la_expansion = new REndOfFile();
          // Create a singleton choice with an empty action.
          Choice ch = new Choice();
          ch.line = t.beginLine; ch.column = t.beginColumn;
          Sequence seq = new Sequence();
          seq.line = t.beginLine; seq.column = t.beginColumn;
          seq.units.addElement(la);
          la.parent = seq; la.ordinal = 0;
          act = new Action();
          act.line = t.beginLine; act.column = t.beginColumn;
          seq.units.addElement(act);
          act.parent = seq; act.ordinal = 1;
          ch.choices.addElement(seq);
          seq.parent = ch; seq.ordinal = 0;
          if (la.amount != 0) {
            if (la.action_tokens.size() != 0) {
              CSJavaCCErrors.warning(t, "Encountered LOOKAHEAD(...) at a non-choice location.  Only semantic lookahead will be considered here.");
            } else {
              CSJavaCCErrors.warning(t, "Encountered LOOKAHEAD(...) at a non-choice location.  This will be ignored.");
            }
          }
          c.member = ch;
      break;
    case LBRACE:
          act = new Action();
          t = getToken(1);
          act.line = t.beginLine;
          act.column = t.beginColumn;
          inAction = true;
      Block(act.action_tokens);
          inAction = false;
          if (inLocalLA != 0) {
            CSJavaCCErrors.warning(t, "Action within lookahead specification will be ignored.");
          }
          c.member = act;
      break;
    case LBRACKET:
      t = jj_consume_token(LBRACKET);
      expansion_choices(c);
      jj_consume_token(RBRACKET);
          ZeroOrOne exp = new ZeroOrOne();
          exp.line = t.beginLine;
          exp.column = t.beginColumn;
          exp.expansion = (Expansion)c.member;
          ((Expansion)c.member).parent = exp;
          c.member = exp;
      break;
    case TRY:
          Container expch = new Container();
          java.util.Vector types = new java.util.Vector();
          java.util.Vector ids = new java.util.Vector();
          java.util.Vector catchblks = new java.util.Vector();
          java.util.Vector finallyblk = null;
          java.util.Vector vec = new java.util.Vector();
          Token t0;
      t0 = jj_consume_token(TRY);
      jj_consume_token(LBRACE);
      expansion_choices(expch);
      jj_consume_token(RBRACE);
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CATCH:
          ;
          break;
        default:
          jj_la1[19] = jj_gen;
          break label_7;
        }
        jj_consume_token(CATCH);
        jj_consume_token(LPAREN);
        Name(vec);
        t = jj_consume_token(IDENTIFIER);
        jj_consume_token(RPAREN);
          types.addElement(vec);
          ids.addElement(t);
          vec = new java.util.Vector();
          inAction = true;
        Block(vec);
          inAction = false;
          catchblks.addElement(vec);
          vec = new java.util.Vector();
      }
          makeTryBlock(t0, c, expch, types, ids, catchblks, finallyblk);
      break;
    default:
      jj_la1[24] = jj_gen;
      if (jj_2_4(2147483647)) {
        if (jj_2_2(2147483647)) {
          Token first = getToken(1);
          PrimaryExpression();
          Token last = getToken(0);
          jj_consume_token(ASSIGN);
          t = first;
          while (true) {
            lhsTokens.addElement(t);
            if (t == last) break;
            t = t.next;
          }
        } else {
          ;
        }
        if (jj_2_3(2147483647)) {
          nt = new NonTerminal();
          t = getToken(1);
          nt.line = t.beginLine;
          nt.column = t.beginColumn;
          nt.lhsTokens = lhsTokens;
          name = identifier();
          Arguments(nt.argument_tokens);
          nt.name = name;
          c.member = nt;
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case STRING_LITERAL:
          case LANGLE:
            regular_expression(c);
          ((RegularExpression)(c.member)).lhsTokens = lhsTokens;
          add_inline_regexpr((RegularExpression)(c.member));
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case DOT:
              jj_consume_token(DOT);
              t = jj_consume_token(IDENTIFIER);
                               ((RegularExpression)(c.member)).rhsToken = t;
              break;
            default:
              jj_la1[20] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[21] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
          t = jj_consume_token(LPAREN);
          expansion_choices(c);
          jj_consume_token(RPAREN);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case HOOK:
          case PLUS:
          case STAR:
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case PLUS:
              jj_consume_token(PLUS);
          OneOrMore omexp = new OneOrMore();
          omexp.line = t.beginLine;
          omexp.column = t.beginColumn;
          omexp.expansion = (Expansion)c.member;
          ((Expansion)c.member).parent = omexp;
          c.member = omexp;
              break;
            case STAR:
              jj_consume_token(STAR);
          ZeroOrMore zmexp = new ZeroOrMore();
          zmexp.line = t.beginLine;
          zmexp.column = t.beginColumn;
          zmexp.expansion = (Expansion)c.member;
          ((Expansion)c.member).parent = zmexp;
          c.member = zmexp;
              break;
            case HOOK:
              jj_consume_token(HOOK);
          ZeroOrOne zoexp = new ZeroOrOne();
          zoexp.line = t.beginLine;
          zoexp.column = t.beginColumn;
          zoexp.expansion = (Expansion)c.member;
          ((Expansion)c.member).parent = zoexp;
          c.member = zoexp;
              break;
            default:
              jj_la1[22] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
          default:
            jj_la1[23] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[25] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void regular_expression(Container c) throws ParseException {
          RStringLiteral strlit;
          REndOfFile ef;
          RJustName jn;
          String image;
          boolean private_rexp = false;
          Token t = getToken(1);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      image = StringLiteral();
          strlit = new RStringLiteral();
          strlit.line = t.beginLine;
          strlit.column = t.beginColumn;
          strlit.image = image;
          c.member = strlit;
      break;
    default:
      jj_la1[28] = jj_gen;
      if (jj_2_5(3)) {
          image = "";
        jj_consume_token(LANGLE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 131:
        case IDENTIFIER:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case 131:
            jj_consume_token(131);
          private_rexp = true;
            break;
          default:
            jj_la1[26] = jj_gen;
            ;
          }
          image = identifier();
          jj_consume_token(COLON);
          break;
        default:
          jj_la1[27] = jj_gen;
          ;
        }
        complex_regular_expression_choices(c);
        jj_consume_token(RANGLE);
          RegularExpression re;
          if (c.member instanceof RJustName) {
            RSequence seq = new RSequence();
            seq.units.addElement(c.member);
            re = seq;
          } else {
            re = (RegularExpression)c.member;
          }
          re.label = image;
          re.private_rexp = private_rexp;
          re.line = t.beginLine;
          re.column = t.beginColumn;
          c.member = re;
      } else if (jj_2_6(2)) {
        jj_consume_token(LANGLE);
        image = identifier();
        jj_consume_token(RANGLE);
          jn = new RJustName();
          jn.line = t.beginLine;
          jn.column = t.beginColumn;
          jn.label = image;
          c.member = jn;
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LANGLE:
          jj_consume_token(LANGLE);
          jj_consume_token(_EOF);
          jj_consume_token(RANGLE);
          ef = new REndOfFile();
          ef.line = t.beginLine;
          ef.column = t.beginColumn;
          ef.ordinal = 0;
          c.member = ef;
          break;
        default:
          jj_la1[29] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void complex_regular_expression_choices(Container c1) throws ParseException {
          boolean morethanone = false;
          RChoice ch = null;
          Container c2 = new Container();
    complex_regular_expression(c1);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_OR:
        ;
        break;
      default:
        jj_la1[30] = jj_gen;
        break label_8;
      }
      jj_consume_token(BIT_OR);
      complex_regular_expression(c2);
          if (morethanone) {
            ch.choices.addElement(c2.member);
          } else {
            morethanone = true;
            ch = new RChoice();
            ch.line = ((RegularExpression)c1.member).line;
            ch.column = ((RegularExpression)c1.member).column;
            ch.choices.addElement(c1.member);
            ch.choices.addElement(c2.member);
          }
    }
          if (morethanone) {
            c1.member = ch;
          }
  }

  final public void complex_regular_expression(Container c1) throws ParseException {
          int count = 0;
          RSequence seq = null;
          Container c2 = new Container();
    label_9:
    while (true) {
      complex_regular_expression_unit(c2);
          count++;
          if (count == 1) {
            c1.member = c2.member; // if count does not go beyond 1, we are done.
          } else if (count == 2) { // more than 1, so create a sequence.
            seq = new RSequence();
            seq.line = ((RegularExpression)c1.member).line;
            seq.column = ((RegularExpression)c1.member).column;
            seq.units.addElement(c1.member);
            seq.units.addElement(c2.member);
          } else {
            seq.units.addElement(c2.member);
          }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
      case LPAREN:
      case LBRACKET:
      case LANGLE:
      case TILDE:
        ;
        break;
      default:
        jj_la1[31] = jj_gen;
        break label_9;
      }
    }
          if (count > 1) {
            c1.member = seq;
          }
  }

  final public void complex_regular_expression_unit(Container c) throws ParseException {
          String image;
          RStringLiteral strlit;
          RJustName jn;
          Token t = getToken(1);
          int r1 = 0, r2 = -1;
          boolean hasMax = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      image = StringLiteral();
          strlit = new RStringLiteral();
          strlit.line = t.beginLine;
          strlit.column = t.beginColumn;
          strlit.image = image;
          c.member = strlit;
      break;
    case LANGLE:
      jj_consume_token(LANGLE);
      image = identifier();
      jj_consume_token(RANGLE);
          jn = new RJustName();
          jn.line = t.beginLine;
          jn.column = t.beginColumn;
          jn.label = image;
          c.member = jn;
      break;
    case LBRACKET:
    case TILDE:
      character_list(c);
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      complex_regular_expression_choices(c);
      jj_consume_token(RPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
      case HOOK:
      case PLUS:
      case STAR:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
          jj_consume_token(PLUS);
          ROneOrMore omrexp = new ROneOrMore();
          omrexp.line = t.beginLine;
          omrexp.column = t.beginColumn;
          omrexp.regexpr = (RegularExpression)c.member;
          c.member = omrexp;
          break;
        case STAR:
          jj_consume_token(STAR);
          RZeroOrMore zmrexp = new RZeroOrMore();
          zmrexp.line = t.beginLine;
          zmrexp.column = t.beginColumn;
          zmrexp.regexpr = (RegularExpression)c.member;
          c.member = zmrexp;
          break;
        case HOOK:
          jj_consume_token(HOOK);
          RZeroOrOne zorexp = new RZeroOrOne();
          zorexp.line = t.beginLine;
          zorexp.column = t.beginColumn;
          zorexp.regexpr = (RegularExpression)c.member;
          c.member = zorexp;
          break;
        case LBRACE:
          jj_consume_token(LBRACE);
          r1 = IntegerLiteral();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            jj_consume_token(COMMA);
                 hasMax = true;
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case INTEGER_LITERAL:
              r2 = IntegerLiteral();
              break;
            default:
              jj_la1[32] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[33] = jj_gen;
            ;
          }
          jj_consume_token(RBRACE);
          RRepetitionRange rrrexp = new RRepetitionRange();
          rrrexp.line = t.beginLine;
          rrrexp.column = t.beginColumn;
          rrrexp.min = r1;
          rrrexp.max = r2;
        rrrexp.hasMax = hasMax;
          rrrexp.regexpr = (RegularExpression)c.member;
          c.member = rrrexp;
          break;
        default:
          jj_la1[34] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[35] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void character_list(Container c1) throws ParseException {
          RCharacterList chlist = new RCharacterList();
          Token t = getToken(1);
          chlist.line = t.beginLine;
          chlist.column = t.beginColumn;
          Container c2 = new Container();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TILDE:
      jj_consume_token(TILDE);
          chlist.negated_list = true;
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      character_descriptor(c2);
          chlist.descriptors.addElement(c2.member);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[38] = jj_gen;
          break label_10;
        }
        jj_consume_token(COMMA);
        character_descriptor(c2);
          chlist.descriptors.addElement(c2.member);
      }
      break;
    default:
      jj_la1[39] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
          c1.member = chlist;
  }

  final public void character_descriptor(Container c) throws ParseException {
          char c1, c2 = ' ';
          boolean isrange = false;
          String imageL, imageR;
          Token t = getToken(1);
    imageL = StringLiteral();
          c1 = character_descriptor_assign(getToken(0), imageL);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      jj_consume_token(MINUS);
      imageR = StringLiteral();
          isrange = true;
          c2 = character_descriptor_assign(getToken(0), imageR, imageL);
      break;
    default:
      jj_la1[40] = jj_gen;
      ;
    }
          if (isrange) {
            CharacterRange cr = new CharacterRange();
            cr.line = t.beginLine;
            cr.column = t.beginColumn;
            cr.left = c1;
            cr.right = c2;
            c.member = cr;
          } else {
            SingleCharacter sc = new SingleCharacter();
            sc.line = t.beginLine;
            sc.column = t.beginColumn;
            sc.ch = c1;
            c.member = sc;
          }
  }

  final public String identifier() throws ParseException {
          Token t;
    t = jj_consume_token(IDENTIFIER);
          {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

/**********************************************
 * THE C# GRAMMAR SPECIFICATION STARTS HERE *
 **********************************************/

/*
 * The C# grammar is modified to use sequences of tokens
 * for the missing tokens - those that include "<<" and ">>".
 */

/*
 * The following production defines C# identifiers - it
 * includes the reserved words of CSJavaCC also.
 */
  final public Token CSIdentifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      break;
    case _OPTIONS:
      jj_consume_token(_OPTIONS);
      break;
    case _LOOKAHEAD:
      jj_consume_token(_LOOKAHEAD);
      break;
    case _IGNORE_CASE:
      jj_consume_token(_IGNORE_CASE);
      break;
    case _PARSER_BEGIN:
      jj_consume_token(_PARSER_BEGIN);
      break;
    case _PARSER_END:
      jj_consume_token(_PARSER_END);
      break;
    case _CSCODE:
      jj_consume_token(_CSCODE);
      break;
    case _TOKEN:
      jj_consume_token(_TOKEN);
      break;
    case _SPECIAL_TOKEN:
      jj_consume_token(_SPECIAL_TOKEN);
      break;
    case _MORE:
      jj_consume_token(_MORE);
      break;
    case _SKIP:
      jj_consume_token(_SKIP);
      break;
    case _TOKEN_MGR_DECLS:
      jj_consume_token(_TOKEN_MGR_DECLS);
      break;
    case _EOF:
      jj_consume_token(_EOF);
      break;
    default:
      jj_la1[41] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          Token retval = getToken(0);
          retval.kind = IDENTIFIER;
          {if (true) return retval;}
    throw new Error("Missing return statement in function");
  }

/*
 * The productions for the missing code follows.  Obviously
 * these productions accept more than what is legal in Java,
 * but that is OK for our purposes.
 */
  final public void ShiftOps() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LANGLE:
      jj_consume_token(LANGLE);
      jj_consume_token(LANGLE);
      break;
    case RANGLE:
      jj_consume_token(RANGLE);
      jj_consume_token(RANGLE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RANGLE:
        jj_consume_token(RANGLE);
        break;
      default:
        jj_la1[42] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void OtherAssignmentOps() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LANGLE:
      jj_consume_token(LANGLE);
      jj_consume_token(LE);
      break;
    case RANGLE:
      jj_consume_token(RANGLE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RANGLE:
        jj_consume_token(RANGLE);
        break;
      default:
        jj_la1[44] = jj_gen;
        ;
      }
      jj_consume_token(GE);
      break;
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * Program structuring syntax follows.
 */
  final public void CompilationUnit() throws ParseException {
          set_initial_cu_token(getToken(1));
          System.out.println(getToken(1).image);
    if (jj_2_7(2147483647)) {
      NamespaceDeclaration();
    } else {
      ;
    }
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPORT:
        ;
        break;
      default:
        jj_la1[46] = jj_gen;
        break label_11;
      }
      ImportDeclaration();
    }
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case CLASS:
      case OVERRIDE:
      case INTERFACE:
      case NEW:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
      case PARTIAL:
      case INTERNAL:
      case READONLY:
      case FIXED:
      case UNSAFE:
      case SEMICOLON:
        ;
        break;
      default:
        jj_la1[47] = jj_gen;
        break label_12;
      }
      TypeDeclaration();
    }
          insertionpointerrors(getToken(1));
  }

  final public void NamespaceDeclaration() throws ParseException {
    Modifiers();
    jj_consume_token(NAMESPACE);
    Name(new Vector());
    jj_consume_token(SEMICOLON);
  }

  final public void ImportDeclaration() throws ParseException {
    jj_consume_token(IMPORT);
    if (jj_2_8(2147483647)) {
      NameType(new java.util.Vector());
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case _OPTIONS:
      case _LOOKAHEAD:
      case _IGNORE_CASE:
      case _PARSER_BEGIN:
      case _PARSER_END:
      case _CSCODE:
      case _TOKEN:
      case _SPECIAL_TOKEN:
      case _MORE:
      case _SKIP:
      case _TOKEN_MGR_DECLS:
      case _EOF:
      case IDENTIFIER:
        Name(new java.util.Vector());
        break;
      default:
        jj_la1[48] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(SEMICOLON);
  }

/*
 * Modifiers. We match all modifiers in a single rule to reduce the chances of
 * syntax errors for simple modifier mistakes. It will also enable us to give
 * better error messages.
 */
  final public int Modifiers() throws ParseException {
   int modifiers = 0;
    label_13:
    while (true) {
      if (jj_2_9(2)) {
        ;
      } else {
        break label_13;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
        jj_consume_token(PUBLIC);
               modifiers |= ModifierSet.PUBLIC;
        break;
      case STATIC:
        jj_consume_token(STATIC);
               modifiers |= ModifierSet.STATIC;
        break;
      case PROTECTED:
        jj_consume_token(PROTECTED);
                  modifiers |= ModifierSet.PROTECTED;
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
                modifiers |= ModifierSet.PRIVATE;
        break;
      case OVERRIDE:
        jj_consume_token(OVERRIDE);
                 modifiers |= ModifierSet.OVERRIDE;
        break;
      case PARTIAL:
        jj_consume_token(PARTIAL);
                modifiers |= ModifierSet.PARTIAL;
        break;
      case ABSTRACT:
        jj_consume_token(ABSTRACT);
                 modifiers |= ModifierSet.ABSTRACT;
        break;
      case NEW:
        jj_consume_token(NEW);
            modifiers |= ModifierSet.NEW;
        break;
      case INTERNAL:
        jj_consume_token(INTERNAL);
                 modifiers |= ModifierSet.INTERNAL;
        break;
      case READONLY:
        jj_consume_token(READONLY);
                 modifiers |= ModifierSet.READONLY;
        break;
      case FIXED:
        jj_consume_token(FIXED);
              modifiers |= ModifierSet.FIXED;
        break;
      case UNSAFE:
        jj_consume_token(UNSAFE);
               modifiers |= ModifierSet.UNSAFE;
        break;
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return modifiers;}
    throw new Error("Missing return statement in function");
  }

/*
 * Declaration syntax follows.
 */
  final public void TypeDeclaration() throws ParseException {
   int modifiers;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    case ABSTRACT:
    case CLASS:
    case OVERRIDE:
    case INTERFACE:
    case NEW:
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case STATIC:
    case PARTIAL:
    case INTERNAL:
    case READONLY:
    case FIXED:
    case UNSAFE:
      modifiers = Modifiers();
      ClassOrInterfaceDeclaration(modifiers, new Vector());
      break;
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ClassOrInterfaceDeclaration(int modifiers, Vector tokens) throws ParseException {
   boolean isInterface = false;
          class_nesting++;
          Token t;
          boolean is_parser_class = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLASS:
      jj_consume_token(CLASS);
      break;
    case INTERFACE:
      jj_consume_token(INTERFACE);
                            isInterface = true;
      break;
    default:
      jj_la1[51] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LANGLE:
      TypeParameters();
      break;
    default:
      jj_la1[52] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      ExtendsList(isInterface);
      break;
    default:
      jj_la1[53] = jj_gen;
      ;
    }
          if (t.image.equals(parser_class_name) && class_nesting == 1 && processing_cu) {
            is_parser_class = true;
            setinsertionpoint(getToken(1), 1);
          }
    ClassOrInterfaceBody(isInterface, new Vector());
          if (is_parser_class) {
            setinsertionpoint(getToken(0), 2);
          }
          class_nesting--;
  }

  final public void DelegateDeclaration(int modifiers) throws ParseException {
    jj_consume_token(DELEGATE);
    ResultType(new Vector());
    jj_consume_token(IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LANGLE:
      TypeParameters();
      break;
    default:
      jj_la1[54] = jj_gen;
      ;
    }
    FormalParameters(new Vector());
    jj_consume_token(SEMICOLON);
  }

  final public void ExtendsList(boolean isInterface) throws ParseException {
   boolean extendsMoreThanOne = false;
    jj_consume_token(COLON);
    ClassOrInterfaceType();
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[55] = jj_gen;
        break label_14;
      }
      jj_consume_token(COMMA);
      ClassOrInterfaceType();
    }
  }

  final public void TypeParameters() throws ParseException {
    jj_consume_token(LANGLE);
    TypeParameter();
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[56] = jj_gen;
        break label_15;
      }
      jj_consume_token(COMMA);
      TypeParameter();
    }
    jj_consume_token(RANGLE);
  }

  final public void TypeParameter() throws ParseException {
    jj_consume_token(IDENTIFIER);
  }

  final public void ClassOrInterfaceBody(boolean isInterface, Vector tokens) throws ParseException {
          Token first, last;
    jj_consume_token(LBRACE);
          first = getToken(1);
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case DOUBLE:
      case OVERRIDE:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NEW:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case VOID:
      case PARTIAL:
      case INTERNAL:
      case DELEGATE:
      case READONLY:
      case FIXED:
      case UNSAFE:
      case SEMICOLON:
      case LANGLE:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[57] = jj_gen;
        break label_16;
      }
      ClassOrInterfaceBodyDeclaration(isInterface);
    }
          last = getToken(0);
    jj_consume_token(RBRACE);
          if (last.next != first) { // i.e., this is not an empty sequence
            Token t = first;
            while (true) {
              tokens.addElement(t);
              if (t == last) break;
              t = t.next;
            }
          }
  }

  final public void ClassOrInterfaceBodyDeclaration(boolean isInterface) throws ParseException {
   boolean isNestedInterface = false;
   int modifiers;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSTRACT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case CLASS:
    case DOUBLE:
    case OVERRIDE:
    case FLOAT:
    case INT:
    case INTERFACE:
    case LONG:
    case NEW:
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case SHORT:
    case STATIC:
    case VOID:
    case PARTIAL:
    case INTERNAL:
    case DELEGATE:
    case READONLY:
    case FIXED:
    case UNSAFE:
    case LANGLE:
    case IDENTIFIER:
      modifiers = Modifiers();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CLASS:
      case INTERFACE:
        ClassOrInterfaceDeclaration(modifiers, new Vector());
        break;
      case DELEGATE:
        DelegateDeclaration(modifiers);
        break;
      default:
        jj_la1[58] = jj_gen;
        if (jj_2_10(2147483647)) {
          ConstructorDeclaration();
        } else if (jj_2_11(2147483647)) {
          FieldDeclaration(modifiers);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BOOLEAN:
          case BYTE:
          case CHAR:
          case DOUBLE:
          case FLOAT:
          case INT:
          case LONG:
          case SHORT:
          case VOID:
          case IDENTIFIER:
            MethodDeclaration(modifiers);
            break;
          default:
            jj_la1[59] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
      break;
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[60] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void FieldDeclaration(int modifiers) throws ParseException {
    Type();
    VariableDeclaratorId();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
    case COMMA:
    case ASSIGN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGN:
        jj_consume_token(ASSIGN);
        VariableInitializer();
        break;
      default:
        jj_la1[61] = jj_gen;
        ;
      }
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[62] = jj_gen;
          break label_17;
        }
        jj_consume_token(COMMA);
        VariableDeclarator();
      }
      jj_consume_token(SEMICOLON);
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      PropertyBody();
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[63] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void VariableDeclarator() throws ParseException {
    VariableDeclaratorId();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGN:
      jj_consume_token(ASSIGN);
      VariableInitializer();
      break;
    default:
      jj_la1[64] = jj_gen;
      ;
    }
  }

  final public void PropertyBody() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 132:
      jj_consume_token(132);
      Statement();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 133:
        jj_consume_token(133);
        Statement();
        break;
      default:
        jj_la1[65] = jj_gen;
        ;
      }
      break;
    case 133:
      jj_consume_token(133);
      Statement();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 132:
        jj_consume_token(132);
        Statement();
        break;
      default:
        jj_la1[66] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void VariableDeclaratorId() throws ParseException {
    jj_consume_token(IDENTIFIER);
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        ;
        break;
      default:
        jj_la1[68] = jj_gen;
        break label_18;
      }
      jj_consume_token(DOT);
      jj_consume_token(IDENTIFIER);
    }
  }

  final public void VariableInitializer() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      ArrayInitializer();
      break;
    case _OPTIONS:
    case _LOOKAHEAD:
    case _IGNORE_CASE:
    case _PARSER_BEGIN:
    case _PARSER_END:
    case _CSCODE:
    case _TOKEN:
    case _SPECIAL_TOKEN:
    case _MORE:
    case _SKIP:
    case _TOKEN_MGR_DECLS:
    case _EOF:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case BASE:
    case THIS:
    case TRUE:
    case VOID:
    case DELEGATE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case LPAREN:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:
    case IDENTIFIER:
      Expression(new Vector());
      break;
    default:
      jj_la1[69] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ArrayInitializer() throws ParseException {
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case _OPTIONS:
    case _LOOKAHEAD:
    case _IGNORE_CASE:
    case _PARSER_BEGIN:
    case _PARSER_END:
    case _CSCODE:
    case _TOKEN:
    case _SPECIAL_TOKEN:
    case _MORE:
    case _SKIP:
    case _TOKEN_MGR_DECLS:
    case _EOF:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case BASE:
    case THIS:
    case TRUE:
    case VOID:
    case DELEGATE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case LPAREN:
    case LBRACE:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:
    case IDENTIFIER:
      VariableInitializer();
      label_19:
      while (true) {
        if (jj_2_12(2)) {
          ;
        } else {
          break label_19;
        }
        jj_consume_token(COMMA);
        VariableInitializer();
      }
      break;
    default:
      jj_la1[70] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      break;
    default:
      jj_la1[71] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
  }

  final public void MethodDeclaration(int modifiers) throws ParseException {
    ResultType(new Vector());
    MethodDeclarator();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      Block(new Vector());
      break;
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[72] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void MethodDeclarator() throws ParseException {
    jj_consume_token(IDENTIFIER);
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        ;
        break;
      default:
        jj_la1[73] = jj_gen;
        break label_20;
      }
      jj_consume_token(DOT);
      jj_consume_token(IDENTIFIER);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LANGLE:
      TypeParameters();
      break;
    default:
      jj_la1[74] = jj_gen;
      ;
    }
    FormalParameters(new Vector());
  }

  final public void FormalParameters(Vector tokens) throws ParseException {
          Token first, last;
    jj_consume_token(LPAREN);
          first = getToken(1);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSTRACT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case OVERRIDE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case SHORT:
    case STATIC:
    case PARTIAL:
    case INTERNAL:
    case READONLY:
    case FIXED:
    case UNSAFE:
    case IDENTIFIER:
      FormalParameter();
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[75] = jj_gen;
          break label_21;
        }
        jj_consume_token(COMMA);
        FormalParameter();
      }
      break;
    default:
      jj_la1[76] = jj_gen;
      ;
    }
          last = getToken(0);
    jj_consume_token(RPAREN);
          if (last.next != first) { // i.e., this is not an empty sequence
            Token t = first;
            while (true) {
              tokens.addElement(t);
              if (t == last) break;
              t = t.next;
            }
          }
  }

  final public void FormalParameter() throws ParseException {
    Modifiers();
    Type();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 134:
      jj_consume_token(134);
      break;
    default:
      jj_la1[77] = jj_gen;
      ;
    }
    VariableDeclaratorId();
  }

  final public void ConstructorDeclaration() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LANGLE:
      TypeParameters();
      break;
    default:
      jj_la1[78] = jj_gen;
      ;
    }
    jj_consume_token(IDENTIFIER);
    FormalParameters(new Vector());
    jj_consume_token(LBRACE);
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case _OPTIONS:
      case _LOOKAHEAD:
      case _IGNORE_CASE:
      case _PARSER_BEGIN:
      case _PARSER_END:
      case _CSCODE:
      case _TOKEN:
      case _SPECIAL_TOKEN:
      case _MORE:
      case _SKIP:
      case _TOKEN_MGR_DECLS:
      case _EOF:
      case ABSTRACT:
      case BOOLEAN:
      case BREAK:
      case BYTE:
      case CHAR:
      case CLASS:
      case CONTINUE:
      case DO:
      case DOUBLE:
      case FALSE:
      case OVERRIDE:
      case FLOAT:
      case FOR:
      case IF:
      case INT:
      case INTERFACE:
      case LONG:
      case NEW:
      case NULL:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case RETURN:
      case SHORT:
      case STATIC:
      case BASE:
      case SWITCH:
      case THIS:
      case THROW:
      case TRUE:
      case TRY:
      case VOID:
      case WHILE:
      case FOREACH:
      case PARTIAL:
      case YIELD:
      case INTERNAL:
      case READONLY:
      case FIXED:
      case UNSAFE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case LPAREN:
      case LBRACE:
      case SEMICOLON:
      case INCR:
      case DECR:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[79] = jj_gen;
        break label_22;
      }
      BlockStatement();
    }
    jj_consume_token(RBRACE);
  }

/*
 * Type, name and expression syntax follows.
 */
  final public void Type() throws ParseException {
    if (jj_2_13(2)) {
      ReferenceType();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
        PrimitiveType();
        break;
      default:
        jj_la1[80] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOOK:
      jj_consume_token(HOOK);
      break;
    default:
      jj_la1[81] = jj_gen;
      ;
    }
  }

  final public void ReferenceType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
      PrimitiveType();
      label_23:
      while (true) {
        jj_consume_token(LBRACKET);
        jj_consume_token(RBRACKET);
        if (jj_2_14(2)) {
          ;
        } else {
          break label_23;
        }
      }
      break;
    case IDENTIFIER:
      ClassOrInterfaceType();
      label_24:
      while (true) {
        if (jj_2_15(2)) {
          ;
        } else {
          break label_24;
        }
        jj_consume_token(LBRACKET);
        jj_consume_token(RBRACKET);
      }
      break;
    default:
      jj_la1[82] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ClassOrInterfaceType() throws ParseException {
    jj_consume_token(IDENTIFIER);
    if (jj_2_16(2)) {
      TypeArguments();
    } else {
      ;
    }
    label_25:
    while (true) {
      if (jj_2_17(2)) {
        ;
      } else {
        break label_25;
      }
      jj_consume_token(DOT);
      jj_consume_token(IDENTIFIER);
      if (jj_2_18(2)) {
        TypeArguments();
      } else {
        ;
      }
    }
  }

  final public void TypeArguments() throws ParseException {
    jj_consume_token(LANGLE);
    TypeArgument();
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[83] = jj_gen;
        break label_26;
      }
      jj_consume_token(COMMA);
      TypeArgument();
    }
    jj_consume_token(RANGLE);
  }

  final public void TypeArgument() throws ParseException {
    if (jj_2_19(2)) {
      PrimitiveType();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case IDENTIFIER:
        ReferenceType();
        break;
      default:
        jj_la1[84] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void PrimitiveType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
      jj_consume_token(BOOLEAN);
      break;
    case CHAR:
      jj_consume_token(CHAR);
      break;
    case BYTE:
      jj_consume_token(BYTE);
      break;
    case SHORT:
      jj_consume_token(SHORT);
      break;
    case INT:
      jj_consume_token(INT);
      break;
    case LONG:
      jj_consume_token(LONG);
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
      break;
    case DOUBLE:
      jj_consume_token(DOUBLE);
      break;
    default:
      jj_la1[85] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ResultType(java.util.Vector tokens) throws ParseException {
          Token first = getToken(1);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VOID:
      jj_consume_token(VOID);
      break;
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case IDENTIFIER:
      Type();
      break;
    default:
      jj_la1[86] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          Token last = getToken(0);
          Token t = first;
          while (true) {
            tokens.addElement(t);
            if (t == last) break;
            t = t.next;
          }
  }

  final public void NameType(java.util.Vector tokens) throws ParseException {
          Token first = getToken(1);
    CSIdentifier();
    jj_consume_token(ASSIGN);
      Token last = getToken(0);
          Token t = first;
          while (true) {
            tokens.addElement(t);
            if (t == last) break;
            t = t.next;
          }
    Name(tokens);
  }

  final public void Name(java.util.Vector tokens) throws ParseException {
          Token first = getToken(1);
    CSIdentifier();
    label_27:
    while (true) {
      if (jj_2_20(2)) {
        ;
      } else {
        break label_27;
      }
      jj_consume_token(DOT);
      CSIdentifier();
    }
          Token last = getToken(0);
          Token t = first;
          while (true) {
            tokens.addElement(t);
            if (t == last) break;
            t = t.next;
          }
  }

  final public void NameList() throws ParseException {
    Name(new Vector());
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[87] = jj_gen;
        break label_28;
      }
      jj_consume_token(COMMA);
      Name(new Vector());
    }
  }

/*
 * Expression syntax follows.
 */
  final public void Expression(java.util.Vector tokens) throws ParseException {
          Token first = getToken(1);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DELEGATE:
      AnonymousDelegate();
      break;
    case _OPTIONS:
    case _LOOKAHEAD:
    case _IGNORE_CASE:
    case _PARSER_BEGIN:
    case _PARSER_END:
    case _CSCODE:
    case _TOKEN:
    case _SPECIAL_TOKEN:
    case _MORE:
    case _SKIP:
    case _TOKEN_MGR_DECLS:
    case _EOF:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case BASE:
    case THIS:
    case TRUE:
    case VOID:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case LPAREN:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:
    case IDENTIFIER:
      ConditionalExpression();
      if (jj_2_21(2)) {
        AssignmentOperator();
        Expression(new java.util.Vector());
      } else {
        ;
      }
          Token last = getToken(0);
          Token t = first;
          while (true) {
            tokens.addElement(t);
            if (t == last) break;
            t = t.next;
          }
      break;
    default:
      jj_la1[88] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void AnonymousDelegate() throws ParseException {
    jj_consume_token(DELEGATE);
    FormalParameters(new Vector());
    Block(new Vector());
  }

  final public void AssignmentOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGN:
      jj_consume_token(ASSIGN);
      break;
    case STARASSIGN:
      jj_consume_token(STARASSIGN);
      break;
    case SLASHASSIGN:
      jj_consume_token(SLASHASSIGN);
      break;
    case REMASSIGN:
      jj_consume_token(REMASSIGN);
      break;
    case PLUSASSIGN:
      jj_consume_token(PLUSASSIGN);
      break;
    case MINUSASSIGN:
      jj_consume_token(MINUSASSIGN);
      break;
    case 135:
      jj_consume_token(135);
      break;
    case 136:
      jj_consume_token(136);
      break;
    case 137:
      jj_consume_token(137);
      break;
    case ANDASSIGN:
      jj_consume_token(ANDASSIGN);
      break;
    case XORASSIGN:
      jj_consume_token(XORASSIGN);
      break;
    case ORASSIGN:
      jj_consume_token(ORASSIGN);
      break;
    default:
      jj_la1[89] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ConditionalExpression() throws ParseException {
    ConditionalOrExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOOK:
      jj_consume_token(HOOK);
      Expression(new Vector());
      jj_consume_token(COLON);
      Expression(new Vector());
      break;
    default:
      jj_la1[90] = jj_gen;
      ;
    }
  }

  final public void ConditionalOrExpression() throws ParseException {
    ConditionalAndExpression();
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SC_OR:
        ;
        break;
      default:
        jj_la1[91] = jj_gen;
        break label_29;
      }
      jj_consume_token(SC_OR);
      ConditionalAndExpression();
    }
  }

  final public void ConditionalAndExpression() throws ParseException {
    InclusiveOrExpression();
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SC_AND:
        ;
        break;
      default:
        jj_la1[92] = jj_gen;
        break label_30;
      }
      jj_consume_token(SC_AND);
      InclusiveOrExpression();
    }
  }

  final public void InclusiveOrExpression() throws ParseException {
    ExclusiveOrExpression();
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_OR:
        ;
        break;
      default:
        jj_la1[93] = jj_gen;
        break label_31;
      }
      jj_consume_token(BIT_OR);
      ExclusiveOrExpression();
    }
  }

  final public void ExclusiveOrExpression() throws ParseException {
    AndExpression();
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XOR:
        ;
        break;
      default:
        jj_la1[94] = jj_gen;
        break label_32;
      }
      jj_consume_token(XOR);
      AndExpression();
    }
  }

  final public void AndExpression() throws ParseException {
    EqualityExpression();
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_AND:
        ;
        break;
      default:
        jj_la1[95] = jj_gen;
        break label_33;
      }
      jj_consume_token(BIT_AND);
      EqualityExpression();
    }
  }

  final public void EqualityExpression() throws ParseException {
    InstanceOfExpression();
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
      case NE:
        ;
        break;
      default:
        jj_la1[96] = jj_gen;
        break label_34;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
        jj_consume_token(EQ);
        break;
      case NE:
        jj_consume_token(NE);
        break;
      default:
        jj_la1[97] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      InstanceOfExpression();
    }
  }

  final public void InstanceOfExpression() throws ParseException {
    RelationalExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 138:
      jj_consume_token(138);
      Type();
      break;
    default:
      jj_la1[98] = jj_gen;
      ;
    }
  }

  final public void RelationalExpression() throws ParseException {
    ShiftExpression();
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LANGLE:
      case LE:
      case GE:
      case RANGLE:
        ;
        break;
      default:
        jj_la1[99] = jj_gen;
        break label_35;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LANGLE:
        jj_consume_token(LANGLE);
        break;
      case RANGLE:
        jj_consume_token(RANGLE);
        break;
      case LE:
        jj_consume_token(LE);
        break;
      case GE:
        jj_consume_token(GE);
        break;
      default:
        jj_la1[100] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      ShiftExpression();
    }
  }

  final public void ShiftExpression() throws ParseException {
    AdditiveExpression();
    label_36:
    while (true) {
      if (jj_2_22(1)) {
        ;
      } else {
        break label_36;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 139:
        jj_consume_token(139);
        break;
      default:
        jj_la1[101] = jj_gen;
        if (jj_2_23(1)) {
          RSIGNEDSHIFT();
        } else if (jj_2_24(1)) {
          RUNSIGNEDSHIFT();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      AdditiveExpression();
    }
  }

  final public void AdditiveExpression() throws ParseException {
    MultiplicativeExpression();
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[102] = jj_gen;
        break label_37;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        break;
      default:
        jj_la1[103] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      MultiplicativeExpression();
    }
  }

  final public void MultiplicativeExpression() throws ParseException {
    UnaryExpression();
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
      case SLASH:
      case REM:
        ;
        break;
      default:
        jj_la1[104] = jj_gen;
        break label_38;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        jj_consume_token(STAR);
        break;
      case SLASH:
        jj_consume_token(SLASH);
        break;
      case REM:
        jj_consume_token(REM);
        break;
      default:
        jj_la1[105] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      UnaryExpression();
    }
  }

  final public void UnaryExpression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        break;
      default:
        jj_la1[106] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      UnaryExpression();
      break;
    case INCR:
      PreIncrementExpression();
      break;
    case DECR:
      PreDecrementExpression();
      break;
    case _OPTIONS:
    case _LOOKAHEAD:
    case _IGNORE_CASE:
    case _PARSER_BEGIN:
    case _PARSER_END:
    case _CSCODE:
    case _TOKEN:
    case _SPECIAL_TOKEN:
    case _MORE:
    case _SKIP:
    case _TOKEN_MGR_DECLS:
    case _EOF:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case BASE:
    case THIS:
    case TRUE:
    case VOID:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case LPAREN:
    case BANG:
    case TILDE:
    case IDENTIFIER:
      UnaryExpressionNotPlusMinus();
      break;
    default:
      jj_la1[107] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void PreIncrementExpression() throws ParseException {
    jj_consume_token(INCR);
    PrimaryExpression();
  }

  final public void PreDecrementExpression() throws ParseException {
    jj_consume_token(DECR);
    PrimaryExpression();
  }

  final public void UnaryExpressionNotPlusMinus() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BANG:
    case TILDE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TILDE:
        jj_consume_token(TILDE);
        break;
      case BANG:
        jj_consume_token(BANG);
        break;
      default:
        jj_la1[108] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      UnaryExpression();
      break;
    default:
      jj_la1[109] = jj_gen;
      if (jj_2_25(2147483647)) {
        CastExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case _OPTIONS:
        case _LOOKAHEAD:
        case _IGNORE_CASE:
        case _PARSER_BEGIN:
        case _PARSER_END:
        case _CSCODE:
        case _TOKEN:
        case _SPECIAL_TOKEN:
        case _MORE:
        case _SKIP:
        case _TOKEN_MGR_DECLS:
        case _EOF:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case BASE:
        case THIS:
        case TRUE:
        case VOID:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case LPAREN:
        case IDENTIFIER:
          PostfixExpression();
          break;
        default:
          jj_la1[110] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

// This production is to determine lookahead only.  The LOOKAHEAD specifications
// below are not used, but they are there just to indicate that we know about
// this.
  final public void CastLookahead() throws ParseException {
    if (jj_2_26(2)) {
      jj_consume_token(LPAREN);
      PrimitiveType();
    } else if (jj_2_27(2147483647)) {
      jj_consume_token(LPAREN);
      Type();
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        Type();
        jj_consume_token(RPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TILDE:
          jj_consume_token(TILDE);
          break;
        case BANG:
          jj_consume_token(BANG);
          break;
        case LPAREN:
          jj_consume_token(LPAREN);
          break;
        case IDENTIFIER:
          jj_consume_token(IDENTIFIER);
          break;
        case THIS:
          jj_consume_token(THIS);
          break;
        case BASE:
          jj_consume_token(BASE);
          break;
        case NEW:
          jj_consume_token(NEW);
          break;
        case FALSE:
        case NULL:
        case TRUE:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
          Literal();
          break;
        default:
          jj_la1[111] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[112] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void PostfixExpression() throws ParseException {
    PrimaryExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INCR:
    case DECR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INCR:
        jj_consume_token(INCR);
        break;
      case DECR:
        jj_consume_token(DECR);
        break;
      default:
        jj_la1[113] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[114] = jj_gen;
      ;
    }
  }

  final public void CastExpression() throws ParseException {
    if (jj_2_28(2147483647)) {
      jj_consume_token(LPAREN);
      Type();
      jj_consume_token(RPAREN);
      UnaryExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        Type();
        jj_consume_token(RPAREN);
        UnaryExpressionNotPlusMinus();
        break;
      default:
        jj_la1[115] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void PrimaryExpression() throws ParseException {
    PrimaryPrefix();
    label_39:
    while (true) {
      if (jj_2_29(2)) {
        ;
      } else {
        break label_39;
      }
      PrimarySuffix();
    }
  }

  final public void MemberSelector() throws ParseException {
    jj_consume_token(DOT);
    TypeArguments();
    jj_consume_token(IDENTIFIER);
  }

  final public void PrimaryPrefix() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSE:
    case NULL:
    case TRUE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
      Literal();
      break;
    case THIS:
      jj_consume_token(THIS);
      break;
    case BASE:
      jj_consume_token(BASE);
      jj_consume_token(DOT);
      jj_consume_token(IDENTIFIER);
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      Expression(new Vector());
      jj_consume_token(RPAREN);
      break;
    case NEW:
      AllocationExpression();
      break;
    default:
      jj_la1[116] = jj_gen;
      if (jj_2_30(2147483647)) {
        ResultType(new Vector());
        jj_consume_token(DOT);
        jj_consume_token(CLASS);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case _OPTIONS:
        case _LOOKAHEAD:
        case _IGNORE_CASE:
        case _PARSER_BEGIN:
        case _PARSER_END:
        case _CSCODE:
        case _TOKEN:
        case _SPECIAL_TOKEN:
        case _MORE:
        case _SKIP:
        case _TOKEN_MGR_DECLS:
        case _EOF:
        case IDENTIFIER:
          Name(new Vector());
          break;
        default:
          jj_la1[117] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void PrimarySuffix() throws ParseException {
    if (jj_2_31(2)) {
      jj_consume_token(DOT);
      jj_consume_token(THIS);
    } else if (jj_2_32(2)) {
      jj_consume_token(DOT);
      AllocationExpression();
    } else if (jj_2_33(3)) {
      MemberSelector();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        jj_consume_token(LBRACKET);
        Expression(new Vector());
        jj_consume_token(RBRACKET);
        break;
      case DOT:
        jj_consume_token(DOT);
        jj_consume_token(IDENTIFIER);
        break;
      case LPAREN:
        Arguments(new Vector());
        break;
      default:
        jj_la1[118] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void Literal() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case FLOATING_POINT_LITERAL:
      jj_consume_token(FLOATING_POINT_LITERAL);
      break;
    case CHARACTER_LITERAL:
      jj_consume_token(CHARACTER_LITERAL);
      break;
    case STRING_LITERAL:
      jj_consume_token(STRING_LITERAL);
      break;
    case FALSE:
    case TRUE:
      BooleanLiteral();
      break;
    case NULL:
      NullLiteral();
      break;
    default:
      jj_la1[119] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public int IntegerLiteral() throws ParseException {
    jj_consume_token(INTEGER_LITERAL);
          try {
            {if (true) return Integer.parseInt(token.image);}
          } catch (NumberFormatException e) {
            {if (true) throw new Error();}
          }
    throw new Error("Missing return statement in function");
  }

  final public boolean BooleanLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
           {if (true) return true;}
      break;
    case FALSE:
      jj_consume_token(FALSE);
            {if (true) return false;}
      break;
    default:
      jj_la1[120] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String StringLiteral() throws ParseException {
          Token t;
    t = jj_consume_token(STRING_LITERAL);
          {if (true) return remove_escapes_and_quotes(t, t.image);}
    throw new Error("Missing return statement in function");
  }

  final public void NullLiteral() throws ParseException {
    jj_consume_token(NULL);
  }

  final public void Arguments(java.util.Vector tokens) throws ParseException {
          Token first, last;
    jj_consume_token(LPAREN);
          first = getToken(1);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case _OPTIONS:
    case _LOOKAHEAD:
    case _IGNORE_CASE:
    case _PARSER_BEGIN:
    case _PARSER_END:
    case _CSCODE:
    case _TOKEN:
    case _SPECIAL_TOKEN:
    case _MORE:
    case _SKIP:
    case _TOKEN_MGR_DECLS:
    case _EOF:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case BASE:
    case THIS:
    case TRUE:
    case VOID:
    case DELEGATE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case LPAREN:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:
    case IDENTIFIER:
      ArgumentList();
      break;
    default:
      jj_la1[121] = jj_gen;
      ;
    }
          last = getToken(0);
    jj_consume_token(RPAREN);
          if (last.next != first) { // i.e., this is not an empty sequence
            Token t = first;
            while (true) {
              tokens.addElement(t);
              if (t == last) break;
              t = t.next;
            }
          }
  }

  final public void ArgumentList() throws ParseException {
    Expression(new Vector());
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[122] = jj_gen;
        break label_40;
      }
      jj_consume_token(COMMA);
      Expression(new Vector());
    }
  }

  final public void AllocationExpression() throws ParseException {
    if (jj_2_34(2)) {
      jj_consume_token(NEW);
      PrimitiveType();
      ArrayDimsAndInits();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEW:
        jj_consume_token(NEW);
        ClassOrInterfaceType();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LANGLE:
          TypeArguments();
          break;
        default:
          jj_la1[123] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
          ArrayDimsAndInits();
          break;
        case LPAREN:
          Arguments(new Vector());
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACE:
            ClassOrInterfaceBody(false, new Vector());
            break;
          default:
            jj_la1[124] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[125] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[126] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
 * The third LOOKAHEAD specification below is to parse to PrimarySuffix
 * if there is an expression between the "[...]".
 */
  final public void ArrayDimsAndInits() throws ParseException {
    if (jj_2_37(2)) {
      label_41:
      while (true) {
        jj_consume_token(LBRACKET);
        Expression(new Vector());
        jj_consume_token(RBRACKET);
        if (jj_2_35(2)) {
          ;
        } else {
          break label_41;
        }
      }
      label_42:
      while (true) {
        if (jj_2_36(2)) {
          ;
        } else {
          break label_42;
        }
        jj_consume_token(LBRACKET);
        jj_consume_token(RBRACKET);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        label_43:
        while (true) {
          jj_consume_token(LBRACKET);
          jj_consume_token(RBRACKET);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACKET:
            ;
            break;
          default:
            jj_la1[127] = jj_gen;
            break label_43;
          }
        }
        ArrayInitializer();
        break;
      default:
        jj_la1[128] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
 * Statement syntax follows.
 */
  final public void Statement() throws ParseException {
    if (jj_2_38(2)) {
      LabeledStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        Block(new Vector());
        break;
      case UNSAFE:
        UnsafeStatment();
        break;
      case SEMICOLON:
        EmptyStatement();
        break;
      case _OPTIONS:
      case _LOOKAHEAD:
      case _IGNORE_CASE:
      case _PARSER_BEGIN:
      case _PARSER_END:
      case _CSCODE:
      case _TOKEN:
      case _SPECIAL_TOKEN:
      case _MORE:
      case _SKIP:
      case _TOKEN_MGR_DECLS:
      case _EOF:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case BASE:
      case THIS:
      case TRUE:
      case VOID:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case LPAREN:
      case INCR:
      case DECR:
      case IDENTIFIER:
        StatementExpression();
        jj_consume_token(SEMICOLON);
        break;
      case SWITCH:
        SwitchStatement();
        break;
      case IF:
        IfStatement();
        break;
      case WHILE:
        WhileStatement();
        break;
      case DO:
        DoStatement();
        break;
      case FOR:
        ForStatement();
        break;
      case FOREACH:
        ForEachStatement();
        break;
      case BREAK:
        BreakStatement();
        break;
      case CONTINUE:
        ContinueStatement();
        break;
      case RETURN:
      case YIELD:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case YIELD:
          jj_consume_token(YIELD);
          break;
        default:
          jj_la1[129] = jj_gen;
          ;
        }
        ReturnStatement();
        break;
      case THROW:
        ThrowStatement();
        break;
      case TRY:
        TryStatement();
        break;
      default:
        jj_la1[130] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*void AssertStatement():
{}
{ "assert" Expression(new Vector()) [ ":" Expression(new Vector()) ] ";" }
*/
  final public void LabeledStatement() throws ParseException {
    jj_consume_token(IDENTIFIER);
    jj_consume_token(COLON);
    Statement();
  }

// Unsafe Block
  final public void UnsafeStatment() throws ParseException {
    jj_consume_token(UNSAFE);
    Block(new Vector());
  }

  final public void Block(java.util.Vector tokens) throws ParseException {
          Token first, last;
    jj_consume_token(LBRACE);
          first = getToken(1);
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case _OPTIONS:
      case _LOOKAHEAD:
      case _IGNORE_CASE:
      case _PARSER_BEGIN:
      case _PARSER_END:
      case _CSCODE:
      case _TOKEN:
      case _SPECIAL_TOKEN:
      case _MORE:
      case _SKIP:
      case _TOKEN_MGR_DECLS:
      case _EOF:
      case ABSTRACT:
      case BOOLEAN:
      case BREAK:
      case BYTE:
      case CHAR:
      case CLASS:
      case CONTINUE:
      case DO:
      case DOUBLE:
      case FALSE:
      case OVERRIDE:
      case FLOAT:
      case FOR:
      case IF:
      case INT:
      case INTERFACE:
      case LONG:
      case NEW:
      case NULL:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case RETURN:
      case SHORT:
      case STATIC:
      case BASE:
      case SWITCH:
      case THIS:
      case THROW:
      case TRUE:
      case TRY:
      case VOID:
      case WHILE:
      case FOREACH:
      case PARTIAL:
      case YIELD:
      case INTERNAL:
      case READONLY:
      case FIXED:
      case UNSAFE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case LPAREN:
      case LBRACE:
      case SEMICOLON:
      case INCR:
      case DECR:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[131] = jj_gen;
        break label_44;
      }
      BlockStatement();
    }
          last = getToken(0);
    jj_consume_token(RBRACE);
          if (last.next != first) { // i.e., this is not an empty sequence
            Token t = first;
            while (true) {
              tokens.addElement(t);
              if (t == last) break;
              t = t.next;
            }
          }
  }

  final public void BlockStatement() throws ParseException {
    if (jj_2_39(2147483647)) {
      LocalVariableDeclaration();
      jj_consume_token(SEMICOLON);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case _OPTIONS:
      case _LOOKAHEAD:
      case _IGNORE_CASE:
      case _PARSER_BEGIN:
      case _PARSER_END:
      case _CSCODE:
      case _TOKEN:
      case _SPECIAL_TOKEN:
      case _MORE:
      case _SKIP:
      case _TOKEN_MGR_DECLS:
      case _EOF:
      case BOOLEAN:
      case BREAK:
      case BYTE:
      case CHAR:
      case CONTINUE:
      case DO:
      case DOUBLE:
      case FALSE:
      case FLOAT:
      case FOR:
      case IF:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case RETURN:
      case SHORT:
      case BASE:
      case SWITCH:
      case THIS:
      case THROW:
      case TRUE:
      case TRY:
      case VOID:
      case WHILE:
      case FOREACH:
      case YIELD:
      case UNSAFE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case LPAREN:
      case LBRACE:
      case SEMICOLON:
      case INCR:
      case DECR:
      case IDENTIFIER:
        Statement();
        break;
      case CLASS:
      case INTERFACE:
        ClassOrInterfaceDeclaration(0, new Vector());
        break;
      default:
        jj_la1[132] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void LocalVariableDeclaration() throws ParseException {
    Modifiers();
    Type();
    VariableDeclarator();
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[133] = jj_gen;
        break label_45;
      }
      jj_consume_token(COMMA);
      VariableDeclarator();
    }
  }

  final public void EmptyStatement() throws ParseException {
    jj_consume_token(SEMICOLON);
  }

  final public void StatementExpression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INCR:
      PreIncrementExpression();
      break;
    case DECR:
      PreDecrementExpression();
      break;
    case _OPTIONS:
    case _LOOKAHEAD:
    case _IGNORE_CASE:
    case _PARSER_BEGIN:
    case _PARSER_END:
    case _CSCODE:
    case _TOKEN:
    case _SPECIAL_TOKEN:
    case _MORE:
    case _SKIP:
    case _TOKEN_MGR_DECLS:
    case _EOF:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case BASE:
    case THIS:
    case TRUE:
    case VOID:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case LPAREN:
    case IDENTIFIER:
      PrimaryExpression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGN:
      case INCR:
      case DECR:
      case PLUSASSIGN:
      case MINUSASSIGN:
      case STARASSIGN:
      case SLASHASSIGN:
      case ANDASSIGN:
      case ORASSIGN:
      case XORASSIGN:
      case REMASSIGN:
      case 135:
      case 136:
      case 137:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INCR:
          jj_consume_token(INCR);
          break;
        case DECR:
          jj_consume_token(DECR);
          break;
        case ASSIGN:
        case PLUSASSIGN:
        case MINUSASSIGN:
        case STARASSIGN:
        case SLASHASSIGN:
        case ANDASSIGN:
        case ORASSIGN:
        case XORASSIGN:
        case REMASSIGN:
        case 135:
        case 136:
        case 137:
          AssignmentOperator();
          Expression(new Vector());
          break;
        default:
          jj_la1[134] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[135] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[136] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void SwitchStatement() throws ParseException {
    jj_consume_token(SWITCH);
    jj_consume_token(LPAREN);
    Expression(new Vector());
    jj_consume_token(RPAREN);
    jj_consume_token(LBRACE);
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CASE:
      case _DEFAULT:
        ;
        break;
      default:
        jj_la1[137] = jj_gen;
        break label_46;
      }
      SwitchLabel();
      label_47:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case _OPTIONS:
        case _LOOKAHEAD:
        case _IGNORE_CASE:
        case _PARSER_BEGIN:
        case _PARSER_END:
        case _CSCODE:
        case _TOKEN:
        case _SPECIAL_TOKEN:
        case _MORE:
        case _SKIP:
        case _TOKEN_MGR_DECLS:
        case _EOF:
        case ABSTRACT:
        case BOOLEAN:
        case BREAK:
        case BYTE:
        case CHAR:
        case CLASS:
        case CONTINUE:
        case DO:
        case DOUBLE:
        case FALSE:
        case OVERRIDE:
        case FLOAT:
        case FOR:
        case IF:
        case INT:
        case INTERFACE:
        case LONG:
        case NEW:
        case NULL:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case RETURN:
        case SHORT:
        case STATIC:
        case BASE:
        case SWITCH:
        case THIS:
        case THROW:
        case TRUE:
        case TRY:
        case VOID:
        case WHILE:
        case FOREACH:
        case PARTIAL:
        case YIELD:
        case INTERNAL:
        case READONLY:
        case FIXED:
        case UNSAFE:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case LPAREN:
        case LBRACE:
        case SEMICOLON:
        case INCR:
        case DECR:
        case IDENTIFIER:
          ;
          break;
        default:
          jj_la1[138] = jj_gen;
          break label_47;
        }
        BlockStatement();
      }
    }
    jj_consume_token(RBRACE);
  }

  final public void SwitchLabel() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CASE:
      jj_consume_token(CASE);
      Expression(new Vector());
      jj_consume_token(COLON);
      break;
    case _DEFAULT:
      jj_consume_token(_DEFAULT);
      jj_consume_token(COLON);
      break;
    default:
      jj_la1[139] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void IfStatement() throws ParseException {
    jj_consume_token(IF);
    jj_consume_token(LPAREN);
    Expression(new Vector());
    jj_consume_token(RPAREN);
    Statement();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
      Statement();
      break;
    default:
      jj_la1[140] = jj_gen;
      ;
    }
  }

  final public void WhileStatement() throws ParseException {
    jj_consume_token(WHILE);
    jj_consume_token(LPAREN);
    Expression(new Vector());
    jj_consume_token(RPAREN);
    Statement();
  }

  final public void DoStatement() throws ParseException {
    jj_consume_token(DO);
    Statement();
    jj_consume_token(WHILE);
    jj_consume_token(LPAREN);
    Expression(new Vector());
    jj_consume_token(RPAREN);
    jj_consume_token(SEMICOLON);
  }

  final public void ForStatement() throws ParseException {
    jj_consume_token(FOR);
    jj_consume_token(LPAREN);
    if (jj_2_40(2147483647)) {
      Modifiers();
      Type();
      jj_consume_token(IDENTIFIER);
      jj_consume_token(COLON);
      Expression(new Vector());
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case _OPTIONS:
      case _LOOKAHEAD:
      case _IGNORE_CASE:
      case _PARSER_BEGIN:
      case _PARSER_END:
      case _CSCODE:
      case _TOKEN:
      case _SPECIAL_TOKEN:
      case _MORE:
      case _SKIP:
      case _TOKEN_MGR_DECLS:
      case _EOF:
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FALSE:
      case OVERRIDE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case BASE:
      case THIS:
      case TRUE:
      case VOID:
      case PARTIAL:
      case INTERNAL:
      case READONLY:
      case FIXED:
      case UNSAFE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case LPAREN:
      case SEMICOLON:
      case INCR:
      case DECR:
      case IDENTIFIER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case _OPTIONS:
        case _LOOKAHEAD:
        case _IGNORE_CASE:
        case _PARSER_BEGIN:
        case _PARSER_END:
        case _CSCODE:
        case _TOKEN:
        case _SPECIAL_TOKEN:
        case _MORE:
        case _SKIP:
        case _TOKEN_MGR_DECLS:
        case _EOF:
        case ABSTRACT:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FALSE:
        case OVERRIDE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case SHORT:
        case STATIC:
        case BASE:
        case THIS:
        case TRUE:
        case VOID:
        case PARTIAL:
        case INTERNAL:
        case READONLY:
        case FIXED:
        case UNSAFE:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case LPAREN:
        case INCR:
        case DECR:
        case IDENTIFIER:
          ForInit();
          break;
        default:
          jj_la1[141] = jj_gen;
          ;
        }
        jj_consume_token(SEMICOLON);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case _OPTIONS:
        case _LOOKAHEAD:
        case _IGNORE_CASE:
        case _PARSER_BEGIN:
        case _PARSER_END:
        case _CSCODE:
        case _TOKEN:
        case _SPECIAL_TOKEN:
        case _MORE:
        case _SKIP:
        case _TOKEN_MGR_DECLS:
        case _EOF:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case BASE:
        case THIS:
        case TRUE:
        case VOID:
        case DELEGATE:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case LPAREN:
        case BANG:
        case TILDE:
        case INCR:
        case DECR:
        case PLUS:
        case MINUS:
        case IDENTIFIER:
          Expression(new Vector());
          break;
        default:
          jj_la1[142] = jj_gen;
          ;
        }
        jj_consume_token(SEMICOLON);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case _OPTIONS:
        case _LOOKAHEAD:
        case _IGNORE_CASE:
        case _PARSER_BEGIN:
        case _PARSER_END:
        case _CSCODE:
        case _TOKEN:
        case _SPECIAL_TOKEN:
        case _MORE:
        case _SKIP:
        case _TOKEN_MGR_DECLS:
        case _EOF:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case BASE:
        case THIS:
        case TRUE:
        case VOID:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case LPAREN:
        case INCR:
        case DECR:
        case IDENTIFIER:
          ForUpdate();
          break;
        default:
          jj_la1[143] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[144] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RPAREN);
    Statement();
  }

  final public void ForInit() throws ParseException {
    if (jj_2_41(2147483647)) {
      LocalVariableDeclaration();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case _OPTIONS:
      case _LOOKAHEAD:
      case _IGNORE_CASE:
      case _PARSER_BEGIN:
      case _PARSER_END:
      case _CSCODE:
      case _TOKEN:
      case _SPECIAL_TOKEN:
      case _MORE:
      case _SKIP:
      case _TOKEN_MGR_DECLS:
      case _EOF:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case BASE:
      case THIS:
      case TRUE:
      case VOID:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case LPAREN:
      case INCR:
      case DECR:
      case IDENTIFIER:
        StatementExpressionList();
        break;
      default:
        jj_la1[145] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void ForEachStatement() throws ParseException {
    jj_consume_token(FOREACH);
    jj_consume_token(LPAREN);
    Modifiers();
    Type();
    jj_consume_token(IDENTIFIER);
    jj_consume_token(140);
    Expression(new Vector());
    jj_consume_token(RPAREN);
    Statement();
  }

  final public void StatementExpressionList() throws ParseException {
    StatementExpression();
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[146] = jj_gen;
        break label_48;
      }
      jj_consume_token(COMMA);
      StatementExpression();
    }
  }

  final public void ForUpdate() throws ParseException {
    StatementExpressionList();
  }

  final public void BreakStatement() throws ParseException {
    jj_consume_token(BREAK);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      break;
    default:
      jj_la1[147] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
  }

  final public void ContinueStatement() throws ParseException {
    jj_consume_token(CONTINUE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      break;
    default:
      jj_la1[148] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
  }

  final public void ReturnStatement() throws ParseException {
          Token t;
    // Iterator Yield
      //[ "yield" ]
      t = jj_consume_token(RETURN);
          // Add if statement to prevent subsequent code generated
          // from being dead code.
          if (inAction) {
            t.image = "{if (true) return";
            jumpPatched = true;
          }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case _OPTIONS:
    case _LOOKAHEAD:
    case _IGNORE_CASE:
    case _PARSER_BEGIN:
    case _PARSER_END:
    case _CSCODE:
    case _TOKEN:
    case _SPECIAL_TOKEN:
    case _MORE:
    case _SKIP:
    case _TOKEN_MGR_DECLS:
    case _EOF:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case BASE:
    case THIS:
    case TRUE:
    case VOID:
    case DELEGATE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case LPAREN:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:
    case IDENTIFIER:
      Expression(new java.util.Vector());
      break;
    default:
      jj_la1[149] = jj_gen;
      ;
    }
    t = jj_consume_token(SEMICOLON);
          // Add closing brace for above if statement.
          if (inAction) {
            t.image = ";}";
          }
  }

  final public void ThrowStatement() throws ParseException {
          Token t;
    t = jj_consume_token(THROW);
          // Add if statement to prevent subsequent code generated
          // from being dead code.
          if (inAction) {
            t.image = "{if (true) throw";
            jumpPatched = true;
          }
    Expression(new java.util.Vector());
    t = jj_consume_token(SEMICOLON);
          // Add closing brace for above if statement.
          if (inAction) {
            t.image = ";}";
          }
  }

  final public void TryStatement() throws ParseException {
    jj_consume_token(TRY);
    Block(new Vector());
    label_49:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CATCH:
        ;
        break;
      default:
        jj_la1[150] = jj_gen;
        break label_49;
      }
      jj_consume_token(CATCH);
      jj_consume_token(LPAREN);
      FormalParameter();
      jj_consume_token(RPAREN);
      Block(new Vector());
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 141:
      jj_consume_token(141);
      Block(new Vector());
      break;
    default:
      jj_la1[151] = jj_gen;
      ;
    }
  }

/* We use productions to match >>>, >> and > so that we can keep the
 * type declaration syntax with generics clean
 */
  final public void RUNSIGNEDSHIFT() throws ParseException {
    if (getToken(1).kind == GT &&
                    ((Token.GTToken)getToken(1)).realKind == RUNSIGNEDSHIFT) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RANGLE);
    jj_consume_token(RANGLE);
    jj_consume_token(RANGLE);
  }

  final public void RSIGNEDSHIFT() throws ParseException {
    if (getToken(1).kind == GT &&
                    ((Token.GTToken)getToken(1)).realKind == RSIGNEDSHIFT) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RANGLE);
    jj_consume_token(RANGLE);
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_3R_177() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_183()) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) return true;
    }
    return false;
  }

  private boolean jj_3R_183() {
    if (jj_3R_88()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) {
    jj_scanpos = xsp;
    if (jj_3R_207()) {
    jj_scanpos = xsp;
    if (jj_3R_208()) {
    jj_scanpos = xsp;
    if (jj_3R_209()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_244() {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_223() {
    if (jj_scan_token(THROW)) return true;
    if (jj_3R_79()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_120() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_scan_token(142)) return true;
    return false;
  }

  private boolean jj_3R_259() {
    if (jj_3R_271()) return true;
    return false;
  }

  private boolean jj_3R_171() {
    if (jj_3R_177()) return true;
    return false;
  }

  private boolean jj_3R_239() {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_162() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_171()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_285() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_213()) return true;
    return false;
  }

  private boolean jj_3R_222() {
    if (jj_scan_token(RETURN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_239()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_scan_token(LANGLE)) return true;
    if (jj_scan_token(142)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_120()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RANGLE)) return true;
    return false;
  }

  private boolean jj_3R_242() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3R_236() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3R_225() {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_122()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_242()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_221() {
    if (jj_scan_token(CONTINUE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(142)) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_220() {
    if (jj_scan_token(BREAK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(142)) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_271() {
    if (jj_3R_280()) return true;
    return false;
  }

  private boolean jj_3R_258() {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_280() {
    if (jj_3R_213()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_285()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_227() {
    if (jj_scan_token(DELEGATE)) return true;
    if (jj_3R_84()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_244()) jj_scanpos = xsp;
    if (jj_3R_149()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_41() {
    if (jj_3R_88()) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_201() {
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  private boolean jj_3R_219() {
    if (jj_scan_token(FOREACH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_88()) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(140)) return true;
    if (jj_3R_79()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3_40() {
    if (jj_3R_88()) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_279() {
    if (jj_3R_280()) return true;
    return false;
  }

  private boolean jj_3R_278() {
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_203() {
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_270() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_278()) {
    jj_scanpos = xsp;
    if (jj_3R_279()) return true;
    }
    return false;
  }

  private boolean jj_3R_202() {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_257() {
    if (jj_3R_270()) return true;
    return false;
  }

  private boolean jj_3R_238() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_257()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3R_258()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3R_259()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_181() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_3R_201()) return true;
    }
    if (jj_scan_token(IDENTIFIER)) return true;
    xsp = jj_scanpos;
    if (jj_3R_202()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_203()) jj_scanpos = xsp;
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_237() {
    if (jj_3R_88()) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_218() {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_237()) {
    jj_scanpos = xsp;
    if (jj_3R_238()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3R_217() {
    if (jj_scan_token(DO)) return true;
    if (jj_3R_180()) return true;
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_79()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_216() {
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_79()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3R_256() {
    if (jj_3R_168()) return true;
    return false;
  }

  private boolean jj_3R_186() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_185()) return true;
    return false;
  }

  private boolean jj_3R_215() {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_79()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_180()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_236()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_269() {
    if (jj_scan_token(_DEFAULT)) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_255() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_268()) {
    jj_scanpos = xsp;
    if (jj_3R_269()) return true;
    }
    return false;
  }

  private boolean jj_3R_268() {
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_79()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_235() {
    if (jj_3R_255()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_256()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_scan_token(UNSAFE)) return true;
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_scan_token(FIXED)) return true;
    return false;
  }

  private boolean jj_3R_214() {
    if (jj_scan_token(SWITCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_79()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_235()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_scan_token(READONLY)) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_scan_token(INTERNAL)) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(NEW)) return true;
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_scan_token(ABSTRACT)) return true;
    return false;
  }

  private boolean jj_3R_267() {
    if (jj_3R_78()) return true;
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_63() {
    if (jj_scan_token(PARTIAL)) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_scan_token(OVERRIDE)) return true;
    return false;
  }

  private boolean jj_3R_254() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_3R_267()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_scan_token(PRIVATE)) return true;
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_scan_token(PROTECTED)) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3R_234() {
    if (jj_3R_50()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_254()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_scan_token(PUBLIC)) return true;
    return false;
  }

  private boolean jj_3R_233() {
    if (jj_3R_253()) return true;
    return false;
  }

  private boolean jj_3R_213() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_232()) {
    jj_scanpos = xsp;
    if (jj_3R_233()) {
    jj_scanpos = xsp;
    if (jj_3R_234()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_232() {
    if (jj_3R_252()) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_57()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3_9() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_88() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_9()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_39() {
    if (jj_3R_88()) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_179() {
    if (jj_3R_88()) return true;
    if (jj_3R_71()) return true;
    if (jj_3R_185()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_186()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_175() {
    if (jj_3R_181()) return true;
    return false;
  }

  private boolean jj_3R_174() {
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3R_168() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_173() {
    if (jj_3R_179()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_scan_token(NAMESPACE)) return true;
    return false;
  }

  private boolean jj_3R_159() {
    if (jj_3R_168()) return true;
    return false;
  }

  private boolean jj_3R_150() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_159()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3_36() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_212() {
    if (jj_scan_token(UNSAFE)) return true;
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_scan_token(LANGLE)) return true;
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3R_200() {
    if (jj_3R_224()) return true;
    return false;
  }

  private boolean jj_3R_199() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_198() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(72)) jj_scanpos = xsp;
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_197() {
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_196() {
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_195() {
    if (jj_3R_219()) return true;
    return false;
  }

  private boolean jj_3R_194() {
    if (jj_3R_218()) return true;
    return false;
  }

  private boolean jj_3R_193() {
    if (jj_3R_217()) return true;
    return false;
  }

  private boolean jj_3R_192() {
    if (jj_3R_216()) return true;
    return false;
  }

  private boolean jj_3R_191() {
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_190() {
    if (jj_3R_214()) return true;
    return false;
  }

  private boolean jj_3R_189() {
    if (jj_3R_213()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_153() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_188() {
    if (jj_3R_212()) return true;
    return false;
  }

  private boolean jj_3R_187() {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_142() {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3_38() {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_180() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_38()) {
    jj_scanpos = xsp;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    if (jj_3R_188()) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_3R_189()) {
    jj_scanpos = xsp;
    if (jj_3R_190()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3R_193()) {
    jj_scanpos = xsp;
    if (jj_3R_194()) {
    jj_scanpos = xsp;
    if (jj_3R_195()) {
    jj_scanpos = xsp;
    if (jj_3R_196()) {
    jj_scanpos = xsp;
    if (jj_3R_197()) {
    jj_scanpos = xsp;
    if (jj_3R_198()) {
    jj_scanpos = xsp;
    if (jj_3R_199()) {
    jj_scanpos = xsp;
    if (jj_3R_200()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_57() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(4)) {
    jj_scanpos = xsp;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(6)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_161() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_35() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_79()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_152() {
    Token xsp;
    if (jj_3R_161()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_161()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_163() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_141() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3R_152()) return true;
    }
    return false;
  }

  private boolean jj_3_37() {
    Token xsp;
    if (jj_3_35()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_35()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_36()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_144() {
    if (jj_3R_127()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_153()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_143() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_112() {
    if (jj_scan_token(NEW)) return true;
    if (jj_3R_122()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_142()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_143()) {
    jj_scanpos = xsp;
    if (jj_3R_144()) return true;
    }
    return false;
  }

  private boolean jj_3R_85() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    }
    return false;
  }

  private boolean jj_3_34() {
    if (jj_scan_token(NEW)) return true;
    if (jj_3R_77()) return true;
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_3R_79()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_163()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_3R_139()) return true;
    return false;
  }

  private boolean jj_3R_164() {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_127() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_132()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_156() {
    if (jj_3R_164()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_155() {
    if (jj_scan_token(TILDE)) return true;
    return false;
  }

  private boolean jj_3R_126() {
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3R_145() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_155()) jj_scanpos = xsp;
    if (jj_scan_token(LBRACKET)) return true;
    xsp = jj_scanpos;
    if (jj_3R_156()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_148() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_140() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_147()) {
    jj_scanpos = xsp;
    if (jj_3R_148()) return true;
    }
    return false;
  }

  private boolean jj_3R_147() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_133() {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_128() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_30() {
    if (jj_3R_84()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_79()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_33() {
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3_32() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_83() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_31()) {
    jj_scanpos = xsp;
    if (jj_3_32()) {
    jj_scanpos = xsp;
    if (jj_3_33()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_31() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3_29() {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_118() {
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_117() {
    if (jj_3R_84()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_115() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_79()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_114() {
    if (jj_scan_token(BASE)) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_294() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) return true;
    }
    return false;
  }

  private boolean jj_3R_113() {
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3R_89() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_3R_114()) {
    jj_scanpos = xsp;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_3R_117()) {
    jj_scanpos = xsp;
    if (jj_3R_118()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_137() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_76()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_136() {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3_28() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_3R_89()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_29()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_293() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_284()) return true;
    return false;
  }

  private boolean jj_3R_135() {
    if (jj_scan_token(LANGLE)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_292() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_266()) return true;
    return false;
  }

  private boolean jj_3R_290() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_292()) {
    jj_scanpos = xsp;
    if (jj_3R_293()) return true;
    }
    return false;
  }

  private boolean jj_3_27() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_291() {
    if (jj_3R_50()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_294()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_130() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) {
    jj_scanpos = xsp;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_3R_126()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_106() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_82() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_26()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_26() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3_25() {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3_24() {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_289() {
    if (jj_3R_291()) return true;
    return false;
  }

  private boolean jj_3R_288() {
    if (jj_3R_290()) return true;
    return false;
  }

  private boolean jj_3R_287() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) return true;
    }
    if (jj_3R_266()) return true;
    return false;
  }

  private boolean jj_3R_284() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_287()) {
    jj_scanpos = xsp;
    if (jj_3R_288()) {
    jj_scanpos = xsp;
    if (jj_3R_289()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_253() {
    if (jj_scan_token(DECR)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_281() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) return true;
    }
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3R_92() {
    Token xsp;
    if (jj_3R_119()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_119()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_286() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_scan_token(119)) return true;
    }
    }
    if (jj_3R_266()) return true;
    return false;
  }

  private boolean jj_3_23() {
    if (jj_3R_80()) return true;
    return false;
  }

  private boolean jj_3R_252() {
    if (jj_scan_token(INCR)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_277() {
    if (jj_3R_284()) return true;
    return false;
  }

  private boolean jj_3_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(139)) {
    jj_scanpos = xsp;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3_24()) return true;
    }
    }
    if (jj_3R_231()) return true;
    return false;
  }

  private boolean jj_3R_276() {
    if (jj_3R_253()) return true;
    return false;
  }

  private boolean jj_3R_275() {
    if (jj_3R_252()) return true;
    return false;
  }

  private boolean jj_3R_266() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_274()) {
    jj_scanpos = xsp;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_274() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) return true;
    }
    if (jj_3R_266()) return true;
    return false;
  }

  private boolean jj_3R_260() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(106)) return true;
    }
    }
    }
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_243() {
    if (jj_scan_token(138)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_251() {
    if (jj_3R_266()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_286()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_scan_token(BIT_OR)) return true;
    return false;
  }

  private boolean jj_3R_226() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) return true;
    }
    if (jj_3R_178()) return true;
    return false;
  }

  private boolean jj_3R_231() {
    if (jj_3R_251()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_281()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_3R_92()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_93()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_210() {
    if (jj_3R_231()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_22()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_204() {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_172()) return true;
    return false;
  }

  private boolean jj_3R_184() {
    if (jj_3R_210()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_260()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_176() {
    if (jj_scan_token(BIT_OR)) return true;
    if (jj_3R_157()) return true;
    return false;
  }

  private boolean jj_3R_178() {
    if (jj_3R_184()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_243()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_182() {
    if (jj_scan_token(XOR)) return true;
    if (jj_3R_165()) return true;
    return false;
  }

  private boolean jj_3R_169() {
    if (jj_scan_token(SC_AND)) return true;
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_172() {
    if (jj_3R_178()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_226()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_160() {
    if (jj_scan_token(SC_OR)) return true;
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_scan_token(LANGLE)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_165() {
    if (jj_3R_172()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_204()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_151() {
    if (jj_scan_token(HOOK)) return true;
    if (jj_3R_79()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_157() {
    if (jj_3R_165()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_182()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_146() {
    if (jj_3R_157()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_176()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_scan_token(131)) return true;
    return false;
  }

  private boolean jj_3R_138() {
    if (jj_3R_146()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_169()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_91()) jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_131() {
    if (jj_3R_138()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_160()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_5() {
    if (jj_scan_token(LANGLE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_55()) jj_scanpos = xsp;
    if (jj_3R_56()) return true;
    if (jj_scan_token(RANGLE)) return true;
    return false;
  }

  private boolean jj_3R_125() {
    if (jj_3R_131()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_151()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_78() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(127)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) {
    jj_scanpos = xsp;
    if (jj_scan_token(126)) {
    jj_scanpos = xsp;
    if (jj_scan_token(125)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_124() {
    if (jj_scan_token(DELEGATE)) return true;
    if (jj_3R_149()) return true;
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3_21() {
    if (jj_3R_78()) return true;
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_3R_125()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_21()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_79() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) return true;
    }
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_51()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_20() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_3R_57()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_20()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_50()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_3R_50()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3_4() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_3R_54()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3_18() {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_111() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_84() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_3R_111()) return true;
    }
    return false;
  }

  private boolean jj_3R_154() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3_15() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_77() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_16() {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_123() {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_101() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3R_123()) return true;
    }
    return false;
  }

  private boolean jj_3_19() {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_scan_token(LANGLE)) return true;
    if (jj_3R_101()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_154()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RANGLE)) return true;
    return false;
  }

  private boolean jj_3_17() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_18()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_122() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_16()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_17()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_3R_122()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_15()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_99() {
    if (jj_3R_77()) return true;
    Token xsp;
    if (jj_3_14()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_14()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_75() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) return true;
    }
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3_13() {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(102)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_246() {
    if (jj_3R_168()) return true;
    return false;
  }

  private boolean jj_3R_245() {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_228() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_245()) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_149()) return true;
    if (jj_scan_token(LBRACE)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_246()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_265() {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_167() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_166()) return true;
    return false;
  }

  private boolean jj_3R_166() {
    if (jj_3R_88()) return true;
    if (jj_3R_71()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(134)) jj_scanpos = xsp;
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_262() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_185()) return true;
    return false;
  }

  private boolean jj_3R_158() {
    if (jj_3R_166()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_167()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_12() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_264() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_149() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_158()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_249() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_264()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_265()) jj_scanpos = xsp;
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_250() {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_283() {
    if (jj_scan_token(132)) return true;
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3R_170() {
    if (jj_3R_74()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_12()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_230() {
    if (jj_3R_84()) return true;
    if (jj_3R_249()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_250()) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) return true;
    }
    return false;
  }

  private boolean jj_3R_282() {
    if (jj_scan_token(133)) return true;
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3R_261() {
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_248() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_263()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_121() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_170()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(96)) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_211() {
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_247() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_261()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_262()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_104() {
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_97() {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_74() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) return true;
    }
    return false;
  }

  private boolean jj_3R_105() {
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_96()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_80() {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == GT &&
                ((Token.GTToken)getToken(1)).realKind == RSIGNEDSHIFT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_104()) return true;
    if (jj_scan_token(RANGLE)) return true;
    if (jj_scan_token(RANGLE)) return true;
    return false;
  }

  private boolean jj_3R_273() {
    if (jj_scan_token(133)) return true;
    if (jj_3R_180()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_283()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_263() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_272()) {
    jj_scanpos = xsp;
    if (jj_3R_273()) return true;
    }
    return false;
  }

  private boolean jj_3R_272() {
    if (jj_scan_token(132)) return true;
    if (jj_3R_180()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_282()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_81() {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == GT &&
                ((Token.GTToken)getToken(1)).realKind == RUNSIGNEDSHIFT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_105()) return true;
    if (jj_scan_token(RANGLE)) return true;
    if (jj_scan_token(RANGLE)) return true;
    if (jj_scan_token(RANGLE)) return true;
    return false;
  }

  private boolean jj_3R_185() {
    if (jj_3R_72()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_211()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_3R_71()) return true;
    if (jj_3R_72()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_73()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_241() {
    if (jj_scan_token(141)) return true;
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3_10() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_240() {
    if (jj_scan_token(CATCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_166()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_229() {
    if (jj_3R_71()) return true;
    if (jj_3R_72()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_247()) {
    jj_scanpos = xsp;
    if (jj_3R_248()) return true;
    }
    return false;
  }

  private boolean jj_3R_224() {
    if (jj_scan_token(TRY)) return true;
    if (jj_3R_150()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_240()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_241()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_209() {
    if (jj_3R_230()) return true;
    return false;
  }

  private boolean jj_3R_208() {
    if (jj_3R_229()) return true;
    return false;
  }

  private boolean jj_3R_207() {
    if (jj_3R_228()) return true;
    return false;
  }

  private boolean jj_3R_206() {
    if (jj_3R_227()) return true;
    return false;
  }

  private boolean jj_3R_205() {
    if (jj_3R_181()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public CSJavaCCParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[152];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0xa0000fc0,0xc,0x2,0xc,0x0,0xa0000fc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x780,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ffe,0x0,0x0,0x0,0x0,0x0,0x10000000,0x1ffe,0x10000000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0xb0000000,0x0,0xa0000000,0xb0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa0001ffe,0xa0001ffe,0x0,0x0,0x0,0x0,0x0,0xb0000000,0x0,0x0,0xf0001ffe,0xa0000000,0x0,0xa0000000,0x0,0xa0000000,0xa0000000,0xa0000000,0x0,0xa0001ffe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa0001ffe,0x0,0x0,0xa0001ffe,0x0,0x0,0x0,0x0,0x0,0x0,0x1ffe,0x0,0x0,0x0,0xa0001ffe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0001ffe,0xf0001ffe,0xe0001ffe,0x0,0x0,0x0,0xa0001ffe,0x0,0xf0001ffe,0x0,0x0,0xb0001ffe,0xa0001ffe,0xa0001ffe,0xb0001ffe,0xa0001ffe,0x0,0x0,0x0,0xa0001ffe,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x17142104,0x20000000,0x0,0x20000000,0x800,0x17142104,0x7000000,0x7000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x27281008,0x0,0x27201000,0x27281008,0x80008,0x0,0x0,0x0,0x0,0x0,0x373c310c,0x80008,0x10142104,0x373c310c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x50742904,0x50742904,0x0,0x0,0x0,0x0,0x0,0x37343104,0x0,0x0,0xff7d79ac,0x10142104,0x0,0x10142104,0x0,0x10142104,0x10142104,0x10142104,0x0,0x50742904,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x50742904,0x0,0x0,0x50742904,0x40600800,0x0,0x0,0x0,0x0,0x40600800,0x0,0x0,0x400800,0x800,0x50742904,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0xd87569a4,0xff7d79ac,0xd87d69ac,0x0,0x0,0x0,0x50742904,0x41,0xff7d79ac,0x41,0x200,0x77743904,0x50742904,0x50742904,0x77743904,0x50742904,0x0,0x0,0x0,0x50742904,0x2,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x10,0x0,0x0,0x0,0x1004004,0x10,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x8000000,0x0,0x0,0x0,0x4000,0x0,0x0,0x1000000,0x0,0x0,0x28000008,0x2000000,0x0,0x0,0x1000000,0x0,0x0,0x23000000,0x4000,0x0,0x8000000,0x8000000,0x23000000,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80003a80,0x0,0x3a80,0x80003a80,0x0,0x0,0x0,0x0,0x0,0x0,0x80003e90,0x400,0x10,0x80003e90,0x0,0x0,0x88000000,0x0,0x0,0x0,0x0,0x0,0xb844415,0xb844415,0x0,0x88000000,0x0,0x0,0x0,0x3a80,0x0,0x0,0x8b847bff,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x3844415,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3844015,0x0,0x0,0x3844015,0x3844005,0x2000000,0x0,0x0,0x2000000,0x3844005,0x0,0x22000000,0x1844004,0x4,0x3844415,0x0,0x0,0x8000000,0x22000000,0x0,0x20000000,0x20000000,0x100,0x8b84617f,0x8b847bff,0x8b84617f,0x0,0x0,0x0,0x3844015,0x0,0x8b847bff,0x0,0x0,0x3847a95,0x3844415,0x3844015,0x83847a95,0x3844015,0x0,0x0,0x0,0x3844415,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x8,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x1,0x8,0x8,0x0,0x200000,0x0,0x0,0x80,0x200000,0x0,0x0,0x0,0x2,0x8,0x50040,0x50040,0x0,0x0,0x0,0x0,0x0,0x8,0x200000,0x28,0x0,0x1,0x50040,0x50040,0x28,0x20,0x1,0x0,0x20000,0x0,0x0,0x8,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x80,0x8,0x1,0x1,0x8,0x0,0x0,0x8,0x4,0x1,0x5,0x4,0x0,0x0,0x0,0x2,0x3c030,0x3c030,0x1,0x0,0x2,0x8,0x1,0x0,0x0,0x8,0xc000,0x0,0x40,0x0,0x1,0x0,0x0,0x0,0x1,0x3c030,0xff000004,0x40,0x1000,0x2000,0x200000,0x400000,0x100000,0x900,0x900,0x0,0x608,0x608,0x0,0x30000,0x30000,0x8c0000,0x8c0000,0x30000,0x3c030,0x30,0x30,0x0,0x30,0x0,0xc000,0xc000,0x0,0x0,0x0,0x2,0x0,0x0,0x3c030,0x1,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0xc000,0xc000,0xc000,0x1,0xff00c004,0xff00c004,0xc000,0x0,0xc000,0x0,0x0,0xc000,0x3c030,0xc000,0xc000,0xc000,0x1,0x0,0x0,0x3c030,0x0,0x0,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x4000,0x4000,0x0,0x4000,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x4008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x4,0x4,0x4,0x4,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x4000,0x4000,0x0,0x0,0x0,0x0,0x20,0x10,0x30,0x0,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x4000,0x40,0x0,0x4000,0x0,0x0,0x4000,0x0,0x4000,0x0,0x4000,0x0,0x4000,0x380,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x4,0x4,0x800,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x4000,0x4000,0x0,0x380,0x380,0x4000,0x0,0x4000,0x0,0x0,0x4000,0x4000,0x4000,0x4000,0x4000,0x0,0x4000,0x4000,0x4000,0x0,0x2000,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[41];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public CSJavaCCParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public CSJavaCCParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new CSJavaCCParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 152; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 152; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public CSJavaCCParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new CSJavaCCParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 152; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 152; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public CSJavaCCParser(CSJavaCCParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 152; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CSJavaCCParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 152; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[145];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 152; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 145; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 41; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
