using System;

using Fields = edu.neu.ccs.demeterf.Fields;

namespace edu.neu.ccs.demeterf.lib{

    public class RBNode<X> : RBTree<X> where X : IComparable<X>{
        protected readonly RBColor color;
        protected readonly X data;
        protected readonly RBTree<X> left;
        protected readonly RBTree<X> right;
        private readonly int hash;
    
        public RBNode(RBColor color, X data, RBTree<X> left, RBTree<X> right){
            this.color = color;
            this.data = data;
            this.left = left;
            this.right = right;
            hash = data.GetHashCode()+left.GetHashCode()+right.GetHashCode();
        }
        public override String ToString(){ return "RBNode("+color+", "+data+", "+left+", "+right+")"; }
        public override bool Equals(Object o){
            if(!(o is RBNode<X>))return false;
            RBNode<X> oo = (RBNode<X>)o;
            return color.Equals(oo.color)&&
                data.Equals(oo.data)&&
                left.Equals(oo.left)&&
                right.Equals(oo.right);
        }

        public class colorF : Fields.any{}
        public class dataF : Fields.any{}
        public class leftF : Fields.any{}
        public class rightF : Fields.any{}

        public RBColor GetColor(){ return color; }
        public X GetData(){ return data; }
        public RBTree<X> GetLeft(){ return left; }
        public RBTree<X> GetRight(){ return right; }

        public override bool isLeaf(){ return false; }
        public override bool isBlack(){ return color.isBlack(); }
        public override bool isRed(){ return color.isRed(); }
        public override RBNode<X> asNode(){ return this; }

        public override bool contains(X x, Comparison<X> comp){
            int c = comp(x, data);
            if(c < 0)return left.contains(x, comp);
            if(c > 0)return right.contains(x, comp);
            return true;
        }
        public override bool containsAll(RBTree<X> x, Comparison<X> comp){
            if(x.isLeaf())return true;
            RBNode<X> n = x.asNode();
            return (contains(n.data,comp) &&
                    containsAll(n.left,comp) &&
                    containsAll(n.right,comp));
        }
        public override X find(X x, Comparison<X> comp){
            int c = comp(x, data);
            if(c < 0)return left.find(x, comp);
            if(c > 0)return right.find(x, comp);
            return data;
        }
        public override RBTree<X> remove(X x, Comparison<X> comp){ return del(x,comp).makeBlack(); }

        public override RBTree<X> replace(X x, Comparison<X> comp){
            int c = comp(x, data);
            if(c == 0)return node(color,x,left,right);
            if(c < 0)return node(color,data,left.replace(x, comp),right);
            return node(color,data,left,right.replace(x, comp));
        }
        public override int size(){ return 1 + left.size() + right.size(); }


        internal override RBTree<X> del(X x, Comparison<X> comp){
            int c = comp(x,data);
            if(c < 0){
                return left.isBlackNode()?
                    balleft(left.del(x,comp),data,right):
                    node(red(),data,left.del(x,comp),right);
            }
            if(c > 0){
                return right.isBlackNode()?
                    balright(left,data,right.del(x,comp)):
                    node(red(),data,left,right.del(x,comp)); 
            }
            return append(left,right);
        }
        // This should be done better (faster) by passing arguments ("continuation")
        public override List<X> toList(){ return left.toList().append(right.toList().push(data)); }

        internal override RBTree<X> makeBlack(){ return node(black(),data,left,right); }
        internal override RBTree<X> makeRed(){ return node(red(),data,left,right); }
        public override X pred(){ return left.max(); }
        public override X succ(){ return right.min(); }
        public override X min(){ return left.isLeaf()?data:left.min(); }
        public override X max(){ return right.isLeaf()?data:right.min(); }

        internal override RBTree<X> ins(X x, Comparison<X> comp){
            int c = comp(x, data);
            if(c == 0)return this;
            if(color.isBlack()){
                if(c < 0)return balance(data,left.ins(x, comp),right);
                return balance(data,left,right.ins(x, comp));
            }else{
                if(c < 0)return node(red(),data,left.ins(x, comp),right);
                return node(red(),data,left,right.ins(x, comp));
            }
        }

        public override int GetHashCode(){ return hash; }
    }

    

}
