namespace edu.neu.ccs.demeterf.lib{

using System;
using System.Collections.Generic;

/** Representation of NESepList<Syn, X>, a non-empty separated list without syntax */
public class NESepList<Syn, X> : SepList<Syn, X>{
    protected readonly X first;
    protected readonly PESepList<Syn, X> rest;

    /** Construct a(n) NESepList<Syn, X> Instance */
    public NESepList(X first, PESepList<Syn, X> rest){
        this.first = first;
        this.rest = rest;
    }
    /** Is the given object Equal to this NESepList? */
    public bool Equals(Object o){
        if(!(o is NESepList<Syn, X>))return false;
        if(o == this)return true;
        NESepList<Syn, X> oo = (NESepList<Syn, X>)o;
        return (((Object)first).Equals(oo.first))&&(((Object)rest).Equals(oo.rest));
    }

    /** Field Class for NESepList.first */
    public class firstF : edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for NESepList.rest */
    public class restF : edu.neu.ccs.demeterf.Fields.any{}

    /** Is this list Empty? */
    public override bool isEmpty(){ return false; }
    /** Get the first element, if it exists */
    public override X top(){ throw new Exception("Bad Top"); }
    /** Get the first element, if it exists */
    public override SepList<Syn,X> pop(){ throw new Exception("Bad Pop"); }
    
    /** Does this list currently contain Syntax? */
    public override bool hasSyntax(){ return rest.hasSyntax(); }
    /** Get the first instance of syntax, if it exists */
    public override Syn topSyntax(){ return rest.topSyntax(); }
    
    /** Convert this (non-empty) SepList into a regular List */
    public override List<X> toList(){ return rest.toList().push(first); }
    /** Push a new element on this SepList */
    public override SepList<Syn,X> push(X x, Syn s)
    { return new NESepList<Syn,X>(x,new ConsS<Syn,X>(s,first,rest)); }
    /** Reverse this SepList */
    public override SepList<Syn,X> reverse(){
        if(!rest.hasSyntax())return this;
        return reverse(SepList<Syn,X>.create(), rest.topSyntax());
    }
    /** Reverse this SepList */
    public override SepList<Syn,X> reverse(SepList<Syn,X> acc, Syn s){
        return rest.reverse(acc.push(first, s), s);    
    }
    
    /** The Length of This List */
    public override int length(){ return 1+rest.length(); }
    /** Lookup the i^th item in this List */
    public override X lookup(int i){ return i==0?first:rest.lookup(i-1); }
    /** To String, with a separator and prefix */
    public override String ToString(){ return first+rest.ToString(); }
}

}