using System;
using System.Collections.Generic;

using Fields = edu.neu.ccs.demeterf.Fields;

namespace edu.neu.ccs.demeterf.lib{


/** Represents a Set of comparable Elements, implemented with Lists. */
    public class ListSet<X> : IEnumerable<X>{
    protected readonly List<Wrap<X>> list;
    private readonly Comparison<X> comp;
    
    /** Field Class */
    public class listF : Fields.any{}
    
    /** Construct a Set from a List with a separate Comparison.  Duplicates will be ignored. */
    private ListSet(List<X> l, Comparison<X> c)
        : this(c,l.map(new Set<X>.Wrapper(c)).removeDuplicates().sort(new Wrap<X>.LComp())) { }
    
    /** Construct a Set from a List of <tt>IComparable</tt> elements.  Duplicates
     *    will be ignored. Left Public to support Parsing */
    public ListSet(List<Wrap<X>> l) : this(Wrap<X>.CComp, l.removeDuplicates().sort(new Wrap<X>.LComp())) { }
    
    /** Construct the <i>empty</i> Set of IComparable elements. */
    public static ListSet<X> create<X>() where X : IComparable<X> { return new ListSet<X>(List<Wrap<X>>.create()); }
    /** Construct the <i>empty</i> Set with a separate Comparison. */
    public static ListSet<X> create(Comparison<X> c){ return new ListSet<X>(c,List<Wrap<X>>.create()); }
    /** Construct a Set from a List of <tt>IComparable</tt> elements.  Duplicates will be ignored. */
    public static ListSet<X> create<X>(List<X> l) where X : IComparable<X> 
    { return new ListSet<X>(l, Wrap<X>.CComp); }
    /** Construct a Set from a List with a separate Comparison.  Duplicates will be ignored. */
    public static ListSet<X> create(List<X> l, Comparison<X> c){ return new ListSet<X>(l,c); }
    /** Construct a Set from a number of <tt>IComparable</tt> elements.  Duplicates will be ignored. */
    public static ListSet<X> create<X>(params X[] xs) where X : IComparable<X> 
    { return new ListSet<X>(List<X>.create(xs),Wrap<X>.CComp); }
    
    
    // Private Creators... reverse the order since the list/tree will be Wrapped elements
    private ListSet(Comparison<X> c, List<Wrap<X>> l){ comp = c; list = l; }
    private ListSet<X> make(List<Wrap<X>> lst){ return new ListSet<X>(comp,lst); }
    private List<Wrap<X>> toWrapList(){ return list; }
    
    /** Is the given element present in this Set? */
    public bool contains(X x){ return list.contains(new Wrap<X>(x,comp)); }
    /** Is this set <i>empty</i>? */
    public bool isEmpty(){ return list.isEmpty(); }
    /** Return the nuber of elements in this Set */
    public int size(){ return list.length(); }
    /** Returns a new Set that also contains the given element. */
    public ListSet<X> add(X x){
        Wrap<X> w = new Wrap<X>(x,comp);
        return list.contains(w) ? this : make(list.insert(new Wrap<X>(x,comp), new Wrap<X>.LComp()));
    }
    /** Returns a new Set that no longer contains the given element. */
    public ListSet<X> remove(X x){ return make(list.remove(new Wrap<X>(x,comp))); }
    /** Is this Set a <i>subset</i> of (or equal to) the given set? */
    public bool subseteq(ListSet<X> s){ return s.list.containsAll(this.list); }
    
    class InList : List<Wrap<X>>.Pred{
        List<Wrap<X>> l;
        public InList(List<Wrap<X>> ll){ l = ll; }
        public override bool huh(Wrap<X> x){ return l.contains(x); }
    }
    /** Returns a new Set that is the <i>union</i> of <b>this</b> and the given Set. */
    public ListSet<X> union(ListSet<X> s){
        return make(list.insert(s.list.filterout(new InList(s.list)), new Wrap<X>.LComp()));
    }
    /** Returns a new Set that is the <i>intersection</i> of <b>this</b> and the given Set. */
    public ListSet<X> intersect(ListSet<X> s){
        return make(toWrapList().filter(new InList(s.list)));
    }
    /** Returns a new Set that is the <i>difference</i> of <b>this</b> and the given Set. */
    public ListSet<X> difference(ListSet<X> s){
        return make(toWrapList().filterout(new InList(s.list)));
    }
    /** Returns this Set as a List, in the order defined by the Comparison. */
    public List<X> toList(){ return toWrapList().map(new Set<X>.UnWrapper()); }
    
    /** Returns an iterator for this Set, in the order defined by the Comparator. */
    public IEnumerator<X> GetEnumerator(){ return toList().GetEnumerator(); }
    /** Returns an iterator for this Set, in the order defined by the Comparator. */
    System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator(){ return GetEnumerator(); }
    
    class Merger : List<Wrap<X>>.Fold<List<Wrap<X>>>{
        Set<X>.Merge m;
        Comparison<X> comp;
        public Merger(Set<X>.Merge mm, Comparison<X> c){ m = mm; comp = c; }
        public override List<Wrap<X>> fold(Wrap<X> w, List<Wrap<X>> r){
            if(!r.contains(w))return r.insert(w, new Wrap<X>.LComp());
            int i = r.index(w);
            return r.replace(i,new Wrap<X>(m.merge(w.GetX(),r.lookup(i).GetX()),comp));
        }
    }
    /** Merge two sets with like elements merged by the given function object */
    public ListSet<X> merge(ListSet<X> s, Set<X>.Merge m){
        return make(s.toWrapList().fold(new Merger(m,comp), list));
    }
    /** Merge a single element merged by the given function object */
    public ListSet<X> merge(X x, Set<X>.Merge m){
        Wrap<X> w = new Wrap<X>(x,comp);
        if(!list.contains(w))return make(list.insert(w, new Wrap<X>.LComp()));
        int i = list.index(w);
        return make(list.replace(i,new Wrap<X>(m.merge(w.GetX(),list.lookup(i).GetX()),comp)));
    }
    
    /** Set equality (s == t) is (s.subset(t) && t.subset(s)). */
    public override bool Equals(Object o){
        if(!(o is ListSet<X>))return false;
        ListSet<X> s = (ListSet<X>)o;
        return (s.size() == this.size() && list.Equals(s.list));
    }
    /** Produce a string representation of this Set. */
    public override String ToString(){ return "{ "+toList().ToString(" ","")+" }"; }
    
    /** Return the combined underlying elements HashCode */
    public override int GetHashCode(){ return list.GetHashCode(); }
}

}