namespace edu.neu.ccs.demeterf.http.server{
using System;

/** Attach a Server method to a given (relative) Path.  The signature
 *    of the method must be one of:
 *    <ul>
 *        <li><tt>public HTTPResp method()</tt></li>
 *        <li><tt>public HTTPResp method(HTTPReq)</tt></li></li>
 *        <li><tt>public HTTPResp method(HTTPReq, System.Net.Sockets.Socket)</tt></li></li>
 *    </ul>
 *  If no value is given (e.g., <tt>@Path()</tt>) then the method will
 *    become the default for unknown requests. 
 */

[AttributeUsage(AttributeTargets.Method)]
public class Path : System.Attribute{
    public readonly string value;
    public Path(string v){ value = v; }
    public Path() : this(EMPTY){}

    public static readonly string EMPTY = "";
}

}