using System;
using System.Collections.Generic;
using System.Reflection;
using edu.neu.ccs.demeterf.util;

namespace edu.neu.ccs.demeterf.dispatch {
    public class DBEntry<M> {
        M method;
        Type declT;
        String name;
        Type[] argTs;
        Type retT;

        //public DBEntry(MethodInfo m) : this(m, m.Name, parameterTypes(m), m.ReturnType) { }
        public DBEntry(M m, Type d, String n, Type[] aTs, Type rT) {
            method = m; declT = d;  name = n; argTs = aTs; retT = rT;
        }
        public Type arg(int i){
            if(i >= argTs.Length)
                return Util.objectType;
            return argTs[i];
        }
        public Type retType(int i){ return retT; }
        public M getMethod() { return method; }
        public int numArgs() { return argTs.Length; }
        public Type[] getArgs() { return argTs; }
        public string getName() { return name; }
        public Type declaringType() { return declT; }

        public override int GetHashCode() {
            return argTs.GetHashCode()+7*retT.GetHashCode()+5*name.GetHashCode();
        }
        public override bool Equals(object o) {
            if(o == null || GetType() != o.GetType()) return false;
            DBEntry<M> e = (DBEntry<M>)o;
            return ((name == e.name) && argTs.Equals(e.argTs) && retT.Equals(e.retT));
        }
        public override String ToString() {
            String ret = retT.Name+" "+name+"(";
            for(int i = 0; i < argTs.Length; i++) {
                ret += argTs[i].Name;
                if(i < argTs.Length-1) ret += ", ";
            }
            return ret+")";
        }
    }
}
