using System;
using Control = edu.neu.ccs.demeterf.Control;

namespace edu.neu.ccs.demeterf.control{

    public abstract class MutableControl : Control{
        /** Adds the given Class/Field to be Bypassed */
        public abstract void addBypassing(Type t, String f);
        /** Adds the given Edge to be Bypassed */
        public abstract void addBypassing(Edge e);
        /** Adds all immediate fields of the given Class to be Bypassed */
        public abstract void addBypassing(Type t);
    
        /** Adds the given Class as a Builtin */
        public abstract MutableControl addBuiltIn(Type t);
        /** Add a Number of Classes to be considered Primitives */
        public abstract MutableControl addBuiltIns(params Type[] ts);
    
    }

}