using System;

using System.Reflection;
using Util = edu.neu.ccs.demeterf.util.Util;
using edu.neu.ccs.demeterf.lib;

namespace edu.neu.ccs.demeterf.control{

    public class EdgeBypass : MutableControl{
        // List of Primitive Classes
        protected List<Edge> skiplist = List<Edge>.create();
        public EdgeBypass(){}
        public EdgeBypass(params Edge[] edges){
            skiplist = List<Edge>.create(edges);
        }

        public EdgeBypass(params Type[] ts){
            foreach(Type t in ts)
                addBypassing(t);
        }
        public EdgeBypass(String bypass){ skiplist = init("", bypass); }
        public EdgeBypass(String pkg, String bypass){ skiplist = init(pkg+".", bypass); }

        protected static List<Edge> init(String pkg, String bypass){ return init(pkg,bypass.Split(' ')); }
        protected static List<Edge> init(String pkg, params String[] bypass){
            if(pkg.Length > 0 && pkg[pkg.Length-1] != '.')pkg += ".";
            List<Edge> edges = List<Edge>.create();
            foreach(String s in bypass){
                int dot = s.LastIndexOf(".");
                String name = pkg+s.Substring(0,dot);
                Type t = Type.GetType(name);
                if(t == null) t = Assembly.GetCallingAssembly().GetType(name);
                if(t == null) t = Assembly.GetExecutingAssembly().GetType(name);
                if(t == null) throw new Exception("Type Not Found: \""+name+"\"");
                edges = edges.push(new Edge(t,s.Substring(dot+1)));
            }
            return edges;
        }
        public override void addBypassing(Type t, String f){ addBypassing(new Edge(t,f)); }
        public override void addBypassing(Edge e){ skiplist = skiplist.push(e); }
        
        public override void addBypassing(Type t) { 
            foreach(FieldInfo f in Util.getFuncFields(t))
                addBypassing(new Edge(t,f.Name));
        }

        public override MutableControl addBuiltIn(Type t) { builtInList.Add(t); return this; }
        public override MutableControl addBuiltIns(params Type[] ts) {
            foreach(Type t in ts)builtInList.Add(t); return this;
        }

        public override bool skip(Type t, String f) { return skip(new Edge(t, f)); }
        public override bool skip(Edge e){ return skiplist.contains(e); }

        public override bool ignore(Type c, String f){ return false; }
        public override bool ignore(Edge e){ return false; }
    }
}