using System;
using System.Reflection;
using edu.neu.ccs.demeterf.util;

namespace edu.neu.ccs.demeterf.control {
    public class Edge {
        private static bool check = false;//true;
        Type host;
        String field;

        // Give the Class and the Field Name
        public Edge(Type h, String fn){
            if(check){
                bool good = false;
                foreach(FieldInfo f in Util.getFuncFields(h))
                    if(f.Name == fn){
                        good = true;
                        break;
                    }
                if(!good)
                    throw new Exception("Invalid Edge Specified: "+h.Name+"."+fn);
            }
            host = h; field = fn;
        }
        public Type getHost(){ return host; }
        public String getFieldName(){ return field; }
        public override bool Equals(object obj){
            if(!(obj is Edge))return false;
            Edge e = (Edge)obj;
            return e.host == host && e.field == field;
        }
        public override int GetHashCode() {
            return base.GetHashCode();
        }
    }
}
