package cs3500.turtle.view;

import cs3500.turtle.model.Position2D;
import cs3500.turtle.tracingmodel.Line;

import javax.swing.JPanel;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;

public class TurtlePanel extends JPanel {
  List<Line> curLines;
  double headingDegrees;
  Position2D pos;

  void setLines(List<Line> lines) {
    curLines = lines;
  }
  void setHeading(double heading) {
    this.headingDegrees = heading;
  }
  void setPosition(Position2D pos) {
    this.pos = pos;
  }

  TurtlePanel() {
    this.curLines = new ArrayList<>();
    this.pos = new Position2D(-1, -1);
  }
  @Override
  protected void paintComponent(Graphics g) {
    super.paintComponent(g);

    // TODO: Fill this in to draw the lines
    // Note: generally a good idea to copy the existing graphics
    // so that if you change its state (color, transform, etc)
    // you won't modify the original `g` that was passed in.
    Graphics2D g2d = (Graphics2D) g.create();
    Rectangle bounds = this.getBounds(null);

    // This would move the origin to the middle of the window
    //    g2d.translate(bounds.width / 2, bounds.height / 2);
    g2d.translate(0, bounds.height);
    g2d.scale(1, -1);

    drawLines(g2d);
    drawTurtle(g2d);

    // calibrate(g2d, bounds);
    // Use methods on the Graphics2D class to drawOval or fillOval,
    // drawLine, getColor, setColor, getTransform,
    // translate, scale, rotate, etc...
  }

  private void drawTurtle(Graphics2D g2d) {
    Color oldColor = g2d.getColor();
    AffineTransform oldTransform = g2d.getTransform();
    g2d.setColor(Color.GREEN);
    drawCircle((int) pos.getX(), (int) pos.getY(), 3, g2d, Color.GREEN);
    g2d.translate(pos.getX(), pos.getY());
    g2d.rotate(Math.toRadians(headingDegrees));
    g2d.drawLine(0, 0, 20, 0);
    g2d.setTransform(oldTransform);
    g2d.setColor(oldColor);
  }

  void drawLines(Graphics2D g2d) {
    for (Line l : curLines) {
      g2d.drawLine((int) l.start.getX(), (int) l.start.getY(), (int) l.end.getX(), (int) l.end.getY());
    }
  }

  private void calibrate(Graphics2D g2d, Rectangle bounds) {
    g2d.setColor(Color.BLUE);
    g2d.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height);
    g2d.setColor(Color.RED);
    g2d.drawLine(bounds.x + bounds.width, bounds.y, bounds.x, bounds.y + bounds.height);
    drawCircle(0, 0, 20, g2d, Color.RED);
    drawCircle(400, 0, 20, g2d, Color.BLUE);
    drawCircle(0, 400, 20, g2d, Color.YELLOW);
    drawCircle(400, 400, 20, g2d, Color.GREEN);
  }

  private void drawCircle(int centerX, int centerY, int radius, Graphics2D g2d, Color c) {
    Color oldColor = g2d.getColor();
    g2d.setColor(c);
    g2d.fillOval(centerX - radius, centerY - radius, 2 * radius, 2 * radius);
    g2d.setColor(oldColor);
  }

}
