
import org.junit.Before;
import org.junit.Test;

import cs3500.temperature.CelsiusTemperature;
import cs3500.temperature.FahrenheitTemperature;
import cs3500.temperature.Temperature;

import static org.junit.Assert.assertEquals;

/**
 * Tests for Temperature, both Celsius and Fahrenheit representations.
 */
public class TemperatureTest {

  private Temperature cTemp;
  private Temperature fTemp;

  @Before
  public void init() {
    cTemp = new CelsiusTemperature(100);
    fTemp = new FahrenheitTemperature(100, true);
  }

  @Test(expected = IllegalArgumentException.class)
  public void testForInvalidTemperature() {
    Temperature x = new CelsiusTemperature(-1000);
  }

  @Test(expected = IllegalArgumentException.class)
  public void testForInvalidFTemp() {
    new FahrenheitTemperature(-1000);
  }

  @Test(expected = IllegalArgumentException.class)
  public void testForInvalidCTempOnF() {
    new FahrenheitTemperature(-1000, true);
  }

  @Test
  public void testObservers() {
    assertEquals(100, cTemp.inCelsius(), 0.001);
    assertEquals(212, cTemp.inFahrenheit(), 0.001);
    assertEquals(373.15, cTemp.inKelvin(), 0.001);
  }

  @Test
  public void testInF() {
    assertEquals(212, fTemp.inFahrenheit(), 0.001);
  }

  @Test
  public void testAverage() {
    assertEquals(124.7, cTemp.average(new CelsiusTemperature(3)).inFahrenheit(), 0.001);
    assertEquals(100, cTemp.average(cTemp).inCelsius(), 0.001);
  }

  @Test
  public void testHashCodeEquals() {
    Temperature f = new FahrenheitTemperature(212);
    assertEquals(f, cTemp);
    assertEquals(f.hashCode(), cTemp.hashCode());
  }

  @Test
  public void testToString() {
    assertEquals("100.0° Celsius", cTemp.toString());
    assertEquals("212.0° Fahrenheit", fTemp.toString());
  }
}
