package cs3500.lec11;


import org.openjdk.jmh.annotations.*;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

/**
 * Benchmarks for string accumulators.
 */

@BenchmarkMode(Mode.AverageTime)
@OutputTimeUnit(TimeUnit.NANOSECONDS)
@Warmup(iterations = 6, time = 1, timeUnit = TimeUnit.SECONDS)
@Measurement(iterations = 6, time = 1, timeUnit = TimeUnit.SECONDS)
@Fork(1)
@State(Scope.Benchmark)
public class StringAccumulatorBench {
  @Param({ "1000", "2000", "3000", "4000" }) int length;
  @Param({
    "StringBuilder",
    "StringBuffer",
    "DoublingArrayStringAccumulator",
    "ExactArrayStringAccumulator",
    "LinearArrayStringAccumulator",
    "StringStringAccumulator"
  }) String impl;

  private final Map<String, Supplier<Appendable>> classes = Map.of(
          "StringBuilder", StringBuilder::new,
          "StringBuffer", StringBuffer::new,
          "DoublingArrayStringAccumulator", DoublingArrayStringAccumulator::new,
          "ExactArrayStringAccumulator", ExactArrayStringAccumulator::new,
          "LinearArrayStringAccumulator", LinearArrayStringAccumulator::new,
          "StringStringAccumulator", StringStringAccumulator::new,
          "PreallocArrayStringAccumulator", PreallocArrayStringAccumulator::new
  );


  @Benchmark
  public String timeAccumulation() throws IOException
  {
    Appendable acc = classes.get(impl).get();

    for (int j = 0; j < length; ++j) {
      acc.append((char) j);
    }

    return acc.toString();
  }

  public static void main(String[] args) throws RunnerException {
    Options opt = new OptionsBuilder()
            .include(StringAccumulatorBench.class.getSimpleName())
            .forks(1)
            .jvmArgs(args)
            .addProfiler(GCProfiler.class)
            .resultFormat(ResultFormatType.JSON)
            .result("bench/stringaccumulator-result.json")
            .build();

    new Runner(opt).run();

    // NOTE: Go to https://jmh.morethan.io/, and drop bench/stringaccumulator-result.json into it to visualize
  }
}
