package cs3500.lec11;

import cs3500.hw01.duration.Duration;
import cs3500.hw01.duration.HmsDuration;
import org.openjdk.jmh.annotations.*;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import java.util.concurrent.TimeUnit;

/**
 * Benchmarks for string accumulators.
 */
@BenchmarkMode(Mode.AverageTime)
@OutputTimeUnit(TimeUnit.NANOSECONDS)
@Warmup(iterations = 5, time = 1, timeUnit = TimeUnit.SECONDS)
@Measurement(iterations = 5, time = 1, timeUnit = TimeUnit.SECONDS)
@Fork(1)
@State(Scope.Benchmark)
public class DurationFormatBench {
  @Param({ "1000", "2000", "3000", "4000" }) int length;
  @Param({
    "DoublingArrayStringAccumulator",
    "ExactArrayStringAccumulator",
    "LinearArrayStringAccumulator",
    "PreallocArrayStringAccumulator",
    "StringStringAccumulator"
  }) String impl;

  private String template;
  private Duration duration;
  private Class<?> accClass;

  @Setup
  public void setUp() throws ClassNotFoundException {
    char[] templateArray = new char[length];

    for (int i = 0; i < length; ++i) {
      if (i % 50 == 0 && i + 1 < length) {
        templateArray[i] = '%';
      } else {
        templateArray[i] = 's';
      }
    }

    template = String.valueOf(templateArray);
    duration = new HmsDuration(4, 5, 6);
    accClass = Class.forName("stringAccumulator." + impl);
  }

  @Benchmark
  public String timeFormat()
    throws IllegalAccessException,  InstantiationException
  {

    StringAccumulator acc = (StringAccumulator) accClass.newInstance();
    duration.format(acc, template);
    return acc.stringValue();
  }

  public static void main(String[] args) throws RunnerException {
    Options opt = new OptionsBuilder()
            .include(DurationFormatBench.class.getSimpleName())
            .forks(1)
            .jvmArgs(args)
            .addProfiler(GCProfiler.class)
            .resultFormat(ResultFormatType.JSON)
            .result("bench/durationformat-result.json")
            .build();

    new Runner(opt).run();

    // NOTE: Go to https://jmh.morethan.io/, and drop jmh-result.json into it to visualize
  }}
