package cs3500.turtle.view;

import cs3500.turtle.model.Position2D;
import cs3500.turtle.tracingmodel.Line;

import javax.swing.JPanel;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;

public class TurtlePanel extends JPanel {
  List<Line> curLines;
  double headingDegrees;
  Position2D pos;

  TurtlePanel() {
    this.curLines = new ArrayList<>();
    this.pos = new Position2D(-1, -1);
  }
  @Override
  protected void paintComponent(Graphics g) {
    super.paintComponent(g);

    Graphics2D g2d = (Graphics2D) g;

    AffineTransform oldTransform = g2d.getTransform();
    Color oldColor = g2d.getColor();
    g2d.setColor(Color.RED);

    // Invert coordinates so origin is at bottom-left and +y is up
    g2d.translate(0, this.getHeight());
    g2d.scale(1, -1);

    for (Line l : this.curLines) {
      g2d.drawLine(
              (int)l.start.getX(), (int)l.start.getY(),
              (int)l.end.getX(), (int)l.end.getY());
    }

    g2d.translate(pos.getX(), pos.getY());
    g2d.fillOval(-2, -2, 4, 4);
    g2d.rotate(Math.toRadians(headingDegrees));
    g2d.setColor(Color.BLACK);
    g2d.fillOval(-7, -5, 10, 10);

    g2d.setColor(oldColor);
    g2d.setTransform(oldTransform);

  }

  void setHeading(double headingDegrees) {
    this.headingDegrees = headingDegrees;
  }

  void setPosition(Position2D position) {
    this.pos = position;
  }

  void setLines(List<Line> lines) {
    this.curLines = lines;
  }
}
